/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.surveyor;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import folk.sisby.surveyor.landmark.Landmark;
import folk.sisby.surveyor.landmark.LandmarkType;
import folk.sisby.surveyor.landmark.SimpleLandmarkType;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import net.rasanovum.viaromana.CommonConfig;
import net.rasanovum.viaromana.path.Node;
import net.rasanovum.viaromana.path.PathGraph;
import net.rasanovum.viaromana.storage.IPathStorage;

public record ViaRomanaLandmark(BlockPos pos, Component name, DyeColor color) implements Landmark<ViaRomanaLandmark>
{
    public static final LandmarkType<ViaRomanaLandmark> TYPE = new SimpleLandmarkType(ResourceLocation.parse((String)"via_romana:destination_landmark"), pos -> RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.optionalFieldOf("name").forGetter(landmark -> Optional.ofNullable(landmark.name()).map(Component::getString)), (App)Codec.STRING.optionalFieldOf("color").forGetter(landmark -> Optional.ofNullable(landmark.color()).map(DyeColor::getName))).apply((Applicative)instance, (nameStr, colorStr) -> new ViaRomanaLandmark((BlockPos)pos, nameStr.map(Component::literal).orElse(null), colorStr.map(name -> DyeColor.byName((String)name, (DyeColor)DyeColor.BROWN)).orElse(DyeColor.BROWN)))));

    public static ViaRomanaLandmark createDestination(ServerLevel level, Node node, BlockPos pos) {
        DyeColor color;
        Component name = (Component)node.getDestinationName().map(Component::literal).orElse(Component.literal((String)"Via Romana Destination"));
        if (CommonConfig.enable_surveyor_landmark_coloring) {
            IPathStorage storage = IPathStorage.get((Level)level);
            PathGraph graph = storage.graph();
            color = graph.getNetworkColor(node);
        } else {
            color = DyeColor.BROWN;
        }
        return new ViaRomanaLandmark(pos, name, color);
    }

    public LandmarkType<ViaRomanaLandmark> type() {
        return TYPE;
    }
}

