/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.surveyor;

import folk.sisby.surveyor.WorldSummary;
import folk.sisby.surveyor.terrain.WorldTerrainSummary;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import net.rasanovum.viaromana.ViaRomana;

public class SurveyorUtil {
    public static WorldTerrainSummary getTerrain(ServerLevel level) {
        try {
            WorldTerrainSummary terrain = WorldSummary.of((Level)level).terrain();
            if (terrain == null) {
                ViaRomana.LOGGER.error("SurveyorUtil: Surveyor terrain data is null for level: " + String.valueOf(level.dimension().location()));
            }
            return terrain;
        }
        catch (Exception e) {
            ViaRomana.LOGGER.error("SurveyorUtil: Failed to get Surveyor terrain: " + e.getMessage());
            return null;
        }
    }

    public static void refreshChunkTerrain(ServerLevel level, ChunkPos pos) {
        try {
            WorldTerrainSummary terrain = SurveyorUtil.getTerrain(level);
            if (terrain == null) {
                return;
            }
            ServerChunkCache chunkSource = level.getChunkSource();
            LevelChunk chunk = chunkSource.getChunkNow(pos.x, pos.z);
            if (chunk != null) {
                terrain.put((Level)level, chunk);
            }
        }
        catch (Throwable t) {
            ViaRomana.LOGGER.debug("SurveyorUtil: Failed to refresh terrain for {} in {}: {}", (Object)pos, (Object)level.dimension().location(), (Object)t.toString());
        }
    }
}

