/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.network.packets;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.rasanovum.viaromana.map.MapInfo;
import net.rasanovum.viaromana.network.packets.DestinationResponseS2C;

public record MapResponseS2C(MapInfo mapInfo) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<MapResponseS2C> TYPE = new CustomPacketPayload.Type(ResourceLocation.parse((String)"via_romana:map_response_s2c"));
    public static final StreamCodec<FriendlyByteBuf, MapResponseS2C> STREAM_CODEC = new StreamCodec<FriendlyByteBuf, MapResponseS2C>(){

        public MapResponseS2C decode(FriendlyByteBuf buffer) {
            return new MapResponseS2C(MapInfo.readFromBuffer(buffer));
        }

        public void encode(FriendlyByteBuf buffer, MapResponseS2C packet) {
            packet.mapInfo.writeToBuffer(buffer);
        }
    };

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static MapResponseS2C create(UUID networkId, BlockPos minBounds, BlockPos maxBounds, byte[] pngData, int bakeScaleFactor) {
        return new MapResponseS2C(MapInfo.response(networkId, minBounds, maxBounds, new ArrayList<DestinationResponseS2C.NodeNetworkInfo>(), pngData, bakeScaleFactor));
    }

    public static MapResponseS2C create(UUID networkId, BlockPos minBounds, BlockPos maxBounds, List<DestinationResponseS2C.NodeNetworkInfo> networkNodes, byte[] pngData, int bakeScaleFactor) {
        return new MapResponseS2C(MapInfo.response(networkId, minBounds, maxBounds, networkNodes, pngData, bakeScaleFactor));
    }

    public UUID getNetworkId() {
        return this.mapInfo.networkId();
    }

    public BlockPos getMinBounds() {
        return this.mapInfo.minBounds();
    }

    public BlockPos getMaxBounds() {
        return this.mapInfo.maxBounds();
    }

    public byte[] getPngData() {
        return this.mapInfo.pngData() != null ? (byte[])this.mapInfo.pngData().clone() : null;
    }

    public int getBakeScaleFactor() {
        return this.mapInfo.bakeScaleFactor();
    }

    public List<DestinationResponseS2C.NodeNetworkInfo> getNetworkNodes() {
        return this.mapInfo.networkNodes();
    }

    public MapInfo getMapInfo() {
        return this.mapInfo;
    }
}

