/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.network.packets;

import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.rasanovum.viaromana.map.MapInfo;
import net.rasanovum.viaromana.network.packets.DestinationResponseS2C;

public record MapRequestC2S(MapInfo mapInfo) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<MapRequestC2S> TYPE = new CustomPacketPayload.Type(ResourceLocation.parse((String)"via_romana:map_request_c2s"));
    public static final StreamCodec<FriendlyByteBuf, MapRequestC2S> STREAM_CODEC = new StreamCodec<FriendlyByteBuf, MapRequestC2S>(){

        public MapRequestC2S decode(FriendlyByteBuf buffer) {
            return new MapRequestC2S(MapInfo.readFromBuffer(buffer));
        }

        public void encode(FriendlyByteBuf buffer, MapRequestC2S packet) {
            packet.mapInfo.writeToBuffer(buffer);
        }
    };

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static MapRequestC2S create(UUID networkId, BlockPos minBounds, BlockPos maxBounds, List<DestinationResponseS2C.NodeNetworkInfo> networkNodes) {
        return new MapRequestC2S(MapInfo.request(networkId, minBounds, maxBounds, networkNodes));
    }

    public UUID getNetworkId() {
        return this.mapInfo.networkId();
    }

    public BlockPos getMinBounds() {
        return this.mapInfo.minBounds();
    }

    public BlockPos getMaxBounds() {
        return this.mapInfo.maxBounds();
    }

    public List<DestinationResponseS2C.NodeNetworkInfo> getNetworkNodes() {
        return this.mapInfo.networkNodes();
    }

    public MapInfo getMapInfo() {
        return this.mapInfo;
    }
}

