/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.network.packets;

import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.rasanovum.viaromana.core.LinkHandler;
import net.rasanovum.viaromana.path.Node;

public record LinkSignRequestC2S(LinkHandler.LinkData linkData, boolean isTempNode) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<LinkSignRequestC2S> TYPE = new CustomPacketPayload.Type(ResourceLocation.parse((String)"via_romana:link_sign_request"));
    public static final StreamCodec<FriendlyByteBuf, LinkSignRequestC2S> STREAM_CODEC = new StreamCodec<FriendlyByteBuf, LinkSignRequestC2S>(){

        public LinkSignRequestC2S decode(FriendlyByteBuf buffer) {
            BlockPos nodePos = buffer.readBlockPos();
            BlockPos signPos = buffer.readBlockPos();
            Node.LinkType linkType = (Node.LinkType)buffer.readEnum(Node.LinkType.class);
            UUID owner = buffer.readBoolean() ? buffer.readUUID() : null;
            String destinationName = buffer.readUtf();
            Node.Icon icon = (Node.Icon)buffer.readEnum(Node.Icon.class);
            LinkHandler.LinkData linkData = new LinkHandler.LinkData(signPos, nodePos, linkType, icon, destinationName, owner);
            boolean isTempNode = buffer.readBoolean();
            return new LinkSignRequestC2S(linkData, isTempNode);
        }

        public void encode(FriendlyByteBuf buffer, LinkSignRequestC2S packet) {
            buffer.writeBlockPos(packet.linkData.nodePos());
            buffer.writeBlockPos(packet.linkData.signPos());
            buffer.writeEnum((Enum)packet.linkData.linkType());
            buffer.writeBoolean(packet.linkData.owner() != null);
            if (packet.linkData.owner() != null) {
                buffer.writeUUID(packet.linkData.owner());
            }
            buffer.writeUtf(packet.linkData.destinationName());
            buffer.writeEnum((Enum)packet.linkData.icon());
            buffer.writeBoolean(packet.isTempNode);
        }
    };

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

