/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.network.packets;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.rasanovum.viaromana.path.Node;

public record ChartedPathC2S(List<Node.NodeData> chartedNodes) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ChartedPathC2S> TYPE = new CustomPacketPayload.Type(ResourceLocation.parse((String)"via_romana:charted_path_c2s"));
    public static final StreamCodec<FriendlyByteBuf, ChartedPathC2S> STREAM_CODEC = new StreamCodec<FriendlyByteBuf, ChartedPathC2S>(){

        public ChartedPathC2S decode(FriendlyByteBuf buffer) {
            int nodeCount = buffer.readInt();
            ArrayList<Node.NodeData> chartedNodes = new ArrayList<Node.NodeData>(nodeCount);
            for (int i = 0; i < nodeCount; ++i) {
                BlockPos pos = buffer.readBlockPos();
                float quality = buffer.readFloat();
                float clearance = buffer.readFloat();
                chartedNodes.add(new Node.NodeData(pos, quality, clearance));
            }
            return new ChartedPathC2S(chartedNodes);
        }

        public void encode(FriendlyByteBuf buffer, ChartedPathC2S packet) {
            buffer.writeInt(packet.chartedNodes.size());
            for (Node.NodeData nodeData : packet.chartedNodes) {
                buffer.writeBlockPos(nodeData.pos());
                buffer.writeFloat(nodeData.quality());
                buffer.writeFloat(nodeData.clearance());
            }
        }
    };

    public ChartedPathC2S(List<Node.NodeData> chartedNodes) {
        this.chartedNodes = chartedNodes != null ? List.copyOf(chartedNodes) : List.of();
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public List<Node.NodeData> getChartedNodes() {
        return this.chartedNodes;
    }
}

