/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.network;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.storage.LevelResource;
import net.rasanovum.viaromana.ViaRomana;
import net.rasanovum.viaromana.network.NetworkHandler;
import net.rasanovum.viaromana.path.Node;
import net.rasanovum.viaromana.util.PathSyncUtils;

public class ViaRomanaModVariables {
    public static List<Object> ValidTagList = new ArrayList<Object>();
    public static NetworkHandler networkHandler = null;
    private static final Map<UUID, PlayerVariables> playerVariables = new ConcurrentHashMap<UUID, PlayerVariables>();
    private static PlayerVariables clientPlayerVariables = new PlayerVariables();

    public static ListTag saveNodeDataList(List<Node.NodeData> nodeDataList) {
        ListTag listTag = new ListTag();
        for (Node.NodeData data : nodeDataList) {
            CompoundTag nodeCompound = new CompoundTag();
            nodeCompound.putLong("pos", data.pos().asLong());
            nodeCompound.putFloat("quality", data.quality());
            nodeCompound.putFloat("clearance", data.clearance());
            listTag.add((Object)nodeCompound);
        }
        return listTag;
    }

    public static List<Node.NodeData> loadNodeDataList(ListTag listTag) {
        ArrayList<Node.NodeData> loadedList = new ArrayList<Node.NodeData>();
        if (listTag.getElementType() != 10) {
            return loadedList;
        }
        for (Tag tag : listTag) {
            CompoundTag nodeCompound = (CompoundTag)tag;
            BlockPos pos = BlockPos.of((long)nodeCompound.getLong("pos"));
            float quality = nodeCompound.getFloat("quality");
            float clearance = nodeCompound.getFloat("clearance");
            loadedList.add(new Node.NodeData(pos, quality, clearance));
        }
        return loadedList;
    }

    public static PlayerVariables getPlayerVariables(Entity entity) {
        if (entity == null) {
            ViaRomana.LOGGER.warn("Attempted to get PlayerVariables for null entity.");
            return new PlayerVariables();
        }
        if (entity.level().isClientSide()) {
            return clientPlayerVariables;
        }
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            UUID playerId = player.getUUID();
            return playerVariables.computeIfAbsent(playerId, id -> {
                PlayerVariables vars = new PlayerVariables();
                CompoundTag playerData = ViaRomanaModVariables.loadNBTFromFile(player.getServer(), id.toString());
                if (playerData != null) {
                    vars.readNBT(playerData);
                    ViaRomana.LOGGER.debug("Loaded PlayerVariables from file for {}", (Object)player.getName().getString());
                } else {
                    ViaRomana.LOGGER.debug("No existing PlayerVariables file found for {}, creating new.", (Object)player.getName().getString());
                }
                return vars;
            });
        }
        ViaRomana.LOGGER.warn("Tried to get PlayerVariables for non-ServerPlayer entity: {}", (Object)entity.getType().getDescriptionId());
        return new PlayerVariables();
    }

    public static void playerLoggedOut(ServerPlayer player) {
        UUID playerId;
        PlayerVariables vars;
        if (player != null && (vars = playerVariables.get(playerId = player.getUUID())) != null) {
            ViaRomanaModVariables.savePlayerVariablesToFile(player.getServer(), playerId.toString(), vars);
            playerVariables.remove(playerId);
            ViaRomana.LOGGER.debug("Saved and unloaded PlayerVariables for {}", (Object)player.getName().getString());
        }
    }

    public static PlayerVariables playerLoggedIn(ServerPlayer player) {
        if (player == null) {
            return new PlayerVariables();
        }
        PlayerVariables vars = ViaRomanaModVariables.getPlayerVariables((Entity)player);
        vars.syncToClient(player);
        PathSyncUtils.syncPathGraphToPlayer(player);
        return vars;
    }

    public static void playerRespawned(ServerPlayer oldPlayer, ServerPlayer newPlayer, boolean keepAllPlayerData) {
        if (oldPlayer == null || newPlayer == null) {
            return;
        }
        PlayerVariables oldVars = playerVariables.get(oldPlayer.getUUID());
        PlayerVariables newVars = ViaRomanaModVariables.getPlayerVariables((Entity)newPlayer);
        if (oldVars != null) {
            if (keepAllPlayerData) {
                newVars.readNBT(oldVars.writeNBT());
                ViaRomana.LOGGER.debug("Copied all PlayerVariables on respawn for {}", (Object)newPlayer.getName().getString());
            } else {
                ViaRomana.LOGGER.debug("Did not copy PlayerVariables on respawn (keepAllPlayerData=false) for {}", (Object)newPlayer.getName().getString());
            }
            newVars.syncToClient(newPlayer);
        } else {
            ViaRomana.LOGGER.warn("Could not find old PlayerVariables for {} during respawn.", (Object)oldPlayer.getName().getString());
            newVars.syncToClient(newPlayer);
        }
    }

    public static void savePlayerVariablesToFile(MinecraftServer server, String playerUUID, PlayerVariables data) {
        if (server == null || data == null) {
            return;
        }
        ViaRomanaModVariables.saveNBTToFile(server, playerUUID, data.writeNBT());
    }

    public static void loadPlayerVariablesFromFile(ServerPlayer player) {
        if (player != null && player.getServer() != null) {
            UUID playerId = player.getUUID();
            CompoundTag playerData = ViaRomanaModVariables.loadNBTFromFile(player.getServer(), playerId.toString());
            if (playerData != null) {
                PlayerVariables playerVar = playerVariables.computeIfAbsent(playerId, id -> new PlayerVariables());
                playerVar.readNBT(playerData);
                ViaRomana.LOGGER.debug("Force-loaded PlayerVariables from file for {}", (Object)player.getName().getString());
                playerVar.syncToClient(player);
            }
        }
    }

    private static File getPlayerDataDirectory(MinecraftServer server) {
        return new File(server.getWorldPath(LevelResource.PLAYER_DATA_DIR).toFile(), "via_romana");
    }

    private static void saveNBTToFile(MinecraftServer server, String fileName, CompoundTag nbt) {
        if (server == null) {
            return;
        }
        try {
            File dataDir = ViaRomanaModVariables.getPlayerDataDirectory(server);
            if (!dataDir.exists()) {
                if (!dataDir.mkdirs()) {
                    ViaRomana.LOGGER.error("Could not create player data directory: {}", (Object)dataDir.getAbsolutePath());
                    return;
                }
                ViaRomana.LOGGER.debug("Created player data directory: {}", (Object)dataDir.getAbsolutePath());
            }
            File file = new File(dataDir, fileName + ".dat");
            File backupFile = new File(dataDir, fileName + ".dat_old");
            if (file.exists()) {
                if (backupFile.exists()) {
                    backupFile.delete();
                }
                file.renameTo(backupFile);
            }
            NbtIo.writeCompressed((CompoundTag)nbt, (Path)file.toPath());
        }
        catch (IOException e) {
            ViaRomana.LOGGER.error("Failed to save player variables NBT for " + fileName, (Throwable)e);
        }
    }

    private static CompoundTag loadNBTFromFile(MinecraftServer server, String fileName) {
        if (server == null) {
            return null;
        }
        File dataDir = ViaRomanaModVariables.getPlayerDataDirectory(server);
        File file = new File(dataDir, fileName + ".dat");
        File backupFile = new File(dataDir, fileName + ".dat_old");
        if (file.exists()) {
            try {
                return NbtIo.readCompressed((Path)file.toPath(), (NbtAccounter)NbtAccounter.unlimitedHeap());
            }
            catch (IOException e) {
                ViaRomana.LOGGER.error("Failed to load player variables NBT from " + file.getName() + ", trying backup.", (Throwable)e);
                if (backupFile.exists()) {
                    try {
                        ViaRomana.LOGGER.warn("Attempting to load from backup file: {}", (Object)backupFile.getName());
                        return NbtIo.readCompressed((Path)backupFile.toPath(), (NbtAccounter)NbtAccounter.unlimitedHeap());
                    }
                    catch (IOException e2) {
                        ViaRomana.LOGGER.error("Failed to load player variables NBT from backup " + backupFile.getName() + " as well.", (Throwable)e2);
                    }
                }
            }
        } else if (backupFile.exists()) {
            try {
                ViaRomana.LOGGER.warn("Main file {} missing, attempting to load from backup file: {}", (Object)file.getName(), (Object)backupFile.getName());
                return NbtIo.readCompressed((Path)backupFile.toPath(), (NbtAccounter)NbtAccounter.unlimitedHeap());
            }
            catch (IOException e) {
                ViaRomana.LOGGER.error("Failed to load player variables NBT from backup " + backupFile.getName(), (Throwable)e);
            }
        }
        return null;
    }

    public static class PlayerVariables {
        public boolean ChartingPath = false;
        public double FadeAmount = 0.0;
        public boolean FadeIncrease = false;
        public BlockPos lastNodePos = BlockPos.ZERO;
        public boolean ReceivedTutorial = false;

        public CompoundTag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.putBoolean("ChartingPath", this.ChartingPath);
            nbt.putDouble("FadeAmount", this.FadeAmount);
            nbt.putBoolean("FadeIncrease", this.FadeIncrease);
            nbt.putLong("lastNodePos", this.lastNodePos != null ? this.lastNodePos.asLong() : BlockPos.ZERO.asLong());
            nbt.putBoolean("ReceivedTutorial", this.ReceivedTutorial);
            return nbt;
        }

        public void readNBT(CompoundTag nbt) {
            this.ChartingPath = nbt.getBoolean("ChartingPath");
            this.FadeAmount = nbt.getDouble("FadeAmount");
            this.FadeIncrease = nbt.getBoolean("FadeIncrease");
            long nodePos = nbt.getLong("lastNodePos");
            this.lastNodePos = nodePos != BlockPos.ZERO.asLong() ? BlockPos.of((long)nodePos) : BlockPos.ZERO;
            this.ReceivedTutorial = nbt.getBoolean("ReceivedTutorial");
        }

        public void syncToClient(ServerPlayer player) {
            if (player == null) {
                return;
            }
            if (networkHandler != null) {
                networkHandler.sendToPlayer(player, new PlayerVariablesSyncMessage(this));
            } else {
                ViaRomana.LOGGER.warn("Network handler not initialized, cannot sync PlayerVariables for {}.", (Object)player.getName().getString());
            }
        }
    }

    public record PlayerVariablesSyncMessage(CompoundTag dataTag) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<PlayerVariablesSyncMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.parse((String)"via_romana:player_variables_sync"));
        public static final StreamCodec<FriendlyByteBuf, PlayerVariablesSyncMessage> STREAM_CODEC = new StreamCodec<FriendlyByteBuf, PlayerVariablesSyncMessage>(){

            public PlayerVariablesSyncMessage decode(FriendlyByteBuf buffer) {
                return new PlayerVariablesSyncMessage(buffer.readNbt());
            }

            public void encode(FriendlyByteBuf buffer, PlayerVariablesSyncMessage packet) {
                buffer.writeNbt((Tag)packet.dataTag);
            }
        };

        public PlayerVariablesSyncMessage(PlayerVariables data) {
            this(data.writeNBT());
        }

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }

        public static void handleClient(PlayerVariablesSyncMessage message) {
            clientPlayerVariables.readNBT(message.dataTag);
            ViaRomana.LOGGER.debug("Client received and processed PlayerVariables sync.");
        }

        public static void handleServer(PlayerVariablesSyncMessage message, ServerPlayer player) {
            if (player != null) {
                PlayerVariables variables = ViaRomanaModVariables.getPlayerVariables((Entity)player);
                variables.readNBT(message.dataTag);
                ViaRomana.LOGGER.debug("Server received and processed PlayerVariables sync from {}", (Object)player.getName().getString());
            }
        }
    }
}

