/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.network;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.rasanovum.viaromana.client.MapClient;
import net.rasanovum.viaromana.client.gui.ChartingScreen;
import net.rasanovum.viaromana.client.gui.TeleportMapScreen;
import net.rasanovum.viaromana.client.gui.WarpBlockScreen;
import net.rasanovum.viaromana.network.ViaRomanaModVariables;
import net.rasanovum.viaromana.network.packets.DestinationResponseS2C;
import net.rasanovum.viaromana.network.packets.MapResponseS2C;
import net.rasanovum.viaromana.network.packets.OpenChartingScreenS2C;
import net.rasanovum.viaromana.network.packets.OpenWarpBlockScreenS2C;
import net.rasanovum.viaromana.network.packets.PathGraphSyncPacket;
import net.rasanovum.viaromana.network.packets.SignValidationResponseS2C;

@Environment(value=EnvType.CLIENT)
public class ViaRomanaModClientPacketHandler {
    public static void registerS2CPackets() {
        ClientPlayNetworking.registerGlobalReceiver(ViaRomanaModVariables.PlayerVariablesSyncMessage.TYPE, ViaRomanaModClientPacketHandler::handlePlayerVariablesS2C);
        ClientPlayNetworking.registerGlobalReceiver(DestinationResponseS2C.TYPE, ViaRomanaModClientPacketHandler::handleDestinationResponseS2C);
        ClientPlayNetworking.registerGlobalReceiver(MapResponseS2C.TYPE, ViaRomanaModClientPacketHandler::handleMapResponseS2C);
        ClientPlayNetworking.registerGlobalReceiver(SignValidationResponseS2C.TYPE, ViaRomanaModClientPacketHandler::handleSignValidationS2C);
        ClientPlayNetworking.registerGlobalReceiver(OpenChartingScreenS2C.TYPE, ViaRomanaModClientPacketHandler::handleOpenChartingScreenS2C);
        ClientPlayNetworking.registerGlobalReceiver(PathGraphSyncPacket.TYPE, ViaRomanaModClientPacketHandler::handlePathGraphSyncS2C);
        ClientPlayNetworking.registerGlobalReceiver(OpenWarpBlockScreenS2C.TYPE, ViaRomanaModClientPacketHandler::handleOpenWarpBlockScreenS2C);
    }

    private static void handlePlayerVariablesS2C(ViaRomanaModVariables.PlayerVariablesSyncMessage message, ClientPlayNetworking.Context context) {
        context.client().execute(() -> {
            ViaRomanaModVariables.PlayerVariablesSyncMessage.handleClient(message);
            if (context.client().screen instanceof ChartingScreen) {
                boolean isCharting = ViaRomanaModVariables.getPlayerVariables((Entity)context.client().player).ChartingPath;
                if (!isCharting) {
                    context.client().setScreen(null);
                } else {
                    context.client().setScreen((Screen)new ChartingScreen((Component)Component.translatable((String)"gui.viaromana.charting_screen.title")));
                }
            }
        });
    }

    private static void handlePathGraphSyncS2C(PathGraphSyncPacket message, ClientPlayNetworking.Context context) {
        context.client().execute(() -> PathGraphSyncPacket.handleClient(message));
    }

    private static void handleMapResponseS2C(MapResponseS2C message, ClientPlayNetworking.Context context) {
        context.client().execute(() -> MapClient.handleMapResponse(message));
    }

    private static void handleDestinationResponseS2C(DestinationResponseS2C message, ClientPlayNetworking.Context context) {
        context.client().execute(() -> {
            TeleportMapScreen screen = new TeleportMapScreen(message);
            Minecraft.getInstance().setScreen((Screen)screen);
        });
    }

    private static void handleOpenChartingScreenS2C(OpenChartingScreenS2C message, ClientPlayNetworking.Context context) {
        context.client().execute(() -> {
            MutableComponent title = Component.translatable((String)"gui.viaromana.charting_screen.title");
            ChartingScreen screen = new ChartingScreen((Component)title);
            context.client().setScreen((Screen)screen);
        });
    }

    private static void handleSignValidationS2C(SignValidationResponseS2C message, ClientPlayNetworking.Context context) {
        context.client().execute(() -> {
            Screen patt0$temp = context.client().screen;
            if (patt0$temp instanceof TeleportMapScreen) {
                TeleportMapScreen teleportScreen = (TeleportMapScreen)patt0$temp;
                teleportScreen.handleSignValidation(message.nodePos(), message.isValid());
            }
        });
    }

    public static void sendPlayerVariablesToServer(ViaRomanaModVariables.PlayerVariables data) {
        ViaRomanaModVariables.PlayerVariablesSyncMessage message = new ViaRomanaModVariables.PlayerVariablesSyncMessage(data);
        ClientPlayNetworking.send((CustomPacketPayload)message);
    }

    private static void handleOpenWarpBlockScreenS2C(OpenWarpBlockScreenS2C message, ClientPlayNetworking.Context context) {
        context.client().execute(() -> {
            WarpBlockScreen screen = new WarpBlockScreen(message.blockPos());
            context.client().setScreen((Screen)screen);
        });
    }
}

