/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.mixins;

import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.rasanovum.viaromana.storage.ICustomDataHolder;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BlockEntity.class})
public class BlockEntityMixin
implements ICustomDataHolder {
    @Unique
    private CompoundTag fabricData = new CompoundTag();

    @Inject(method={"saveAdditional"}, at={@At(value="RETURN")})
    private void onSaveAdditional(CompoundTag nbt, HolderLookup.Provider registries, CallbackInfo ci) {
        if (!this.fabricData.isEmpty()) {
            nbt.put("FabricData", (Tag)this.fabricData);
        }
    }

    @Inject(method={"loadAdditional"}, at={@At(value="RETURN")})
    private void onLoad(CompoundTag nbt, HolderLookup.Provider registries, CallbackInfo ci) {
        if (nbt.contains("FabricData")) {
            this.fabricData = nbt.getCompound("FabricData");
        }
    }

    @Inject(method={"saveWithoutMetadata"}, at={@At(value="RETURN")}, cancellable=true)
    private void onSaveWithoutMetadata(HolderLookup.Provider registries, CallbackInfoReturnable<CompoundTag> cir) {
        CompoundTag nbt = (CompoundTag)cir.getReturnValue();
        if (!this.fabricData.isEmpty()) {
            nbt.put("FabricData", (Tag)this.fabricData);
        }
        cir.setReturnValue((Object)nbt);
    }

    @Override
    public CompoundTag getCustomData() {
        return this.fabricData;
    }

    @Override
    public void setCustomData(CompoundTag data) {
        this.fabricData = data;
    }
}

