/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.map;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.ChunkPos;
import net.rasanovum.viaromana.network.packets.DestinationResponseS2C;

public record MapInfo(UUID networkId, BlockPos minBounds, BlockPos maxBounds, List<DestinationResponseS2C.NodeNetworkInfo> networkNodes, byte[] pngData, int bakeScaleFactor, Long createdAtMs, List<ChunkPos> allowedChunks) {
    public MapInfo {
        networkNodes = networkNodes != null ? new ArrayList<DestinationResponseS2C.NodeNetworkInfo>(networkNodes) : new ArrayList();
        pngData = pngData != null ? (byte[])pngData.clone() : null;
        allowedChunks = allowedChunks != null ? new ArrayList<ChunkPos>(allowedChunks) : null;
    }

    public static MapInfo request(UUID networkId, BlockPos minBounds, BlockPos maxBounds, List<DestinationResponseS2C.NodeNetworkInfo> networkNodes) {
        return new MapInfo(networkId, minBounds, maxBounds, networkNodes != null ? new ArrayList<DestinationResponseS2C.NodeNetworkInfo>(networkNodes) : new ArrayList(), null, 1, null, null);
    }

    public static MapInfo response(UUID networkId, BlockPos minBounds, BlockPos maxBounds, List<DestinationResponseS2C.NodeNetworkInfo> networkNodes, byte[] pngData, int bakeScaleFactor) {
        return new MapInfo(networkId, minBounds, maxBounds, networkNodes != null ? new ArrayList<DestinationResponseS2C.NodeNetworkInfo>(networkNodes) : new ArrayList(), pngData != null ? (byte[])pngData.clone() : null, bakeScaleFactor, System.currentTimeMillis(), null);
    }

    public static MapInfo fromServerCache(UUID networkId, BlockPos minBounds, BlockPos maxBounds, List<DestinationResponseS2C.NodeNetworkInfo> networkNodes, byte[] pngData, int bakeScaleFactor, List<ChunkPos> allowedChunks) {
        return new MapInfo(networkId, minBounds, maxBounds, networkNodes != null ? new ArrayList<DestinationResponseS2C.NodeNetworkInfo>(networkNodes) : new ArrayList(), pngData != null ? (byte[])pngData.clone() : null, bakeScaleFactor, System.currentTimeMillis(), (List<ChunkPos>)(allowedChunks != null ? new ArrayList<ChunkPos>(allowedChunks) : null));
    }

    public boolean hasImageData() {
        return this.pngData != null;
    }

    public boolean isRequest() {
        return this.pngData == null;
    }

    public boolean isResponse() {
        return this.pngData != null;
    }

    public int getWorldWidth() {
        return this.maxBounds.getX() - this.minBounds.getX() + 1;
    }

    public int getWorldHeight() {
        return this.maxBounds.getZ() - this.minBounds.getZ() + 1;
    }

    public boolean hasTimestamp() {
        return this.createdAtMs != null;
    }

    public long getAgeMs() {
        return this.createdAtMs != null ? System.currentTimeMillis() - this.createdAtMs : 0L;
    }

    public String getFormattedAge() {
        if (this.createdAtMs == null) {
            return "no timestamp";
        }
        long ageMs = this.getAgeMs();
        if (ageMs < 1000L) {
            return ageMs + "ms ago";
        }
        if (ageMs < 60000L) {
            return ageMs / 1000L + "s ago";
        }
        return ageMs / 60000L + "m ago";
    }

    public void writeToBuffer(FriendlyByteBuf buffer) {
        buffer.writeUUID(this.networkId);
        buffer.writeBlockPos(this.minBounds);
        buffer.writeBlockPos(this.maxBounds);
        buffer.writeInt(this.networkNodes.size());
        for (DestinationResponseS2C.NodeNetworkInfo node : this.networkNodes) {
            buffer.writeBlockPos(node.position);
            buffer.writeFloat(node.clearance);
            buffer.writeInt(node.connections.size());
            for (BlockPos connection : node.connections) {
                buffer.writeBlockPos(connection);
            }
        }
        if (this.pngData != null) {
            buffer.writeBoolean(true);
            buffer.writeInt(this.pngData.length);
            buffer.writeBytes(this.pngData);
            buffer.writeInt(this.bakeScaleFactor);
            buffer.writeLong(this.createdAtMs != null ? this.createdAtMs : 0L);
        } else {
            buffer.writeBoolean(false);
        }
        if (this.allowedChunks != null) {
            buffer.writeBoolean(true);
            buffer.writeInt(this.allowedChunks.size());
            for (ChunkPos cp : this.allowedChunks) {
                buffer.writeInt(cp.x);
                buffer.writeInt(cp.z);
            }
        } else {
            buffer.writeBoolean(false);
        }
    }

    public static MapInfo readFromBuffer(FriendlyByteBuf buffer) {
        UUID networkId = buffer.readUUID();
        BlockPos minBounds = buffer.readBlockPos();
        BlockPos maxBounds = buffer.readBlockPos();
        int nodeCount = buffer.readInt();
        ArrayList<DestinationResponseS2C.NodeNetworkInfo> networkNodes = new ArrayList<DestinationResponseS2C.NodeNetworkInfo>(nodeCount);
        for (int i = 0; i < nodeCount; ++i) {
            BlockPos nodePos = buffer.readBlockPos();
            float clearance = buffer.readFloat();
            int connectionCount = buffer.readInt();
            ArrayList<BlockPos> connections = new ArrayList<BlockPos>(connectionCount);
            for (int j = 0; j < connectionCount; ++j) {
                connections.add(buffer.readBlockPos());
            }
            networkNodes.add(new DestinationResponseS2C.NodeNetworkInfo(nodePos, clearance, connections));
        }
        boolean hasImageData = buffer.readBoolean();
        byte[] pngData = null;
        int bakeScaleFactor = 1;
        Long createdAtMs = null;
        if (hasImageData) {
            int length = buffer.readInt();
            pngData = new byte[length];
            buffer.readBytes(pngData);
            bakeScaleFactor = buffer.readInt();
            long ts = buffer.readLong();
            createdAtMs = ts == 0L ? null : Long.valueOf(ts);
        }
        ArrayList<ChunkPos> allowed = null;
        boolean hasChunks = buffer.readBoolean();
        if (hasChunks) {
            int size = buffer.readInt();
            allowed = new ArrayList<ChunkPos>(size);
            for (int i = 0; i < size; ++i) {
                int x = buffer.readInt();
                int z = buffer.readInt();
                allowed.add(new ChunkPos(x, z));
            }
        }
        return new MapInfo(networkId, minBounds, maxBounds, networkNodes, pngData, bakeScaleFactor, createdAtMs, allowed);
    }
}

