/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.map;

import folk.sisby.surveyor.terrain.ChunkSummary;
import folk.sisby.surveyor.terrain.LayerSummary;
import folk.sisby.surveyor.terrain.WorldTerrainSummary;
import folk.sisby.surveyor.util.RegistryPalette;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.imageio.ImageIO;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.MapColor;
import net.rasanovum.viaromana.CommonConfig;
import net.rasanovum.viaromana.ViaRomana;
import net.rasanovum.viaromana.map.MapInfo;
import net.rasanovum.viaromana.map.ServerMapUtils;
import net.rasanovum.viaromana.network.packets.DestinationResponseS2C;
import net.rasanovum.viaromana.path.PathGraph;
import net.rasanovum.viaromana.surveyor.SurveyorUtil;

public class MapBakeWorker {
    public MapInfo bake(UUID networkId, ServerLevel level, BlockPos minBounds, BlockPos maxBounds, List<DestinationResponseS2C.NodeNetworkInfo> networkNodes) {
        int widthW = maxBounds.getX() - minBounds.getX();
        int heightW = maxBounds.getZ() - minBounds.getZ();
        int padX = Math.max(16, (int)((float)widthW * 0.1f));
        int padZ = Math.max(16, (int)((float)heightW * 0.1f));
        BlockPos paddedMin = minBounds.offset(-padX, 0, -padZ);
        BlockPos paddedMax = maxBounds.offset(padX, 0, padZ);
        int exactWidth = paddedMax.getX() - paddedMin.getX() + 1;
        int exactHeight = paddedMax.getZ() - paddedMin.getZ() + 1;
        int scaleFactor = this.calculateScaleFactor(exactWidth, exactHeight);
        int finalImgW = exactWidth / scaleFactor;
        int finalImgH = exactHeight / scaleFactor;
        WorldTerrainSummary terrain = SurveyorUtil.getTerrain(level);
        if (terrain == null) {
            throw new IllegalStateException("Surveyor terrain data is null");
        }
        PathGraph graph = PathGraph.getInstance(level);
        if (graph == null) {
            throw new IllegalStateException("PathGraph is null");
        }
        PathGraph.NetworkCache network = graph.getNetworkCache(networkId);
        PathGraph.FoWCache fowCache = graph.getOrComputeFoWCache(network);
        if (fowCache == null) {
            throw new IllegalStateException("Surveyor terrain data is null");
        }
        ChunkPos minChunk = fowCache.minChunk();
        ChunkPos maxChunk = fowCache.maxChunk();
        int chunkAreaWidth = (maxChunk.x - minChunk.x + 1) * 16;
        int chunkAreaHeight = (maxChunk.z - minChunk.z + 1) * 16;
        Set<ChunkPos> allowedChunks = fowCache != null ? fowCache.allowedChunks() : ServerMapUtils.calculateFogOfWarChunks(networkNodes, minChunk, maxChunk);
        BufferedImage chunkAreaImg = new BufferedImage(chunkAreaWidth / scaleFactor, chunkAreaHeight / scaleFactor, 2);
        this.processSurveyorChunks(chunkAreaImg, level, terrain, minChunk, maxChunk, allowedChunks, scaleFactor);
        int cropOffsetX = paddedMin.getX() - minChunk.x * 16;
        int cropOffsetZ = paddedMin.getZ() - minChunk.z * 16;
        BufferedImage finalImg = chunkAreaImg;
        if (cropOffsetX != 0 || cropOffsetZ != 0 || exactWidth != chunkAreaWidth || exactHeight != chunkAreaHeight) {
            int scaledCropX = cropOffsetX / scaleFactor;
            int scaledCropZ = cropOffsetZ / scaleFactor;
            if (scaledCropX + finalImgW > chunkAreaImg.getWidth() || scaledCropZ + finalImgH > chunkAreaImg.getHeight()) {
                throw new IllegalStateException("Crop bounds exceed chunk area image dimensions");
            }
            finalImg = chunkAreaImg.getSubimage(scaledCropX, scaledCropZ, finalImgW, finalImgH);
        }
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)finalImg, "PNG", outputStream);
            return MapInfo.fromServerCache(networkId, paddedMin, paddedMax, networkNodes, outputStream.toByteArray(), scaleFactor, new ArrayList<ChunkPos>(allowedChunks));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to convert map to PNG", e);
        }
    }

    public MapInfo updateMap(MapInfo previousResult, Set<ChunkPos> dirtyChunks, ServerLevel level, PathGraph.NetworkCache network) {
        ViaRomana.LOGGER.debug("MapBakeWorker.updateMap() called with {} dirty chunks for network {}", (Object)dirtyChunks.size(), (Object)previousResult.networkId());
        StringBuilder dirtyChunksList = new StringBuilder();
        for (ChunkPos pos : dirtyChunks) {
            dirtyChunksList.append(pos.toString()).append(" ");
        }
        ViaRomana.LOGGER.debug("Dirty chunks to update: {}", (Object)dirtyChunksList.toString().trim());
        try {
            BufferedImage mapImage = ImageIO.read(new ByteArrayInputStream(previousResult.pngData()));
            Graphics2D graphics = mapImage.createGraphics();
            WorldTerrainSummary terrain = SurveyorUtil.getTerrain(level);
            if (terrain == null) {
                ViaRomana.LOGGER.error("Cannot update map: Surveyor terrain is null.");
                return previousResult;
            }
            BlockPos paddedMin = previousResult.minBounds();
            int scaleFactor = previousResult.bakeScaleFactor();
            ChunkPos minChunk = new ChunkPos(paddedMin);
            ViaRomana.LOGGER.debug("Map update: minBounds(padded)={}, scaleFactor={}, minChunk={}", (Object)paddedMin, (Object)scaleFactor, (Object)minChunk);
            int chunksUpdated = 0;
            int chunksSkippedNoData = 0;
            for (ChunkPos dirtyPos : dirtyChunks) {
                ChunkSummary summary = terrain.get(dirtyPos);
                if (summary == null) {
                    ++chunksSkippedNoData;
                    ViaRomana.LOGGER.warn("No Surveyor data for dirty chunk {}", (Object)dirtyPos);
                    continue;
                }
                int relBlockX = dirtyPos.x * 16 - paddedMin.getX();
                int relBlockZ = dirtyPos.z * 16 - paddedMin.getZ();
                int chunkImgX = relBlockX / scaleFactor;
                int chunkImgZ = relBlockZ / scaleFactor;
                ViaRomana.LOGGER.debug("Updating chunk {} at image position ({}, {})", (Object)dirtyPos, (Object)chunkImgX, (Object)chunkImgZ);
                int scaledChunkSize = 16 / scaleFactor;
                if (scaledChunkSize <= 0) {
                    scaledChunkSize = 1;
                }
                BufferedImage chunkImage = new BufferedImage(scaledChunkSize, scaledChunkSize, 2);
                this.renderSurveyorChunk(chunkImage, level, terrain, summary, dirtyPos, dirtyPos.x, dirtyPos.z, scaleFactor);
                graphics.drawImage((Image)chunkImage, chunkImgX, chunkImgZ, null);
                ++chunksUpdated;
            }
            graphics.dispose();
            ViaRomana.LOGGER.debug("Map incremental update completed: {} chunks updated, {} chunks skipped (no data)", (Object)chunksUpdated, (Object)chunksSkippedNoData);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)mapImage, "PNG", outputStream);
            return MapInfo.fromServerCache(previousResult.networkId(), previousResult.minBounds(), previousResult.maxBounds(), previousResult.networkNodes(), outputStream.toByteArray(), scaleFactor, previousResult.allowedChunks());
        }
        catch (IOException e) {
            ViaRomana.LOGGER.error("Failed to update map incrementally, performing a full re-bake.", (Throwable)e);
            return this.bake(previousResult.networkId(), level, network.getMin(), network.getMax(), network.getNodesAsInfo());
        }
    }

    private int calculateScaleFactor(int width, int height) {
        int MAX_DIM;
        int maxDim = Math.max(width, height);
        if (maxDim <= (MAX_DIM = CommonConfig.maximum_map_dimension)) {
            return 1;
        }
        int requiredScale = (int)Math.ceil((double)maxDim / (double)MAX_DIM);
        return Integer.highestOneBit(requiredScale - 1) << 1;
    }

    private void processSurveyorChunks(BufferedImage img, ServerLevel level, WorldTerrainSummary terrain, ChunkPos min, ChunkPos max, Set<ChunkPos> allowedChunks, int scaleFactor) {
        ViaRomana.LOGGER.debug("Processing Surveyor chunks: area from {} to {}, {} allowed chunks, scale factor {}", (Object)min, (Object)max, (Object)allowedChunks.size(), (Object)scaleFactor);
        int chunksWithData = this.attemptRender(img, level, terrain, min, max, allowedChunks, scaleFactor);
        ViaRomana.LOGGER.debug("Surveyor chunk processing complete: {} chunks had data out of {} allowed chunks", (Object)chunksWithData, (Object)allowedChunks.size());
        if (chunksWithData == 0 && !allowedChunks.isEmpty()) {
            ViaRomana.LOGGER.warn("Map Bake: No Surveyor chunk data was available for the requested map area. The map may appear blank.");
        }
    }

    private int attemptRender(BufferedImage img, ServerLevel level, WorldTerrainSummary terrain, ChunkPos min, ChunkPos max, Set<ChunkPos> allowedChunks, int scaleFactor) {
        int surveyorDataChunks = 0;
        int totalChecked = 0;
        for (int cx = min.x; cx <= max.x; ++cx) {
            for (int cz = min.z; cz <= max.z; ++cz) {
                ChunkPos chunkPos = new ChunkPos(cx, cz);
                if (!allowedChunks.contains(chunkPos)) continue;
                ++totalChecked;
                ChunkSummary chunkSummary = terrain.get(chunkPos);
                if (chunkSummary != null) {
                    ++surveyorDataChunks;
                    ViaRomana.LOGGER.debug("Rendering chunk {} with Surveyor data", (Object)chunkPos);
                    this.renderSurveyorChunk(img, level, terrain, chunkSummary, min, cx, cz, scaleFactor);
                    continue;
                }
                ViaRomana.LOGGER.debug("No Surveyor data for chunk {}", (Object)chunkPos);
            }
        }
        ViaRomana.LOGGER.debug("Render attempt complete: {}/{} chunks had Surveyor data", (Object)surveyorDataChunks, (Object)totalChecked);
        return surveyorDataChunks;
    }

    private void renderSurveyorChunk(BufferedImage img, ServerLevel level, WorldTerrainSummary terrain, ChunkSummary summary, ChunkPos minPos, int cx, int cz, int scaleFactor) {
        LayerSummary.Raw layer = summary.toSingleLayer(null, null, level.getMaxBuildHeight());
        if (layer == null) {
            return;
        }
        RegistryPalette.ValueView blockPalette = terrain.getBlockPalette(new ChunkPos(cx, cz));
        int worldTop = level.getMaxBuildHeight();
        int[] heights = new int[256];
        for (int i = 0; i < 256; ++i) {
            heights[i] = layer.exists().get(i) ? worldTop - layer.depths()[i] : Integer.MIN_VALUE;
        }
        int baseX = (cx - minPos.x) * 16;
        int baseZ = (cz - minPos.z) * 16;
        for (int lx = 0; lx < 16; lx += scaleFactor) {
            for (int lz = 0; lz < 16; lz += scaleFactor) {
                int color;
                int px = (baseX + lx) / scaleFactor;
                int pz = (baseZ + lz) / scaleFactor;
                if (px >= img.getWidth() || pz >= img.getHeight() || (color = this.getPixelColor(lx * 16 + lz, heights, layer.blocks(), layer.waterDepths(), layer.exists(), blockPalette)) == -1) continue;
                img.setRGB(px, pz, color | 0xFF000000);
            }
        }
    }

    private int getPixelColor(int idx, int[] heights, int[] blocks, int[] waterDepths, BitSet exists, RegistryPalette.ValueView blockPalette) {
        MapColor.Brightness brightness;
        MapColor mapColor;
        boolean hasWater;
        boolean bl = hasWater = waterDepths != null && waterDepths[idx] > 0;
        if (!exists.get(idx) && !hasWater) {
            return -1;
        }
        if (hasWater) {
            mapColor = MapColor.WATER;
            brightness = this.calculateWaterBrightness(idx, waterDepths[idx]);
        } else {
            Block block = (Block)blockPalette.byId(blocks[idx]);
            if (block == null || block == Blocks.AIR) {
                return -1;
            }
            mapColor = block.defaultMapColor();
            brightness = this.calculateTerrainBrightness(heights, idx);
        }
        int mcColor = mapColor.calculateRGBColor(brightness);
        return (mcColor & 0xFF) << 16 | mcColor & 0xFF00 | mcColor >> 16 & 0xFF;
    }

    private MapColor.Brightness calculateWaterBrightness(int idx, int waterDepth) {
        double shade = Math.min((double)waterDepth / 8.0, 1.0) + (double)((idx >> 4) + (idx & 0xF) & 1) * 0.15;
        return shade < 0.3 ? MapColor.Brightness.HIGH : (shade > 0.7 ? MapColor.Brightness.LOW : MapColor.Brightness.NORMAL);
    }

    private MapColor.Brightness calculateTerrainBrightness(int[] heights, int idx) {
        int lz;
        int currentHeight = heights[idx];
        int lx = idx >> 4;
        int westHeight = lx > 0 ? heights[idx - 16] : currentHeight;
        double shade = (double)(currentHeight - westHeight) * 4.0 / 2.0 + ((double)((lz = idx & 0xF) + lx & 1) - 0.5) * 0.4;
        if (shade > 0.6) {
            return MapColor.Brightness.HIGH;
        }
        if (shade < -0.6) {
            return MapColor.Brightness.LOW;
        }
        return MapColor.Brightness.NORMAL;
    }
}

