/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.core;

import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.rasanovum.viaromana.ViaRomana;
import net.rasanovum.viaromana.client.data.ClientPathData;
import net.rasanovum.viaromana.path.Node;
import net.rasanovum.viaromana.path.PathGraph;
import net.rasanovum.viaromana.storage.IPathStorage;
import net.rasanovum.viaromana.surveyor.ViaRomanaLandmarkManager;
import net.rasanovum.viaromana.util.PathSyncUtils;

public class LinkHandler {
    public static boolean isSignBlock(LevelAccessor world, BlockPos blockPos) {
        BlockState targetBlock = world.getBlockState(blockPos);
        return targetBlock.is(TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.parse((String)"via_romana:warp_block")));
    }

    private static PathGraph getPathGraph(LevelAccessor level) {
        if (level instanceof Level) {
            Level levelInstance = (Level)level;
            if (levelInstance.isClientSide()) {
                ClientPathData clientData = ClientPathData.getInstance();
                return clientData.hasValidData() ? clientData.getGraph() : null;
            }
            if (levelInstance instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)levelInstance;
                IPathStorage storage = IPathStorage.get((Level)serverLevel);
                return storage != null ? storage.graph() : null;
            }
        }
        return null;
    }

    public static boolean linkSignToNode(ServerLevel level, LinkData linkData) {
        if (!level.hasChunkAt(linkData.signPos())) {
            level.getChunk(linkData.signPos());
        }
        if (!LinkHandler.isSignBlock((LevelAccessor)level, linkData.signPos())) {
            ViaRomana.LOGGER.warn("linkSignToNode: Sign block entity not found at {} or chunk not loaded.", (Object)linkData.signPos());
            return false;
        }
        IPathStorage storage = IPathStorage.get((Level)level);
        Optional<Node> nodeOpt = storage.graph().getNodeAt(linkData.nodePos());
        if (nodeOpt.isEmpty()) {
            ViaRomana.LOGGER.warn("linkSignToNode: Node not found at {}", (Object)linkData.nodePos());
            return false;
        }
        Node node = nodeOpt.get();
        storage.graph().linkSignToNode(linkData.nodePos(), linkData.signPos(), linkData.linkType(), linkData.owner());
        node.setDestinationName(linkData.destinationName());
        node.setDestinationIcon(linkData.icon());
        storage.setDirty();
        PathSyncUtils.syncPathGraphToAllPlayers(level);
        ViaRomanaLandmarkManager.addDestinationLandmark((Level)level, node);
        return true;
    }

    public static boolean unlinkSignFromNode(ServerLevel level, BlockPos signPos) {
        if (!LinkHandler.isSignBlock((LevelAccessor)level, signPos)) {
            return false;
        }
        IPathStorage storage = IPathStorage.get((Level)level);
        Optional<Node> nodeOpt = storage.graph().getNodeBySignPos(signPos);
        if (nodeOpt.isPresent()) {
            Node node = nodeOpt.get();
            storage.graph().removeSignLink(signPos);
            storage.setDirty();
            PathSyncUtils.syncPathGraphToAllPlayers(level);
            ViaRomanaLandmarkManager.removeDestinationLandmark((Level)level, node);
            return true;
        }
        return false;
    }

    public static void handleSignDestruction(ServerLevel level, BlockPos signPos) {
        Node linkedNode;
        IPathStorage storage = IPathStorage.get((Level)level);
        Optional<Node> node = LinkHandler.getLinkedNode((LevelAccessor)level, signPos);
        if (node.isPresent() && (linkedNode = node.get()).getSignPos().isPresent() && linkedNode.getSignPos().get().longValue() == signPos.asLong()) {
            storage.graph().removeSignLink(signPos);
            storage.setDirty();
            PathSyncUtils.syncPathGraphToAllPlayers(level);
            ViaRomanaLandmarkManager.removeDestinationLandmark((Level)level, linkedNode);
        }
    }

    public static boolean isSignLinked(LevelAccessor world, BlockPos signPos) {
        return LinkHandler.getLinkedNode(world, signPos).isPresent();
    }

    public static Optional<Node> getLinkedNode(LevelAccessor level, BlockPos signPos) {
        if (!LinkHandler.isSignBlock(level, signPos)) {
            return Optional.empty();
        }
        ViaRomana.LOGGER.debug("getLinkedNode: Checking sign at {}", (Object)signPos);
        PathGraph graph = LinkHandler.getPathGraph(level);
        if (graph == null) {
            return Optional.empty();
        }
        return graph.getNodeBySignPos(signPos);
    }

    public static boolean hasAccess(Entity player, Node node) {
        UUID playerUuid = player.getUUID();
        if (node == null) {
            return false;
        }
        if (node.getPrivateOwner().isEmpty()) {
            return true;
        }
        return playerUuid.equals(node.getPrivateOwner().get());
    }

    public static Optional<LinkData> getLinkData(LevelAccessor level, BlockPos signPos) {
        Level levelInstance;
        Optional<Node> nodeOpt = LinkHandler.getLinkedNode(level, signPos);
        if (nodeOpt.isPresent()) {
            Node node = nodeOpt.get();
            return Optional.of(new LinkData(signPos, node.getBlockPos(), node.getLinkType(), node.getDestinationIcon().orElse(Node.Icon.SIGNPOST), node.getDestinationName().orElse("Travel Destination"), node.getPrivateOwner().orElse(null)));
        }
        if (level instanceof Level && (levelInstance = (Level)level).isClientSide()) {
            ClientPathData clientData = ClientPathData.getInstance();
            return clientData.getTemporarySignLink(signPos);
        }
        return Optional.empty();
    }

    public record LinkData(BlockPos signPos, BlockPos nodePos, Node.LinkType linkType, Node.Icon icon, String destinationName, UUID owner) {
    }
}

