/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.core;

import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.LevelAccessor;
import net.rasanovum.viaromana.CommonConfig;
import net.rasanovum.viaromana.client.HudMessageManager;
import net.rasanovum.viaromana.core.ResetVariables;
import net.rasanovum.viaromana.variables.VariableAccess;

public class DimensionHandler {
    public static void preventHopping(LevelAccessor world, Entity entity) {
        if (entity == null) {
            return;
        }
        if (VariableAccess.playerVariables.isChartingPath(entity)) {
            HudMessageManager.queueMessage("message.via_romana.cancel_path_dimension");
            ResetVariables.execute(world, entity);
        }
    }

    public static boolean isValid(LevelAccessor world, Entity entity) {
        if (entity == null) {
            return false;
        }
        List<String> invalidDimensions = CommonConfig.invalid_dimensions;
        for (String invalidDimension : invalidDimensions) {
            if (!entity.level().dimension().toString().contains(invalidDimension)) continue;
            HudMessageManager.queueMessage("message.via_romana.invalid_dimension");
            return false;
        }
        return true;
    }
}

