/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.rasanovum.viaromana.client.data.ClientPathData;
import net.rasanovum.viaromana.client.gui.MapRenderer;
import net.rasanovum.viaromana.map.ServerMapCache;
import net.rasanovum.viaromana.path.PathGraph;
import net.rasanovum.viaromana.storage.IPathStorage;
import net.rasanovum.viaromana.util.PathSyncUtils;
import net.rasanovum.viaromana.variables.VariableAccess;

public class ViaRomanaCommands {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"viaromana").requires(source -> source.hasPermission(2))).then(Commands.literal((String)"nodes").then(Commands.literal((String)"clear").executes(ViaRomanaCommands::clearAllNodes)))).then(Commands.literal((String)"cache").then(Commands.literal((String)"clear").executes(ViaRomanaCommands::clearCache)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"maps").then(Commands.literal((String)"clear").executes(ViaRomanaCommands::clearMaps))).then(Commands.literal((String)"regenerate").executes(ViaRomanaCommands::regenerateMaps))).then(Commands.literal((String)"save").executes(ViaRomanaCommands::saveMaps))));
    }

    private static int clearAllNodes(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        for (Player player : source.getLevel().players()) {
            VariableAccess.playerVariables.setChartingPath((Entity)player, false);
            VariableAccess.playerVariables.syncAndSave((Entity)player);
        }
        IPathStorage storage = IPathStorage.get((Level)source.getLevel());
        PathGraph graph = storage.graph();
        int nodeCount = graph.size();
        graph.removeAllNodes();
        ClientPathData.getInstance().clearData();
        PathSyncUtils.syncPathGraphToAllPlayers(source.getLevel());
        storage.setDirty();
        source.sendSuccess(() -> Component.literal((String)("Cleared " + nodeCount + " nodes")), true);
        return nodeCount;
    }

    private static int clearCache(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        if (source.getLevel().isClientSide()) {
            ClientPathData.getInstance().clearData();
            MapRenderer.clearCache();
        }
        PathSyncUtils.syncPathGraphToPlayer(source.getPlayerOrException());
        ServerMapCache.clear();
        source.sendSuccess(() -> Component.literal((String)"Cleared all Via Romana caches"), true);
        return 1;
    }

    private static int clearMaps(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerMapCache.clear();
        ServerMapCache.deleteAllMapsFromDisk();
        if (source.getLevel().isClientSide()) {
            MapRenderer.clearCache();
        }
        source.sendSuccess(() -> Component.literal((String)"Cleared Via Romana map cache"), true);
        return 1;
    }

    private static int regenerateMaps(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerMapCache.processAllDirtyNetworks();
        source.sendSuccess(() -> Component.literal((String)"Triggered regeneration for dirty Via Romana maps"), true);
        return 1;
    }

    private static int saveMaps(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerMapCache.saveAllToDisk(true);
        source.sendSuccess(() -> Component.literal((String)"Saved Via Romana maps to disk"), true);
        return 1;
    }
}

