/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.rasanovum.viaromana.ViaRomana;
import net.rasanovum.viaromana.client.render.NodeRenderer;

public class VignetteRenderer {
    private static final ResourceLocation VIGNETTE_TEXTURE = ResourceLocation.parse((String)"via_romana:textures/screens/overlay_vignette.png");

    public static void renderVignette(GuiGraphics guiGraphics) {
        try {
            float intensity = NodeRenderer.getCurrentVignetteIntensity();
            if (intensity > 0.0f) {
                VignetteRenderer.renderVignetteOverlay(guiGraphics, intensity);
            }
        }
        catch (Exception e) {
            ViaRomana.LOGGER.error("Error rendering vignette effect", (Throwable)e);
        }
    }

    private static void renderVignetteOverlay(GuiGraphics guiGraphics, float intensity) {
        Minecraft mc = Minecraft.getInstance();
        int screenWidth = mc.getWindow().getGuiScaledWidth();
        int screenHeight = mc.getWindow().getGuiScaledHeight();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)intensity);
        guiGraphics.blit(VIGNETTE_TEXTURE, 0, 0, 0.0f, 0.0f, screenWidth, screenHeight, screenWidth, screenHeight);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
    }
}

