/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.client.render;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class RenderUtil {
    public static double findSuitableYPosition(ClientLevel level, BlockPos pos, float offsetY) {
        if (level.getChunkSource().getChunk(pos.getX() >> 4, pos.getZ() >> 4, false) == null) {
            return pos.getY();
        }
        for (int yOffset = 1; yOffset >= -3; --yOffset) {
            BlockPos checkPos = pos.offset(0, yOffset, 0);
            BlockPos belowPos = checkPos.below();
            BlockState belowState = level.getBlockState(belowPos);
            if (!belowState.isSolid()) continue;
            VoxelShape shape = belowState.getCollisionShape((BlockGetter)level, belowPos, CollisionContext.empty());
            if (!shape.isEmpty()) {
                double blockTopY = (double)belowPos.getY() + shape.max(Direction.Axis.Y);
                return blockTopY + (double)offsetY;
            }
            return (float)checkPos.getY() + offsetY;
        }
        return (float)pos.getY() + offsetY;
    }
}

