/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.phys.Vec3;
import net.rasanovum.viaromana.CommonConfig;
import net.rasanovum.viaromana.client.ColorUtil;
import net.rasanovum.viaromana.client.data.ClientPathData;
import net.rasanovum.viaromana.client.render.NodeConnectionRenderer;
import net.rasanovum.viaromana.client.render.RenderUtil;
import net.rasanovum.viaromana.items.ChartingMap;
import net.rasanovum.viaromana.path.Node;
import net.rasanovum.viaromana.path.PathGraph;
import net.rasanovum.viaromana.variables.VariableAccess;

public class NodeRenderer {
    private static final float BEAM_HEIGHT = 2.0f;
    private static final float BEAM_WIDTH = 0.6f;
    private static final float BEAM_FADE_FRACTION = 0.5f;
    private static final int BEAM_SEGMENTS = 10;
    private static final float RENDER_DISTANCE = 16.0f;
    private static final float FADE_BUFFER_DISTANCE = 4.0f;
    private static final float NEAR_FADE_START_DISTANCE = 1.0f;
    private static final float NEAR_FADE_END_DISTANCE = 0.5f;
    private static final float VIGNETTE_MAX_INTENSITY = 0.3f;
    private static final int MAX_LIGHT_BRIGHTNESS = 8;
    private static final float BEAM_ALPHA = 0.75f;
    private static final float PULSE_FREQUENCY = 1.0f;
    private static final float PULSE_MIN_ALPHA = 0.1f;
    private static final float PULSE_MAX_ALPHA = 1.0f;
    private static final float CROSS_ANGLE_RADIANS = (float)Math.toRadians(80.0);
    private static final float CROSS_COS = (float)Math.cos(CROSS_ANGLE_RADIANS);
    private static final float CROSS_SIN = (float)Math.sin(CROSS_ANGLE_RADIANS);
    private static final int DEFAULT_BEAM_COLOR = ColorUtil.rgbToHex(255.0f, 255.0f, 255.0f);
    private static final int CHARTING_BEAM_COLOR = ColorUtil.rgbToHex(0.0f, 255.0f, 0.0f);
    private static final ResourceLocation BEAM_TEXTURE = ResourceLocation.parse((String)"via_romana:textures/effect/node_beam.png");
    private static final int SOUND_INTERVAL_TICKS = 40;
    private static final float ANIMATION_SPEED_SEC = -1.0f;
    private static final Map<BlockPos, Long> nodeSoundTimes = new ConcurrentHashMap<BlockPos, Long>();
    private static final Map<BlockPos, Integer> dynamicLightSources = new ConcurrentHashMap<BlockPos, Integer>();
    private static final float GLOBAL_FADE_SPEED = 0.05f;
    private static final float SELECTION_FADE_SPEED = 0.1f;
    private static float globalRenderAlpha = 0.0f;
    private static final Map<BlockPos, Float> animatedNodeAlphas = new ConcurrentHashMap<BlockPos, Float>();
    private static float currentVignetteIntensity = 0.0f;
    private static long lastRenderTime = 0L;
    private static float animationTime = 0.0f;

    private static int getPulseDistance() {
        return CommonConfig.node_utility_distance;
    }

    private static RenderType getRenderType() {
        boolean shadersInUse = false;
        try {
            Class<?> irisApiClass = Class.forName("net.irisshaders.iris.api.v0.IrisApi");
            Object instance = irisApiClass.getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
            shadersInUse = (Boolean)irisApiClass.getMethod("isShaderPackInUse", new Class[0]).invoke(instance, new Object[0]);
        }
        catch (Exception e) {
            shadersInUse = false;
        }
        return shadersInUse ? RenderType.entityTranslucentEmissive((ResourceLocation)BEAM_TEXTURE, (boolean)true) : RenderType.beaconBeam((ResourceLocation)BEAM_TEXTURE, (boolean)true);
    }

    public static int getLightLevel(BlockPos pos) {
        return dynamicLightSources.getOrDefault(pos, 0);
    }

    public static float getCurrentVignetteIntensity() {
        return currentVignetteIntensity * globalRenderAlpha;
    }

    public static float getBeamHeight() {
        return 2.0f;
    }

    public static float calculateDistanceAlpha(double distance, float baseAlpha) {
        return (float)NodeRenderer.calculateValueWithFade(distance, baseAlpha);
    }

    public static int calculateDistanceLightBrightness(double distance) {
        return (int)Math.round(NodeRenderer.calculateValueWithFade(distance, 8.0));
    }

    public static double calculateDistanceToNodeBeam(Vec3 playerPos, BlockPos nodePos, ClientLevel level) {
        double adjustedY = RenderUtil.findSuitableYPosition(level, nodePos, 0.25f);
        return NodeRenderer.calculateDistanceToNodeBeamInternal(playerPos, nodePos, adjustedY);
    }

    public static void renderNodeBeams(PoseStack poseStack, Level level, Player player, float partialTicks) {
        if (!(level instanceof ClientLevel)) {
            return;
        }
        ClientLevel clientLevel = (ClientLevel)level;
        NodeRenderer.updateAnimationTimer();
        boolean shouldRender = VariableAccess.playerVariables.isChartingPath((Entity)player) || player.getMainHandItem().getItem() instanceof ChartingMap || player.getOffhandItem().getItem() instanceof ChartingMap;
        NodeRenderer.updateGlobalAlpha(shouldRender);
        if (globalRenderAlpha <= 0.0f) {
            NodeRenderer.clearAllLightSources(clientLevel);
            animatedNodeAlphas.clear();
            currentVignetteIntensity = 0.0f;
            return;
        }
        Vec3 cameraPos = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
        Vec3 playerPos = player.position();
        List<NodeRenderData> nodeDataList = NodeRenderer.gatherRenderData(clientLevel, playerPos);
        BlockPos selectedNodePos = NodeRenderer.findAndSetSelectedNode(player, nodeDataList);
        NodeRenderer.updateAnimatedAlphas(selectedNodePos);
        currentVignetteIntensity = NodeRenderer.calculateMaxVignette(nodeDataList);
        if (nodeDataList.isEmpty()) {
            NodeRenderer.updateLightSources(clientLevel, Collections.emptyList());
            return;
        }
        nodeDataList.sort(Comparator.comparingDouble(NodeRenderData::distance).reversed());
        MultiBufferSource.BufferSource bufferSource = Minecraft.getInstance().renderBuffers().bufferSource();
        poseStack.pushPose();
        poseStack.translate(-cameraPos.x, -cameraPos.y, -cameraPos.z);
        VertexConsumer beamConsumer = bufferSource.getBuffer(NodeRenderer.getRenderType());
        float vOffset = animationTime * -1.0f;
        for (NodeRenderData data : nodeDataList) {
            NodeRenderer.renderBeam(poseStack, beamConsumer, data, vOffset);
            NodeRenderer.playNodeSoundAtPosition(clientLevel, data.pos, data.adjustedY, level.getGameTime());
        }
        bufferSource.endBatch(NodeRenderer.getRenderType());
        PathGraph graph = ClientPathData.getInstance().getGraph();
        if (graph != null && !graph.nodesView().isEmpty()) {
            NodeConnectionRenderer.renderConnections(poseStack, clientLevel, player, graph, animationTime, (MultiBufferSource)bufferSource, globalRenderAlpha);
        }
        poseStack.popPose();
        bufferSource.endBatch();
        NodeRenderer.updateLightSources(clientLevel, nodeDataList);
    }

    private static void updateAnimationTimer() {
        if (lastRenderTime == 0L) {
            lastRenderTime = System.nanoTime();
            return;
        }
        long currentTime = System.nanoTime();
        float deltaTime = (float)(currentTime - lastRenderTime) / 1.0E9f;
        lastRenderTime = currentTime;
        animationTime += deltaTime;
    }

    private static List<NodeRenderData> gatherRenderData(ClientLevel level, Vec3 playerPos) {
        PathGraph graph;
        ArrayList<NodeRenderData> dataList = new ArrayList<NodeRenderData>();
        double searchRadius = 20.0;
        if (VariableAccess.playerVariables.isChartingPath((Entity)Minecraft.getInstance().player)) {
            ClientPathData.getInstance().getTemporaryNodes().stream().map(nodeData -> {
                double adjY = RenderUtil.findSuitableYPosition(level, nodeData.pos(), 0.25f);
                double dist = NodeRenderer.calculateDistanceToNodeBeamInternal(playerPos, nodeData.pos(), adjY);
                return new NodeRenderData(nodeData.pos(), dist, adjY, CHARTING_BEAM_COLOR);
            }).filter(data -> data.distance <= searchRadius).forEach(dataList::add);
        }
        if ((graph = ClientPathData.getInstance().getGraph()) != null) {
            ClientPathData.getInstance().getNearbyNodes(BlockPos.containing((Position)playerPos), searchRadius, false).stream().map(node -> {
                BlockPos pos = BlockPos.of((long)node.getPos());
                double adjY = RenderUtil.findSuitableYPosition(level, pos, 0.25f);
                double dist = NodeRenderer.calculateDistanceToNodeBeamInternal(playerPos, pos, adjY);
                return new NodeRenderData(pos, dist, adjY, DEFAULT_BEAM_COLOR);
            }).filter(data -> data.distance <= searchRadius).forEach(dataList::add);
        }
        return dataList;
    }

    private static BlockPos findAndSetSelectedNode(Player player, List<NodeRenderData> nodeDataList) {
        ClientPathData clientPathData = ClientPathData.getInstance();
        Node nodeOpt = clientPathData.getNearestNode(player.blockPosition(), NodeRenderer.getPulseDistance(), false).orElse(null);
        return nodeOpt != null ? nodeOpt.getBlockPos() : null;
    }

    private static void renderBeam(PoseStack poseStack, VertexConsumer consumer, NodeRenderData data, float vOffset) {
        float baseAlpha = animatedNodeAlphas.getOrDefault(data.pos(), Float.valueOf(0.75f)).floatValue();
        float distanceAlpha = NodeRenderer.calculateDistanceAlpha(data.distance(), baseAlpha);
        float finalAlpha = distanceAlpha * globalRenderAlpha;
        if (finalAlpha <= 0.01f) {
            return;
        }
        float r = (float)(data.color() >> 16 & 0xFF) / 255.0f;
        float g = (float)(data.color() >> 8 & 0xFF) / 255.0f;
        float b = (float)(data.color() & 0xFF) / 255.0f;
        poseStack.pushPose();
        poseStack.translate((double)data.pos().getX() + 0.5, data.adjustedY(), (double)data.pos().getZ() + 0.5);
        NodeRenderer.renderBeamGeometry(poseStack, consumer, r, g, b, finalAlpha, vOffset);
        poseStack.popPose();
    }

    private static void updateAnimatedAlphas(BlockPos selectedNodePos) {
        HashSet<BlockPos> nodesToAnimate = new HashSet<BlockPos>(animatedNodeAlphas.keySet());
        if (selectedNodePos != null) {
            nodesToAnimate.add(selectedNodePos);
        }
        for (BlockPos pos : nodesToAnimate) {
            float targetAlpha;
            boolean isSelected = pos.equals((Object)selectedNodePos);
            float currentAlpha = animatedNodeAlphas.getOrDefault(pos, Float.valueOf(0.75f)).floatValue();
            if (isSelected) {
                float pulseValue = (float)(Math.sin((double)(animationTime * 1.0f * 2.0f) * Math.PI) * 0.5 + 0.5);
                targetAlpha = Mth.lerp((float)pulseValue, (float)0.1f, (float)1.0f);
            } else {
                targetAlpha = 0.75f;
            }
            float newAlpha = Mth.lerp((float)0.1f, (float)currentAlpha, (float)targetAlpha);
            if (!isSelected && Math.abs(newAlpha - 0.75f) < 0.01f) {
                animatedNodeAlphas.remove(pos);
                continue;
            }
            animatedNodeAlphas.put(pos, Float.valueOf(newAlpha));
        }
    }

    private static void updateGlobalAlpha(boolean shouldRender) {
        float targetAlpha = shouldRender ? 1.0f : 0.0f;
        if (Math.abs((globalRenderAlpha = Mth.lerp((float)0.05f, (float)globalRenderAlpha, (float)targetAlpha)) - targetAlpha) < 0.005f) {
            globalRenderAlpha = targetAlpha;
        }
    }

    private static float calculateMaxVignette(List<NodeRenderData> nodeDataList) {
        return nodeDataList.stream().filter(data -> data.color() != CHARTING_BEAM_COLOR).map(data -> Float.valueOf(NodeRenderer.calculateVignetteForDistance(data.distance()))).max(Float::compare).orElse(Float.valueOf(0.0f)).floatValue();
    }

    private static void updateLightSources(ClientLevel level, List<NodeRenderData> visibleNodes) {
        LevelLightEngine lightEngine = level.getLightEngine();
        HashSet<BlockPos> currentLightPositions = new HashSet<BlockPos>();
        for (NodeRenderData data : visibleNodes) {
            int lightLevel = (int)((float)NodeRenderer.calculateDistanceLightBrightness(data.distance()) * globalRenderAlpha);
            if (lightLevel <= 0) continue;
            BlockPos lightPos = BlockPos.containing((double)data.pos().getX(), (double)(data.adjustedY() + 1.0), (double)data.pos().getZ());
            currentLightPositions.add(lightPos);
            if (dynamicLightSources.getOrDefault(lightPos, 0) == lightLevel) continue;
            dynamicLightSources.put(lightPos, lightLevel);
            lightEngine.checkBlock(lightPos);
        }
        dynamicLightSources.keySet().removeIf(pos -> {
            if (!currentLightPositions.contains(pos)) {
                lightEngine.checkBlock(pos);
                return true;
            }
            return false;
        });
    }

    private static void renderBeamGeometry(PoseStack poseStack, VertexConsumer consumer, float r, float g, float b, float a, float vOffset) {
        float halfWidth;
        PoseStack.Pose pose = poseStack.last();
        float x1 = halfWidth = 0.3f;
        float z1 = 0.0f;
        float x2 = halfWidth * CROSS_COS;
        float z2 = halfWidth * CROSS_SIN;
        float vMin = vOffset;
        float vMax = vMin + 1.0f;
        int overlay = 655360;
        int light = 0xF000F0;
        int rgb = (int)(r * 255.0f) << 16 | (int)(g * 255.0f) << 8 | (int)(b * 255.0f);
        for (int i = 0; i < 10; ++i) {
            float t0 = (float)i / 10.0f;
            float t1 = (float)(i + 1) / 10.0f;
            float y0 = t0 * 2.0f;
            float y1 = t1 * 2.0f;
            float a0 = a * NodeRenderer.fadeEnds(t0);
            float a1 = a * NodeRenderer.fadeEnds(t1);
            float vt0 = Mth.lerp((float)t0, (float)vMin, (float)vMax);
            float vt1 = Mth.lerp((float)t1, (float)vMin, (float)vMax);
            int color0 = (int)(a0 * 255.0f) << 24 | rgb;
            int color1 = (int)(a1 * 255.0f) << 24 | rgb;
            NodeRenderer.renderSegment(pose, consumer, -x1, y0, -z1, x1, y1, z1, color0, color1, vt0, vt1, overlay, light);
            NodeRenderer.renderSegment(pose, consumer, -x2, y0, -z2, x2, y1, z2, color0, color1, vt0, vt1, overlay, light);
        }
    }

    private static void renderSegment(PoseStack.Pose pose, VertexConsumer consumer, float x1, float y0, float z1, float x2, float y1, float z2, int color0, int color1, float v0, float v1, int overlay, int light) {
        consumer.addVertex(pose, x1, y0, z1).setColor(color0).setUv(0.0f, v0).setOverlay(overlay).setLight(light).setNormal(1.0f, 0.0f, 0.0f);
        consumer.addVertex(pose, x2, y0, z2).setColor(color0).setUv(1.0f, v0).setOverlay(overlay).setLight(light).setNormal(1.0f, 0.0f, 0.0f);
        consumer.addVertex(pose, x2, y1, z2).setColor(color1).setUv(1.0f, v1).setOverlay(overlay).setLight(light).setNormal(1.0f, 0.0f, 0.0f);
        consumer.addVertex(pose, x1, y1, z1).setColor(color1).setUv(0.0f, v1).setOverlay(overlay).setLight(light).setNormal(1.0f, 0.0f, 0.0f);
        consumer.addVertex(pose, x2, y0, z2).setColor(color0).setUv(0.0f, v0).setOverlay(overlay).setLight(light).setNormal(-1.0f, 0.0f, 0.0f);
        consumer.addVertex(pose, x1, y0, z1).setColor(color0).setUv(1.0f, v0).setOverlay(overlay).setLight(light).setNormal(-1.0f, 0.0f, 0.0f);
        consumer.addVertex(pose, x1, y1, z1).setColor(color1).setUv(1.0f, v1).setOverlay(overlay).setLight(light).setNormal(-1.0f, 0.0f, 0.0f);
        consumer.addVertex(pose, x2, y1, z2).setColor(color1).setUv(0.0f, v1).setOverlay(overlay).setLight(light).setNormal(-1.0f, 0.0f, 0.0f);
    }

    private static double calculateValueWithFade(double distance, double maxValue) {
        if (distance < 0.5) {
            return 0.0;
        }
        if (distance < 1.0) {
            return maxValue * ((distance - 0.5) / 0.5);
        }
        if (distance > 16.0) {
            return maxValue * (1.0 - Mth.clamp((double)((distance - 16.0) / 4.0), (double)0.0, (double)1.0));
        }
        return maxValue;
    }

    private static float calculateVignetteForDistance(double distance) {
        if (distance >= 1.0) {
            return 0.0f;
        }
        if (distance <= 0.5) {
            return 0.3f;
        }
        return 0.3f * (1.0f - (float)((distance - 0.5) / 0.5));
    }

    private static double calculateDistanceToNodeBeamInternal(Vec3 playerPos, BlockPos nodePos, double adjustedY) {
        double clampedY = Mth.clamp((double)playerPos.y, (double)adjustedY, (double)(adjustedY + 2.0));
        return playerPos.distanceTo(new Vec3((double)nodePos.getX() + 0.5, clampedY, (double)nodePos.getZ() + 0.5));
    }

    private static float fadeEnds(float t) {
        return Mth.clamp((float)(Math.min(t, 1.0f - t) / 0.5f), (float)0.0f, (float)1.0f);
    }

    private static void playNodeSoundAtPosition(ClientLevel level, BlockPos pos, double adjustedY, long currentTime) {
        if (nodeSoundTimes.getOrDefault(pos, 0L) > currentTime - 40L) {
            return;
        }
        nodeSoundTimes.put(pos, currentTime);
        level.playLocalSound((double)pos.getX() + 0.5, adjustedY + 1.0, (double)pos.getZ() + 0.5, SoundEvents.BEACON_AMBIENT, SoundSource.AMBIENT, 0.3f * globalRenderAlpha, 1.0f, false);
    }

    private static void clearAllLightSources(ClientLevel level) {
        if (!dynamicLightSources.isEmpty()) {
            LevelLightEngine lightEngine = level.getLightEngine();
            dynamicLightSources.keySet().forEach(arg_0 -> ((LevelLightEngine)lightEngine).checkBlock(arg_0));
            dynamicLightSources.clear();
        }
    }

    private record NodeRenderData(BlockPos pos, double distance, double adjustedY, int color) {
    }
}

