/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.client.gui.elements;

import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;

public class MapSignatureButton
extends AbstractButton {
    private final String playerName;
    private final Consumer<Void> onPress;
    private static final int LINE_HEIGHT = 1;

    public MapSignatureButton(Font font, int x, int y, int width, String playerName, Consumer<Void> onPress) {
        super(x, y, width, 20, (Component)Component.literal((String)""));
        this.playerName = playerName;
        this.onPress = onPress;
        this.setTooltip(Tooltip.create((Component)Component.literal((String)"Click to confirm link")));
    }

    public void onPress() {
        if (this.onPress != null) {
            this.onPress.accept(null);
        }
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (!this.visible) {
            return;
        }
        Font font = Minecraft.getInstance().font;
        int lineY = this.getY() + this.height - 1 - 2;
        guiGraphics.fill(this.getX(), lineY, this.getX() + this.width, lineY + 1, -16777216);
        if (this.isHovered()) {
            String displayText = this.playerName;
            int textX = this.getX() + 5;
            Objects.requireNonNull(font);
            int textY = lineY - 9 - 2;
            guiGraphics.drawString(font, displayText, textX, textY, 6048314, false);
        }
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
        this.defaultButtonNarrationText(narrationElementOutput);
    }
}

