/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.client.gui.elements;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.Consumer;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.rasanovum.viaromana.path.Node;

public class MapIconButton
extends AbstractButton {
    private final Node.Icon icon;
    private final Consumer<Node.Icon> onPress;
    private boolean isSelected = false;
    private static final int ICON_SIZE = 16;
    public static final int CIRCLE_SIZE = 32;

    public MapIconButton(Font font, int x, int y, Node.Icon icon, Consumer<Node.Icon> onPress) {
        super(x, y, 32, 32, (Component)Component.empty());
        this.icon = icon;
        this.onPress = onPress;
    }

    public void onPress() {
        if (this.onPress != null) {
            this.onPress.accept(this.icon);
        }
    }

    public Node.Icon getIcon() {
        return this.icon;
    }

    public void setSelected(boolean selected) {
        this.isSelected = selected;
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    private ResourceLocation getIconTexture(Node.Icon icon) {
        String textureName = switch (icon) {
            default -> throw new MatchException(null, null);
            case Node.Icon.SIGNPOST -> "marker_signpost";
            case Node.Icon.HOUSE -> "marker_house";
            case Node.Icon.SHOP -> "marker_shop";
            case Node.Icon.TOWER -> "marker_tower";
            case Node.Icon.CAVE -> "marker_cave";
            case Node.Icon.CROP -> "marker_crop";
            case Node.Icon.PORTAL -> "marker_portal";
            case Node.Icon.BOOK -> "marker_book";
        };
        return ResourceLocation.parse((String)("via_romana:textures/screens/" + textureName + ".png"));
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (!this.visible) {
            return;
        }
        int centerX = this.getX() + this.width / 2;
        int centerY = this.getY() + this.height / 2;
        ResourceLocation iconTexture = this.getIconTexture(this.icon);
        int iconX = centerX - 8;
        int iconY = centerY - 8;
        guiGraphics.blit(iconTexture, iconX, iconY, 0.0f, 0.0f, 16, 16, 16, 16);
        if (this.isSelected || this.isHovered()) {
            ResourceLocation circleTexture = ResourceLocation.parse((String)"via_romana:textures/screens/element_circle.png");
            int circleX = centerX - 16;
            int circleY = centerY - 16;
            if (this.isSelected) {
                guiGraphics.blit(circleTexture, circleX, circleY, 0.0f, 0.0f, 32, 32, 32, 32);
            } else {
                guiGraphics.pose().pushPose();
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.3f);
                guiGraphics.blit(circleTexture, circleX, circleY, 0.0f, 0.0f, 32, 32, 32, 32);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.disableBlend();
                guiGraphics.pose().popPose();
            }
        }
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
        this.defaultButtonNarrationText(narrationElementOutput);
    }
}

