/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Point;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IntSummaryStatistics;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.rasanovum.viaromana.CommonConfig;
import net.rasanovum.viaromana.ViaRomana;
import net.rasanovum.viaromana.client.ColorUtil;
import net.rasanovum.viaromana.client.MapClient;
import net.rasanovum.viaromana.client.gui.MapRenderer;
import net.rasanovum.viaromana.network.ViaRomanaModVariables;
import net.rasanovum.viaromana.network.packets.DestinationResponseS2C;
import net.rasanovum.viaromana.network.packets.SignValidationRequestC2S;
import net.rasanovum.viaromana.network.packets.TeleportRequestC2S;
import net.rasanovum.viaromana.teleport.TeleportHelper;

public class TeleportMapScreen
extends Screen {
    private MapClient.MapTexture mapTexture;
    private MapRenderer mapRenderer;
    private final List<DestinationResponseS2C.NodeNetworkInfo> networkNodes;
    private final BlockPos signPos;
    private final BlockPos sourceNodePos;
    private final UUID networkId;
    private final List<TeleportHelper.TeleportDestination> destinations;
    private final Map<BlockPos, DestinationResponseS2C.NodeNetworkInfo> networkNodeMap;
    private BlockPos minBounds;
    private BlockPos maxBounds;
    private float animationProgress = 0.0f;
    private final Set<BlockPos> animatedNodes = new HashSet<BlockPos>();
    private final List<DestinationResponseS2C.NodeNetworkInfo> nodesToAnimate = new ArrayList<DestinationResponseS2C.NodeNetworkInfo>();
    private final Map<BlockPos, Float> destinationFadeProgress = new HashMap<BlockPos, Float>();
    private final Set<BlockPos> validatedNodes = new HashSet<BlockPos>();
    private final Set<BlockPos> destinationPositions;
    private static final int MARKER_SIZE = 16;
    private static final int PLAYER_MARKER_SIZE = 8;
    private static final float MARKER_FADE_SPEED = 0.05f;
    private static final int DIRECTION_INDICATOR_BUFFER = 2;
    private static final float DIRECTION_ANGLE_RANGE = 45.0f;
    private static final float DIRECTION_BASE_OPACITY = 1.0f;
    private static final float DIRECTION_FADE_CURVE = 1.0f;
    private static final int DIRECTION_COLOR_RGB = ColorUtil.rgbToHex(1.0f, 1.0f, 1.0f);
    private static final int THICKNESS = 1;

    private static float getAnimationSpeed() {
        return CommonConfig.spline_animation_speed;
    }

    public TeleportMapScreen(DestinationResponseS2C packet) {
        super((Component)Component.literal((String)"Teleport Network"));
        this.signPos = packet.signPos();
        this.sourceNodePos = packet.sourceNodePos();
        this.networkId = packet.networkId();
        this.networkNodes = new ArrayList<DestinationResponseS2C.NodeNetworkInfo>(packet.networkNodes());
        this.destinations = packet.destinations().stream().map(dest -> new TeleportHelper.TeleportDestination(dest.position, dest.name, dest.distance, dest.icon)).collect(Collectors.toList());
        this.networkNodeMap = packet.networkNodes().stream().collect(Collectors.toMap(info -> info.position, info -> info));
        this.destinationPositions = this.destinations.stream().map(dest -> dest.position).collect(Collectors.toSet());
        this.calculateBounds();
        int widthW = this.maxBounds.getX() - this.minBounds.getX();
        int heightW = this.maxBounds.getZ() - this.minBounds.getZ();
        int paddingX = Math.max(16, (int)((float)widthW * 0.1f));
        int paddingZ = Math.max(16, (int)((float)heightW * 0.1f));
        BlockPos paddedMin = this.minBounds.offset(-paddingX, 0, -paddingZ);
        BlockPos paddedMax = this.maxBounds.offset(paddingX, 0, paddingZ);
        this.mapRenderer = new MapRenderer(paddedMin, paddedMax, this.networkNodes);
        this.requestMapAsync(paddedMin, paddedMax);
    }

    private void requestMapAsync(BlockPos paddedMin, BlockPos paddedMax) {
        ((CompletableFuture)MapClient.requestMap(this.networkId, paddedMin, paddedMax, this.networkNodes).thenAccept(mapInfo -> {
            if (mapInfo != null) {
                this.minecraft.execute(() -> {
                    if (this.mapTexture != null) {
                        this.mapTexture.close();
                    }
                    this.mapTexture = MapClient.createTexture(mapInfo);
                    if (this.mapRenderer != null) {
                        this.mapRenderer.setMapTexture(this.mapTexture);
                    }
                });
            }
        })).exceptionally(ex -> {
            ViaRomana.LOGGER.error("Failed to load map for network {}", (Object)this.networkId, ex);
            return null;
        });
    }

    protected void init() {
        super.init();
        if (this.sourceNodePos != null) {
            Optional.ofNullable(this.networkNodeMap.get(this.sourceNodePos)).ifPresent(this.nodesToAnimate::add);
        }
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
        if (this.mapTexture == null || this.minecraft == null || this.minecraft.player == null || this.mapRenderer == null) {
            return;
        }
        this.renderBlurredBackground(partialTicks);
        this.mapRenderer.render(guiGraphics, this.width, this.height, (Player)this.minecraft.player);
        this.renderNetwork(guiGraphics, partialTicks);
        HashSet<BlockPos> revealedNodes = new HashSet<BlockPos>(this.animatedNodes);
        this.nodesToAnimate.forEach(n -> revealedNodes.add(n.position));
        this.renderDestinationMarkers(guiGraphics, revealedNodes, mouseX, mouseY);
        this.renderPlayerMarker(guiGraphics, (Player)this.minecraft.player);
        this.renderTooltip(guiGraphics, revealedNodes, mouseX, mouseY);
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
    }

    private void renderNetwork(GuiGraphics guiGraphics, float partialTicks) {
        if (this.networkNodeMap.isEmpty()) {
            return;
        }
        if (!this.nodesToAnimate.isEmpty()) {
            this.animationProgress = Math.min(1.0f, this.animationProgress + partialTicks * TeleportMapScreen.getAnimationSpeed());
        }
        Set currentlyAnimatingSources = this.nodesToAnimate.stream().map(info -> info.position).collect(Collectors.toSet());
        for (DestinationResponseS2C.NodeNetworkInfo nodeInfo : this.networkNodeMap.values()) {
            BlockPos startPos = nodeInfo.position;
            boolean isStartCompleted = this.animatedNodes.contains(startPos);
            boolean isStartAnimating = currentlyAnimatingSources.contains(startPos);
            if (!isStartCompleted && !isStartAnimating) continue;
            this.worldToScreen(startPos).ifPresent(startScreenPos -> {
                for (BlockPos endPos : nodeInfo.connections) {
                    int lineColor;
                    boolean isEndCompleted = this.animatedNodes.contains(endPos);
                    boolean isEndAnimating = currentlyAnimatingSources.contains(endPos);
                    DestinationResponseS2C.NodeNetworkInfo endNodeInfo = this.networkNodeMap.get(endPos);
                    boolean bothUnderground = nodeInfo.clearance > 0.0f && nodeInfo.clearance < 5.0f && endNodeInfo != null && endNodeInfo.clearance > 0.0f && endNodeInfo.clearance < 5.0f;
                    int n = lineColor = bothUnderground ? -5592406 : -1;
                    if (isStartCompleted && isEndCompleted) {
                        if (startPos.hashCode() >= endPos.hashCode()) continue;
                        this.worldToScreen(endPos).ifPresent(endScreenPos -> this.drawLine(guiGraphics, (Point)startScreenPos, (Point)endScreenPos, lineColor, 1));
                        continue;
                    }
                    if (isStartCompleted && isEndAnimating) {
                        this.worldToScreen(endPos).ifPresent(endScreenPos -> this.drawLine(guiGraphics, (Point)startScreenPos, (Point)endScreenPos, lineColor, 1));
                        continue;
                    }
                    if (!isStartAnimating || isEndCompleted) continue;
                    this.worldToScreen(endPos).ifPresent(endScreenPos -> {
                        Point animatedEndPoint = this.getAnimatedPoint((Point)startScreenPos, (Point)endScreenPos, this.animationProgress);
                        this.drawLine(guiGraphics, (Point)startScreenPos, animatedEndPoint, lineColor, 1);
                    });
                }
            });
        }
        if (this.animationProgress >= 1.0f && !this.nodesToAnimate.isEmpty()) {
            HashSet<BlockPos> nextWavePositions = new HashSet<BlockPos>();
            for (DestinationResponseS2C.NodeNetworkInfo completedNode : this.nodesToAnimate) {
                this.animatedNodes.add(completedNode.position);
                if (this.destinationPositions.contains(completedNode.position)) {
                    this.validateNodeSign(completedNode.position);
                }
                for (BlockPos connPos : completedNode.connections) {
                    if (this.animatedNodes.contains(connPos)) continue;
                    nextWavePositions.add(connPos);
                }
            }
            this.nodesToAnimate.clear();
            nextWavePositions.stream().map(this.networkNodeMap::get).filter(Objects::nonNull).forEach(this.nodesToAnimate::add);
            this.animationProgress = 0.0f;
        }
    }

    private Point getAnimatedPoint(Point start, Point end, float progress) {
        float dx = end.x - start.x;
        float dy = end.y - start.y;
        return new Point((int)((float)start.x + dx * progress), (int)((float)start.y + dy * progress));
    }

    private void renderDestinationMarkers(GuiGraphics guiGraphics, Set<BlockPos> revealedNodes, int mouseX, int mouseY) {
        revealedNodes.stream().filter(this.destinationPositions::contains).filter(this.validatedNodes::contains).forEach(pos -> {
            float progress = this.destinationFadeProgress.getOrDefault(pos, Float.valueOf(0.0f)).floatValue();
            if (progress < 1.0f) {
                this.destinationFadeProgress.put((BlockPos)pos, Float.valueOf(Math.min(1.0f, progress + 0.05f)));
            }
        });
        for (TeleportHelper.TeleportDestination dest : this.destinations) {
            if (!this.destinationFadeProgress.containsKey(dest.position) || !this.validatedNodes.contains(dest.position)) continue;
            this.worldToScreen(dest.position).ifPresent(screenPos -> {
                float alpha = this.destinationFadeProgress.get(dest.position).floatValue();
                boolean isHovered = this.getDestinationAtPosition(revealedNodes, mouseX, mouseY).map(hovered -> hovered.position.equals((Object)dest.position)).orElse(false);
                ResourceLocation markerTexture = ResourceLocation.parse((String)("via_romana:textures/screens/marker_" + dest.icon.toString().toLowerCase() + ".png"));
                int x = screenPos.x - 8;
                int y = screenPos.y - 8;
                guiGraphics.pose().pushPose();
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)0.0f, (float)(alpha / 2.0f));
                guiGraphics.blit(markerTexture, x + 1, y + 1, 0.0f, 0.0f, 16, 16, 16, 16);
                float brightness = isHovered ? 1.25f : 1.0f;
                RenderSystem.setShaderColor((float)brightness, (float)brightness, (float)brightness, (float)alpha);
                guiGraphics.blit(markerTexture, x, y, 0.0f, 0.0f, 16, 16, 16, 16);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.disableBlend();
                guiGraphics.pose().popPose();
            });
        }
    }

    private void renderPlayerMarker(GuiGraphics guiGraphics, Player player) {
        if (player == null || this.minecraft == null) {
            return;
        }
        this.worldToScreen(player.blockPosition()).ifPresent(screenPos -> {
            int x = screenPos.x - 4;
            int y = screenPos.y - 4;
            ResourceLocation skin = this.minecraft.getSkinManager().getInsecureSkin(player.getGameProfile()).texture();
            guiGraphics.pose().pushPose();
            RenderSystem.enableBlend();
            RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.5f);
            guiGraphics.blit(skin, x + 1, y + 1, 8.0f, 8.0f, 8, 8, 64, 64);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            guiGraphics.blit(skin, x, y, 8.0f, 8.0f, 8, 8, 64, 64);
            guiGraphics.blit(skin, x, y, 40.0f, 8.0f, 8, 8, 64, 64);
            RenderSystem.disableBlend();
            guiGraphics.pose().popPose();
            this.renderPlayerDirectionIndicator(guiGraphics, (Point)screenPos, 8, player.getYRot());
        });
    }

    private void renderPlayerDirectionIndicator(GuiGraphics guiGraphics, Point centerPos, int markerSize, float yaw) {
        int indicatorSize = markerSize + 2;
        float facingAngle = (yaw % 360.0f + 360.0f + 180.0f) % 360.0f;
        int baseAlpha = 255;
        int directionColor = baseAlpha << 24 | DIRECTION_COLOR_RGB;
        this.renderDirectionalPixels(guiGraphics, centerPos, indicatorSize, facingAngle, directionColor);
    }

    private void renderDirectionalPixels(GuiGraphics guiGraphics, Point center, int size, float facingAngle, int baseColor) {
        int half = size / 2;
        int left = center.x - half;
        int top = center.y - half;
        for (int i = 0; i < size * 4 - 4; ++i) {
            int y;
            int x;
            if (i < size) {
                x = left + i;
                y = top;
            } else if (i < size * 2 - 1) {
                x = left + size - 1;
                y = top + (i - size + 1);
            } else if (i < size * 3 - 2) {
                x = left + size - 1 - (i - (size * 2 - 2));
                y = top + size - 1;
            } else {
                x = left;
                y = top + size - 1 - (i - (size * 3 - 3));
            }
            float pixelAngle = this.getPixelAngle(center, new Point(x, y));
            if (!this.isWithinAngleRange(pixelAngle, facingAngle, 45.0f)) continue;
            int fadedColor = this.getFadedColor(baseColor, pixelAngle, facingAngle, 45.0f);
            guiGraphics.fill(x, y, x + 1, y + 1, fadedColor);
        }
    }

    private void renderTooltip(GuiGraphics guiGraphics, Set<BlockPos> revealedNodes, int mouseX, int mouseY) {
        this.getDestinationAtPosition(revealedNodes, mouseX, mouseY).ifPresentOrElse(dest -> {
            long dist = Math.round(dest.distance);
            String unit = dist > 1000L ? "km" : "m";
            long displayDist = dist > 1000L ? dist / 1000L : dist;
            String text = String.format("%s - %d %s", dest.name, displayDist, unit);
            guiGraphics.renderTooltip(this.font, (Component)Component.literal((String)text), mouseX, mouseY);
        }, () -> {
            if (this.isMouseOverPlayer(mouseX, mouseY)) {
                guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"gui.viaromana.player_marker"), mouseX, mouseY);
            }
        });
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 0) {
            HashSet<BlockPos> revealedNodes = new HashSet<BlockPos>(this.animatedNodes);
            this.nodesToAnimate.forEach(node -> revealedNodes.add(node.position));
            this.getDestinationAtPosition(revealedNodes, (int)mouseX, (int)mouseY).ifPresent(this::selectDestination);
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public void selectDestination(TeleportHelper.TeleportDestination destination) {
        if (this.minecraft == null || this.minecraft.player == null) {
            return;
        }
        TeleportRequestC2S packet = new TeleportRequestC2S(this.signPos, destination.position);
        if (ViaRomanaModVariables.networkHandler != null) {
            ViaRomanaModVariables.networkHandler.sendToServer(packet);
        } else {
            ViaRomana.LOGGER.error("Network handler is null - cannot send teleport request");
        }
        this.onClose();
    }

    private void validateNodeSign(BlockPos nodePos) {
        if (!this.validatedNodes.contains(nodePos)) {
            SignValidationRequestC2S packet = new SignValidationRequestC2S(nodePos);
            if (ViaRomanaModVariables.networkHandler != null) {
                ViaRomanaModVariables.networkHandler.sendToServer(packet);
            }
        }
    }

    public void handleSignValidation(BlockPos nodePos, boolean isValid) {
        if (isValid) {
            this.validatedNodes.add(nodePos);
        }
    }

    private void calculateBounds() {
        if (this.networkNodeMap.isEmpty()) {
            BlockPos playerPos = this.minecraft.player != null ? this.minecraft.player.blockPosition() : BlockPos.ZERO;
            this.minBounds = playerPos.offset(-128, 0, -128);
            this.maxBounds = playerPos.offset(128, 0, 128);
            return;
        }
        IntSummaryStatistics xStats = this.networkNodeMap.keySet().stream().mapToInt(Vec3i::getX).summaryStatistics();
        IntSummaryStatistics zStats = this.networkNodeMap.keySet().stream().mapToInt(Vec3i::getZ).summaryStatistics();
        int width = xStats.getMax() - xStats.getMin();
        int height = zStats.getMax() - zStats.getMin();
        int padding = Math.max(16, (int)((float)Math.max(width, height) * 0.1f));
        this.minBounds = new BlockPos(xStats.getMin() - padding, 0, zStats.getMin() - padding);
        this.maxBounds = new BlockPos(xStats.getMax() + padding, 0, zStats.getMax() + padding);
    }

    private Optional<Point> worldToScreen(BlockPos worldPos) {
        if (this.mapRenderer == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.mapRenderer.worldToScreen(worldPos, this.width, this.height));
    }

    private boolean isMouseOver(Point screenPos, int size, int mouseX, int mouseY) {
        int tolerance = size / 2;
        return Math.abs(mouseX - screenPos.x) <= tolerance && Math.abs(mouseY - screenPos.y) <= tolerance;
    }

    private boolean isMouseOverPlayer(int mouseX, int mouseY) {
        if (this.minecraft == null || this.minecraft.player == null) {
            return false;
        }
        return this.worldToScreen(this.minecraft.player.blockPosition()).map(screenPos -> this.isMouseOver((Point)screenPos, 8, mouseX, mouseY)).orElse(false);
    }

    private Optional<TeleportHelper.TeleportDestination> getDestinationAtPosition(Set<BlockPos> revealedNodes, int mouseX, int mouseY) {
        for (TeleportHelper.TeleportDestination dest : this.destinations) {
            Optional<Point> screenPosOpt;
            if (!revealedNodes.contains(dest.position) || !this.validatedNodes.contains(dest.position) || !(screenPosOpt = this.worldToScreen(dest.position)).isPresent() || !this.isMouseOver(screenPosOpt.get(), 16, mouseX, mouseY)) continue;
            return Optional.of(dest);
        }
        return Optional.empty();
    }

    private void drawLine(GuiGraphics guiGraphics, Point start, Point end, int color, int thickness) {
        int dx = Math.abs(end.x - start.x);
        int sx = start.x < end.x ? 1 : -1;
        int dy = -Math.abs(end.y - start.y);
        int sy = start.y < end.y ? 1 : -1;
        int err = dx + dy;
        int x = start.x;
        int y = start.y;
        int half = thickness / 2;
        while (true) {
            guiGraphics.fill(x - half, y - half, x + thickness - half, y + thickness - half, color);
            if (x == end.x && y == end.y) break;
            int e2 = 2 * err;
            if (e2 >= dy) {
                err += dy;
                x += sx;
            }
            if (e2 > dx) continue;
            err += dx;
            y += sy;
        }
    }

    private float getPixelAngle(Point center, Point pixel) {
        return (float)((Math.toDegrees(Math.atan2(pixel.x - center.x, center.y - pixel.y)) + 360.0) % 360.0);
    }

    private boolean isWithinAngleRange(float angle, float target, float range) {
        float diff = Math.abs(angle - target);
        if (diff > 180.0f) {
            diff = 360.0f - diff;
        }
        return diff <= range;
    }

    private int getFadedColor(int baseColor, float pixelAngle, float facingAngle, float angleRange) {
        float diff = Math.abs(pixelAngle - facingAngle);
        if (diff > 180.0f) {
            diff = 360.0f - diff;
        }
        float fadeFactor = (float)Math.pow(1.0f - diff / angleRange, 1.0);
        fadeFactor = Math.max(0.0f, Math.min(1.0f, fadeFactor));
        int alpha = baseColor >> 24 & 0xFF;
        int fadedAlpha = (int)((float)alpha * fadeFactor);
        return fadedAlpha << 24 | baseColor & 0xFFFFFF;
    }

    public void onClose() {
        if (this.mapTexture != null) {
            this.mapTexture.close();
            this.mapTexture = null;
        }
        if (this.mapRenderer != null) {
            this.mapRenderer.close();
            this.mapRenderer = null;
        }
        super.onClose();
    }

    public boolean isPauseScreen() {
        return false;
    }
}

