/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.client.gui;

import com.mojang.blaze3d.platform.NativeImage;
import java.awt.Point;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.world.entity.player.Player;
import net.rasanovum.viaromana.ViaRomana;
import net.rasanovum.viaromana.client.MapClient;
import net.rasanovum.viaromana.client.gui.MapCoordinateSystem;
import net.rasanovum.viaromana.network.packets.DestinationResponseS2C;

public class MapRenderer
implements AutoCloseable {
    private static final int SCREEN_MARGIN = 40;
    private static final int BACKGROUND_TILE_SIZE = 32;
    private static final float MIN_VISIBLE_TILE_FRACTION = 0.4f;
    private static final int EDGE_GRADIENT_DISTANCE_SCREEN = 14;
    private static final float GRADIENT_RANDOMNESS = 0.3f;
    private static final float MAP_OPACITY = 0.75f;
    private static final ResourceLocation[] CORNER_TILES = MapRenderer.createTileLocations("corner-", 4);
    private static final ResourceLocation[] EDGE_TILES = MapRenderer.createTileLocations("edge-", 24);
    private static final ResourceLocation[] CENTER_TILES = MapRenderer.createTileLocations("center-", 4);
    private static final Map<ResourceLocation, NativeImage> tileImageCache = new ConcurrentHashMap<ResourceLocation, NativeImage>();
    private final BlockPos requestedMinBounds;
    private final BlockPos requestedMaxBounds;
    private final long tileSeed;
    private MapClient.MapTexture mapTexture;
    private DynamicTexture bakedDynamicTexture;
    private ResourceLocation bakedTextureLocation;
    private MapCoordinateSystem coordinateSystem;
    private float lastRenderScale = -1.0f;
    private int bakedTextureWidth;
    private int bakedTextureHeight;

    public MapRenderer(BlockPos minBounds, BlockPos maxBounds, List<DestinationResponseS2C.NodeNetworkInfo> networkNodes) {
        this.requestedMinBounds = minBounds;
        this.requestedMaxBounds = maxBounds;
        this.tileSeed = (long)this.requestedMinBounds.hashCode() * 31L + (long)this.requestedMaxBounds.hashCode();
    }

    private static ResourceLocation[] createTileLocations(String prefix, int count) {
        ResourceLocation[] locations = new ResourceLocation[count];
        for (int i = 0; i < count; ++i) {
            locations[i] = ResourceLocation.parse((String)("via_romana:textures/screens/background_tile/" + prefix + (i + 1) + ".png"));
        }
        return locations;
    }

    public void setMapTexture(MapClient.MapTexture mapTexture) {
        this.mapTexture = mapTexture;
    }

    public void render(GuiGraphics guiGraphics, int screenWidth, int screenHeight, Player player) {
        if (this.mapTexture == null) {
            return;
        }
        int availableWidth = screenWidth - 40;
        int availableHeight = screenHeight - 40;
        float scale = Math.min((float)availableWidth / (float)this.mapTexture.nativeImage.getWidth(), (float)availableHeight / (float)this.mapTexture.nativeImage.getHeight());
        if (this.bakedDynamicTexture == null || Math.abs(scale - this.lastRenderScale) > 0.1f) {
            this.rebuildBakedTexture(scale);
        }
        if (this.bakedDynamicTexture == null || this.coordinateSystem == null) {
            return;
        }
        MapCoordinateSystem.MapRenderInfo renderInfo = this.coordinateSystem.updateAndGetRenderInfo(availableWidth + 40, availableHeight + 40);
        guiGraphics.blit(this.bakedTextureLocation, renderInfo.x, renderInfo.y, renderInfo.width, renderInfo.height, 0.0f, 0.0f, this.bakedTextureWidth, this.bakedTextureHeight, this.bakedTextureWidth, this.bakedTextureHeight);
    }

    private void rebuildBakedTexture(float scale) {
        this.lastRenderScale = scale;
        if (this.bakedDynamicTexture != null) {
            this.bakedDynamicTexture.close();
        }
        try (NativeImage newBakedImage = this.bakeBackgroundAndMap(this.mapTexture.nativeImage, scale);){
            this.bakedTextureWidth = newBakedImage.getWidth();
            this.bakedTextureHeight = newBakedImage.getHeight();
            this.bakedDynamicTexture = new DynamicTexture(newBakedImage);
            this.bakedTextureLocation = Minecraft.getInstance().getTextureManager().register("baked_map", this.bakedDynamicTexture);
        }
        BlockPos imageMin = this.mapTexture.mapInfo.minBounds();
        BlockPos imageMax = this.mapTexture.mapInfo.maxBounds();
        this.coordinateSystem = new MapCoordinateSystem(imageMin, imageMax, this.mapTexture.nativeImage.getWidth(), this.mapTexture.nativeImage.getHeight(), this.bakedTextureWidth, this.bakedTextureHeight, this.mapTexture.mapInfo.bakeScaleFactor());
    }

    private NativeImage bakeBackgroundAndMap(NativeImage mapImage, float renderScale) {
        ViaRomana.LOGGER.debug("Baking new texture with render scale: {}", (Object)Float.valueOf(renderScale));
        int mapWidthPx = mapImage.getWidth();
        int mapHeightPx = mapImage.getHeight();
        int tileSize = 32;
        int requiredWidth = mapWidthPx + (int)Math.ceil(0.8f * (float)tileSize);
        int requiredHeight = mapHeightPx + (int)Math.ceil(0.8f * (float)tileSize);
        int tilesWide = Math.max(3, (requiredWidth + tileSize - 1) / tileSize);
        int tilesHigh = Math.max(3, (requiredHeight + tileSize - 1) / tileSize);
        NativeImage combined = this.createTiledBackground(tilesWide, tilesHigh, tileSize);
        try (NativeImage gradientMap = this.applyEdgeGradient(mapImage, renderScale);){
            int mapX = (combined.getWidth() - mapWidthPx) / 2;
            int mapY = (combined.getHeight() - mapHeightPx) / 2;
            this.blendImage(combined, gradientMap, mapX, mapY);
        }
        return combined;
    }

    private NativeImage createTiledBackground(int tilesWide, int tilesHigh, int tileSize) {
        int bakedWidth = tilesWide * tileSize;
        int bakedHeight = tilesHigh * tileSize;
        NativeImage background = new NativeImage(NativeImage.Format.RGBA, bakedWidth, bakedHeight, true);
        for (int tileY = 0; tileY < tilesHigh; ++tileY) {
            for (int tileX = 0; tileX < tilesWide; ++tileX) {
                TileInfo tileInfo = this.getTileInfo(tileX, tileY, tilesWide, tilesHigh);
                NativeImage source = this.getCachedTileImage(tileInfo.texture());
                if (source == null) continue;
                NativeImage rotated = this.rotateImage(source, tileInfo.rotation());
                this.blitScaled(background, rotated, tileX * tileSize, tileY * tileSize, tileSize, tileSize);
                if (rotated == source) continue;
                rotated.close();
            }
        }
        return background;
    }

    private void blendImage(NativeImage background, NativeImage foreground, int startX, int startY) {
        for (int px = 0; px < foreground.getWidth(); ++px) {
            for (int py = 0; py < foreground.getHeight(); ++py) {
                int targetX = startX + px;
                int targetY = startY + py;
                if (targetX < 0 || targetX >= background.getWidth() || targetY < 0 || targetY >= background.getHeight()) continue;
                int bgPixel = background.getPixelRGBA(targetX, targetY);
                int fgPixelRaw = foreground.getPixelRGBA(px, py);
                int fgAlpha = (int)((float)(fgPixelRaw >>> 24 & 0xFF) * 0.75f);
                int fgPixel = fgAlpha << 24 | fgPixelRaw & 0xFFFFFF;
                background.setPixelRGBA(targetX, targetY, this.blendOver(bgPixel, fgPixel));
            }
        }
    }

    private NativeImage applyEdgeGradient(NativeImage mapImage, float renderScale) {
        int x;
        int y;
        int width = mapImage.getWidth();
        int height = mapImage.getHeight();
        int gradientDist = Math.max(1, (int)Math.ceil(14.0f / renderScale));
        float[][] distanceMap = new float[width][height];
        float maxDist = (float)width + (float)height;
        for (y = 0; y < height; ++y) {
            for (x = 0; x < width; ++x) {
                boolean isTransparent = (mapImage.getPixelRGBA(x, y) >>> 24 & 0xFF) < 10;
                boolean isBorderPixel = x == 0 || y == 0 || x == width - 1 || y == height - 1;
                distanceMap[x][y] = isTransparent || isBorderPixel ? 0.0f : maxDist;
            }
        }
        for (y = 1; y < height; ++y) {
            for (x = 1; x < width; ++x) {
                float minNeighbor = Math.min(distanceMap[x - 1][y], distanceMap[x][y - 1]);
                distanceMap[x][y] = Math.min(distanceMap[x][y], minNeighbor + 1.0f);
            }
        }
        for (y = height - 2; y >= 0; --y) {
            for (x = width - 2; x >= 0; --x) {
                float minNeighbor = Math.min(distanceMap[x + 1][y], distanceMap[x][y + 1]);
                distanceMap[x][y] = Math.min(distanceMap[x][y], minNeighbor + 1.0f);
            }
        }
        NativeImage result = new NativeImage(mapImage.format(), width, height, false);
        result.copyFrom(mapImage);
        Random gradientRandom = new Random(this.tileSeed);
        for (int y2 = 0; y2 < height; ++y2) {
            for (int x2 = 0; x2 < width; ++x2) {
                float distance = distanceMap[x2][y2];
                if (!(distance < (float)gradientDist)) continue;
                float randomFactor = 1.0f + (gradientRandom.nextFloat() - 0.5f) * 0.3f;
                float gradient = Math.min(1.0f, distance * randomFactor / (float)gradientDist);
                gradient = gradient * gradient * (3.0f - 2.0f * gradient);
                int pixel = result.getPixelRGBA(x2, y2);
                int newAlpha = (int)((float)(pixel >>> 24 & 0xFF) * gradient);
                result.setPixelRGBA(x2, y2, newAlpha << 24 | pixel & 0xFFFFFF);
            }
        }
        return result;
    }

    private TileInfo getTileInfo(int tileX, int tileY, int tilesWide, int tilesHigh) {
        boolean isRight;
        Random tileRandom = new Random(this.tileSeed + (long)tileY * (long)tilesWide + (long)tileX);
        boolean isTop = tileY == 0;
        boolean isBottom = tileY == tilesHigh - 1;
        boolean isLeft = tileX == 0;
        boolean bl = isRight = tileX == tilesWide - 1;
        if (isTop && isLeft) {
            return new TileInfo(CORNER_TILES[0], 0);
        }
        if (isTop && isRight) {
            return new TileInfo(CORNER_TILES[1], 0);
        }
        if (isBottom && isLeft) {
            return new TileInfo(CORNER_TILES[2], 0);
        }
        if (isBottom && isRight) {
            return new TileInfo(CORNER_TILES[3], 0);
        }
        ResourceLocation edgeTexture = EDGE_TILES[tileRandom.nextInt(EDGE_TILES.length)];
        if (isTop) {
            return new TileInfo(edgeTexture, 0);
        }
        if (isRight) {
            return new TileInfo(edgeTexture, 90);
        }
        if (isBottom) {
            return new TileInfo(edgeTexture, 180);
        }
        if (isLeft) {
            return new TileInfo(edgeTexture, 270);
        }
        return new TileInfo(CENTER_TILES[tileRandom.nextInt(CENTER_TILES.length)], 0);
    }

    private NativeImage getCachedTileImage(ResourceLocation location) {
        return tileImageCache.computeIfAbsent(location, loc -> {
            block8: {
                NativeImage nativeImage;
                block9: {
                    Optional resourceOpt = Minecraft.getInstance().getResourceManager().getResource(loc);
                    if (!resourceOpt.isPresent()) break block8;
                    InputStream inputStream = ((Resource)resourceOpt.get()).open();
                    try {
                        nativeImage = NativeImage.read((InputStream)inputStream);
                        if (inputStream == null) break block9;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (inputStream != null) {
                                try {
                                    inputStream.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (IOException e) {
                            ViaRomana.LOGGER.error("Failed to load background tile texture: {}", loc, (Object)e);
                        }
                    }
                    inputStream.close();
                }
                return nativeImage;
            }
            return null;
        });
    }

    private NativeImage rotateImage(NativeImage src, int degrees) {
        if (degrees == 0) {
            return src;
        }
        int sw = src.getWidth();
        int sh = src.getHeight();
        int dw = degrees == 90 || degrees == 270 ? sh : sw;
        int dh = degrees == 90 || degrees == 270 ? sw : sh;
        NativeImage dest = new NativeImage(src.format(), dw, dh, false);
        for (int sx = 0; sx < sw; ++sx) {
            block6: for (int sy = 0; sy < sh; ++sy) {
                int dy;
                int dx;
                switch (degrees) {
                    case 90: {
                        dx = sh - 1 - sy;
                        dy = sx;
                        break;
                    }
                    case 180: {
                        dx = sw - 1 - sx;
                        dy = sh - 1 - sy;
                        break;
                    }
                    case 270: {
                        dx = sy;
                        dy = sw - 1 - sx;
                        break;
                    }
                    default: {
                        continue block6;
                    }
                }
                dest.setPixelRGBA(dx, dy, src.getPixelRGBA(sx, sy));
            }
        }
        return dest;
    }

    private void blitScaled(NativeImage target, NativeImage src, int tx, int ty, int tw, int th) {
        for (int dy = 0; dy < th; ++dy) {
            for (int dx = 0; dx < tw; ++dx) {
                int sx = (int)((float)dx * (float)src.getWidth() / (float)tw);
                int sy = (int)((float)dy * (float)src.getHeight() / (float)th);
                if (dx + tx >= target.getWidth() || dy + ty >= target.getHeight()) continue;
                target.setPixelRGBA(dx + tx, dy + ty, src.getPixelRGBA(sx, sy));
            }
        }
    }

    private int blendOver(int bg, int fg) {
        int fgA = fg >> 24 & 0xFF;
        if (fgA == 0) {
            return bg;
        }
        int bgA = bg >> 24 & 0xFF;
        int invA = 255 - fgA;
        int outR = ((fg >> 16 & 0xFF) * fgA + (bg >> 16 & 0xFF) * invA) / 255;
        int outG = ((fg >> 8 & 0xFF) * fgA + (bg >> 8 & 0xFF) * invA) / 255;
        int outB = ((fg & 0xFF) * fgA + (bg & 0xFF) * invA) / 255;
        int outA = fgA + bgA * invA / 255;
        return outA << 24 | outR << 16 | outG << 8 | outB;
    }

    @Override
    public void close() {
        if (this.bakedDynamicTexture != null) {
            this.bakedDynamicTexture.close();
            this.bakedDynamicTexture = null;
            this.bakedTextureLocation = null;
        }
    }

    public static void clearCache() {
        ViaRomana.LOGGER.info("Clearing MapRenderer tile image cache ({} entries)", (Object)tileImageCache.size());
        tileImageCache.values().forEach(NativeImage::close);
        tileImageCache.clear();
    }

    public Point worldToScreen(BlockPos worldPos, int screenWidth, int screenHeight) {
        if (this.coordinateSystem == null) {
            return null;
        }
        int availableWidth = screenWidth - 40;
        int availableHeight = screenHeight - 40;
        this.coordinateSystem.updateAndGetRenderInfo(availableWidth + 40, availableHeight + 40);
        return this.coordinateSystem.worldToScreen(worldPos);
    }

    private record TileInfo(ResourceLocation texture, int rotation) {
    }

    public static class Holder {
        private MapRenderer current;
        private MapKey lastKey;

        public MapRenderer getOrCreate(BlockPos minBounds, BlockPos maxBounds, List<DestinationResponseS2C.NodeNetworkInfo> networkNodes) {
            MapKey currentKey = new MapKey(minBounds, maxBounds);
            if (this.current == null || !currentKey.equals(this.lastKey)) {
                if (this.current != null) {
                    this.current.close();
                }
                this.current = new MapRenderer(minBounds, maxBounds, networkNodes);
                this.lastKey = currentKey;
            }
            return this.current;
        }

        public void close() {
            if (this.current != null) {
                this.current.close();
                this.current = null;
            }
        }
    }

    private record MapKey(BlockPos min, BlockPos max) {
    }
}

