/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.client.gui;

import java.awt.Point;
import net.minecraft.core.BlockPos;

public class MapCoordinateSystem {
    private final int worldStartX;
    private final int worldStartZ;
    private final int bakedTextureWidth;
    private final int bakedTextureHeight;
    private final int bakeScaleFactor;
    private final int mapOffsetX;
    private final int mapOffsetY;
    private int screenX;
    private int screenY;
    private int screenWidth;
    private int screenHeight;
    private float renderScale;

    public MapCoordinateSystem(BlockPos worldMinBounds, BlockPos worldMaxBounds, int originalTextureWidth, int originalTextureHeight, int bakedTextureWidth, int bakedTextureHeight, int bakeScaleFactor) {
        this.worldStartX = worldMinBounds.getX();
        this.worldStartZ = worldMinBounds.getZ();
        this.bakedTextureWidth = bakedTextureWidth;
        this.bakedTextureHeight = bakedTextureHeight;
        this.bakeScaleFactor = bakeScaleFactor;
        this.mapOffsetX = (bakedTextureWidth - originalTextureWidth) / 2;
        this.mapOffsetY = (bakedTextureHeight - originalTextureHeight) / 2;
    }

    public MapRenderInfo updateAndGetRenderInfo(int availableScreenWidth, int availableScreenHeight) {
        float scaleX = (float)availableScreenWidth / (float)this.bakedTextureWidth;
        float scaleY = (float)availableScreenHeight / (float)this.bakedTextureHeight;
        this.renderScale = Math.min(scaleX, scaleY);
        this.screenWidth = (int)((float)this.bakedTextureWidth * this.renderScale);
        this.screenHeight = (int)((float)this.bakedTextureHeight * this.renderScale);
        this.screenX = (availableScreenWidth - this.screenWidth) / 2;
        this.screenY = (availableScreenHeight - this.screenHeight) / 2;
        return new MapRenderInfo(this.screenX, this.screenY, this.screenWidth, this.screenHeight, this.renderScale);
    }

    public Point worldToScreen(BlockPos worldPos) {
        float scaledTextureX = (float)(worldPos.getX() - this.worldStartX) / (float)this.bakeScaleFactor;
        float scaledTextureZ = (float)(worldPos.getZ() - this.worldStartZ) / (float)this.bakeScaleFactor;
        float bakedTextureX = scaledTextureX + (float)this.mapOffsetX;
        float bakedTextureZ = scaledTextureZ + (float)this.mapOffsetY;
        int screenPosX = this.screenX + (int)(bakedTextureX * this.renderScale);
        int screenPosY = this.screenY + (int)(bakedTextureZ * this.renderScale);
        return new Point(screenPosX, screenPosY);
    }

    public BlockPos screenToWorld(int screenPosX, int screenPosY) {
        float bakedTextureX = (float)(screenPosX - this.screenX) / this.renderScale;
        float bakedTextureZ = (float)(screenPosY - this.screenY) / this.renderScale;
        float scaledTextureX = bakedTextureX - (float)this.mapOffsetX;
        float scaledTextureZ = bakedTextureZ - (float)this.mapOffsetY;
        int textureX = (int)(scaledTextureX * (float)this.bakeScaleFactor);
        int textureZ = (int)(scaledTextureZ * (float)this.bakeScaleFactor);
        int worldX = textureX + this.worldStartX;
        int worldZ = textureZ + this.worldStartZ;
        return new BlockPos(worldX, 0, worldZ);
    }

    public boolean isWithinMapBounds(int screenPosX, int screenPosY) {
        return screenPosX >= this.screenX && screenPosX < this.screenX + this.screenWidth && screenPosY >= this.screenY && screenPosY < this.screenY + this.screenHeight;
    }

    public float getRenderScale() {
        return this.renderScale;
    }

    public static class MapRenderInfo {
        public final int x;
        public final int y;
        public final int width;
        public final int height;
        public final float scale;

        public MapRenderInfo(int x, int y, int width, int height, float scale) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            this.scale = scale;
        }
    }
}

