/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Objects;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.LevelAccessor;
import net.rasanovum.viaromana.CommonConfig;
import net.rasanovum.viaromana.client.core.PathRecord;
import net.rasanovum.viaromana.client.data.ClientPathData;
import net.rasanovum.viaromana.client.gui.elements.MapActionButton;
import net.rasanovum.viaromana.client.gui.elements.MapSquareButton;
import net.rasanovum.viaromana.network.packets.RoutedActionC2S;
import net.rasanovum.viaromana.util.PathUtils;
import net.rasanovum.viaromana.variables.VariableAccess;

public class ChartingScreen
extends Screen {
    private static final int BACKGROUND_WIDTH = 256;
    private static final int BACKGROUND_HEIGHT = 256;
    private static final int USABLE_WIDTH = 230;
    private static final int USABLE_HEIGHT = 180;
    private static final int PADDING = 10;
    private static final int SMALL_BUTTON_SIZE = 64;
    private static final int LARGE_BUTTON_SIZE = 80;
    private ScreenState currentScreenState = ScreenState.IDLE;
    private int tutorialPage = 0;
    private MapSquareButton severPathButton;
    private MapSquareButton deleteBranchButton;
    private MapSquareButton chartStartButton;
    private MapSquareButton chartFinishButton;
    private MapSquareButton sealApproveButton;
    private MapSquareButton sealCancelButton;
    private MapActionButton cancelChartingButton;
    private MapActionButton exitTutorialButton;
    private MapActionButton tutorialButton;
    private MapActionButton tutorialBackButton;
    private MapActionButton tutorialNextButton;
    private int panelX;
    private int panelY;
    private int usableX;
    private int usableY;
    private int textBoundsTopY;
    private int textBoundsHeight;
    private boolean isNearNode = false;
    private boolean hasGoodInfrastructure = false;
    private float currentInfrastructureQuality = 0.0f;

    public ChartingScreen(Component title) {
        super(title);
    }

    protected void init() {
        super.init();
        this.calculateLayout();
        this.createWidgets();
        this.updateNearNodeStatus();
        this.updateInfrastructureStatus();
        this.syncScreenState();
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderBackgroundTexture(guiGraphics);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderHeader(guiGraphics);
        if (this.currentScreenState == ScreenState.TUTORIAL) {
            this.renderTutorialContent(guiGraphics);
        } else if (this.currentScreenState == ScreenState.DELETE_APPROVAL) {
            this.minecraft.gameRenderer.processBlurEffect(partialTick);
            this.minecraft.getMainRenderTarget().bindWrite(false);
            guiGraphics.fillGradient(0, 0, this.width, this.height, Integer.MIN_VALUE, Integer.MIN_VALUE);
            this.renderApprovalText(guiGraphics);
            this.withSealButtonsVisible(() -> {
                this.sealApproveButton.render(guiGraphics, mouseX, mouseY, partialTick);
                this.sealCancelButton.render(guiGraphics, mouseX, mouseY, partialTick);
            });
        }
        if (this.currentScreenState == ScreenState.TUTORIAL) {
            this.renderComponentTooltip(guiGraphics, mouseX, mouseY);
        }
    }

    private void renderBackgroundTexture(GuiGraphics guiGraphics) {
        RenderSystem.enableBlend();
        guiGraphics.blit(Textures.BACKGROUND, this.panelX, this.panelY, 0.0f, 0.0f, 256, 256, 256, 256);
        if (this.currentScreenState == ScreenState.CHARTING) {
            guiGraphics.blit(Textures.CHARTING_OVERLAY, this.panelX, this.panelY, 0.0f, 0.0f, 256, 256, 256, 256);
        }
        RenderSystem.disableBlend();
    }

    private void renderHeader(GuiGraphics guiGraphics) {
        MutableComponent statusMessage = this.currentScreenState == ScreenState.CHARTING ? Component.translatable((String)"gui.viaromana.charting_in_progress") : (this.currentScreenState == ScreenState.TUTORIAL ? Component.translatable((String)"gui.viaromana.tutorial_title") : Component.translatable((String)"gui.viaromana.charting_map"));
        int barY = this.panelY + 10 + 40;
        int barColor = -12837376;
        int textWidth = this.font.width((FormattedText)statusMessage);
        int textX = this.usableX + (230 - textWidth) / 2;
        Objects.requireNonNull(this.font);
        int textY = barY - 9 / 2 + 1;
        int barPadding = 6;
        guiGraphics.fill(this.usableX, barY, textX - barPadding, barY + 1, barColor);
        guiGraphics.fill(textX + textWidth + barPadding, barY, this.usableX + 230, barY + 1, barColor);
        guiGraphics.drawString(this.font, (Component)statusMessage, textX, textY, barColor, false);
    }

    private void renderApprovalText(GuiGraphics guiGraphics) {
        MutableComponent messageComponent = Component.translatable((String)"gui.viaromana.delete_branch_confirmation");
        int textY = this.usableY + 21;
        this.renderWrappedCenteredText(guiGraphics, (Component)messageComponent, textY, 310, 1.5f, -1);
    }

    private void renderTutorialContent(GuiGraphics guiGraphics) {
        ResourceLocation tutorialImage;
        switch (this.tutorialPage) {
            case 0: {
                ResourceLocation resourceLocation = Textures.TUTORIAL_1;
                break;
            }
            case 1: {
                ResourceLocation resourceLocation = Textures.TUTORIAL_2;
                break;
            }
            case 2: {
                ResourceLocation resourceLocation = Textures.TUTORIAL_3;
                break;
            }
            case 3: {
                ResourceLocation resourceLocation = Textures.TUTORIAL_4;
                break;
            }
            case 4: {
                ResourceLocation resourceLocation = Textures.TUTORIAL_5;
                break;
            }
            case 5: {
                ResourceLocation resourceLocation = Textures.TUTORIAL_6;
                break;
            }
            case 6: {
                ResourceLocation resourceLocation = Textures.TUTORIAL_7;
                break;
            }
            case 7: {
                ResourceLocation resourceLocation = Textures.TUTORIAL_8;
                break;
            }
            default: {
                ResourceLocation resourceLocation = tutorialImage = null;
            }
        }
        if (tutorialImage == null) {
            return;
        }
        int imageWidth = 200;
        int imageHeight = 120;
        int imageX = this.usableX + (230 - imageWidth) / 2;
        int imageY = this.usableY + 10;
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.75f);
        guiGraphics.blit(tutorialImage, imageX, imageY, 0.0f, 0.0f, imageWidth, imageHeight, imageWidth, imageHeight);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Component tutorialMessage = this.getTutorialMessage();
        imageHeight = 96;
        if (tutorialMessage != Component.empty()) {
            int textTopY = this.usableY + imageHeight + 20 + 8;
            int textHeight = 180 - imageHeight - 40 - 16;
            this.textBoundsTopY = textTopY;
            this.textBoundsHeight = textHeight;
            int textCenterY = textTopY + textHeight / 2;
            int textColor = -12837376;
            this.renderWrappedCenteredText(guiGraphics, tutorialMessage, textCenterY, 220, 1.0f, textColor);
        }
    }

    private void renderWrappedCenteredText(GuiGraphics guiGraphics, Component text, int centerY, int maxWidth, float scale, int color) {
        guiGraphics.pose().pushPose();
        guiGraphics.pose().scale(scale, scale, 1.0f);
        int scaledMaxWidth = (int)((float)maxWidth / scale);
        List lines = this.font.split((FormattedText)text, scaledMaxWidth);
        if (lines.isEmpty()) {
            guiGraphics.pose().popPose();
            return;
        }
        int lineSpacing = 1;
        int n = lines.size();
        Objects.requireNonNull(this.font);
        int totalTextHeight = n * 9 + (lines.size() - 1) * lineSpacing;
        int startY = (int)((float)centerY / scale - (float)totalTextHeight / 2.0f);
        int centerX = (int)(((float)this.usableX + 115.0f) / scale);
        for (int i = 0; i < lines.size(); ++i) {
            FormattedCharSequence line = (FormattedCharSequence)lines.get(i);
            Objects.requireNonNull(this.font);
            int lineY = startY + i * (9 + lineSpacing);
            int lineWidth = this.font.width(line);
            guiGraphics.drawString(this.font, line, centerX - lineWidth / 2, lineY, color, false);
        }
        guiGraphics.pose().popPose();
    }

    private void renderComponentTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        Style style;
        if (mouseX >= this.usableX && mouseX < this.usableX + 230 && mouseY >= this.textBoundsTopY && mouseY < this.textBoundsTopY + this.textBoundsHeight && (style = this.getStyleAt(mouseX, mouseY)) != null && style.getHoverEvent() != null) {
            guiGraphics.renderComponentHoverEffect(this.font, style, mouseX, mouseY);
        }
    }

    private Style getStyleAt(double mouseX, double mouseY) {
        FormattedCharSequence line;
        int lineWidth;
        int centerX;
        int lineStartX;
        Component tutorialMessage = this.getTutorialMessage();
        if (tutorialMessage == Component.empty()) {
            return null;
        }
        int maxWidth = 220;
        List lines = this.font.split((FormattedText)tutorialMessage, maxWidth);
        int n = lines.size();
        Objects.requireNonNull(this.font);
        int totalTextHeight = n * 9;
        int startY = this.textBoundsTopY + this.textBoundsHeight / 2 - totalTextHeight / 2;
        double d = mouseY - (double)startY;
        Objects.requireNonNull(this.font);
        int hoveredLineIndex = (int)(d / 9.0);
        if (hoveredLineIndex >= 0 && hoveredLineIndex < lines.size() && mouseX >= (double)(lineStartX = (centerX = this.usableX + 115) - (lineWidth = this.font.width(line = (FormattedCharSequence)lines.get(hoveredLineIndex))) / 2) && mouseX <= (double)(lineStartX + lineWidth)) {
            return this.font.getSplitter().componentStyleAtWidth(line, (int)(mouseX - (double)lineStartX));
        }
        return null;
    }

    private Component getTutorialMessage() {
        return switch (this.tutorialPage) {
            case 0 -> Component.translatable((String)"gui.viaromana.tutorial_page_1");
            case 1 -> {
                MutableComponent tooltipText = Component.translatable((String)"gui.viaromana.tooltip.infrastructure");
                HoverEvent hoverEvent = new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)tooltipText);
                MutableComponent infrastructureTerm = Component.translatable((String)"gui.viaromana.tutorial_infrastructure_term").setStyle(Style.EMPTY.withHoverEvent(hoverEvent).withUnderlined(Boolean.valueOf(true)));
                int requiredAmount = (int)Math.ceil((float)(CommonConfig.infrastructure_check_radius * 2 + 1) * CommonConfig.path_quality_threshold);
                yield ChartingScreen.tooltipFromPlaceholder(I18n.get((String)"gui.viaromana.tutorial_page_2", (Object[])new Object[]{requiredAmount}), (Component)infrastructureTerm);
            }
            case 2 -> Component.translatable((String)"gui.viaromana.tutorial_page_3");
            case 3 -> Component.translatable((String)"gui.viaromana.tutorial_page_4");
            case 4 -> Component.translatable((String)"gui.viaromana.tutorial_page_5");
            case 5 -> Component.translatable((String)"gui.viaromana.tutorial_page_6");
            case 6 -> Component.translatable((String)"gui.viaromana.tutorial_page_7");
            case 7 -> Component.translatable((String)"gui.viaromana.tutorial_page_8");
            default -> Component.empty();
        };
    }

    public static Component tooltipFromPlaceholder(String rawString, Component styledTerm) {
        String[] parts = rawString.split("!", 2);
        if (parts.length == 2) {
            return Component.literal((String)parts[0]).append(styledTerm).append((Component)Component.literal((String)parts[1]));
        }
        return Component.literal((String)rawString);
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void mouseMoved(double mouseX, double mouseY) {
        if (this.currentScreenState == ScreenState.DELETE_APPROVAL) {
            this.withSealButtonsVisible(() -> {
                this.sealApproveButton.mouseMoved(mouseX, mouseY);
                this.sealCancelButton.mouseMoved(mouseX, mouseY);
            });
        }
        super.mouseMoved(mouseX, mouseY);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.currentScreenState == ScreenState.DELETE_APPROVAL && button == 0) {
            boolean[] handled = new boolean[]{false};
            this.withSealButtonsVisible(() -> {
                if (this.sealApproveButton.mouseClicked(mouseX, mouseY, button) || this.sealCancelButton.mouseClicked(mouseX, mouseY, button)) {
                    handled[0] = true;
                }
            });
            if (handled[0]) {
                return true;
            }
        }
        if (button == 1) {
            Objects.requireNonNull(this.minecraft).setScreen(null);
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    private void sendRoutedAction(RoutedActionC2S.Operation operation) {
        RoutedActionC2S packet = new RoutedActionC2S(operation);
        ClientPlayNetworking.send((CustomPacketPayload)packet);
        Objects.requireNonNull(this.minecraft).setScreen(null);
    }

    private void withSealButtonsVisible(Runnable action) {
        boolean wasApproveVisible = this.sealApproveButton.visible;
        boolean wasCancelVisible = this.sealCancelButton.visible;
        this.sealApproveButton.visible = true;
        this.sealCancelButton.visible = true;
        action.run();
        this.sealApproveButton.visible = wasApproveVisible;
        this.sealCancelButton.visible = wasCancelVisible;
    }

    private void updateNearNodeStatus() {
        if (this.minecraft == null || this.minecraft.player == null) {
            return;
        }
        double utilityDistance = CommonConfig.node_utility_distance;
        this.isNearNode = ClientPathData.getInstance().getNearestNode(this.minecraft.player.blockPosition(), utilityDistance, false).isPresent();
    }

    private void updateInfrastructureStatus() {
        if (this.minecraft == null || this.minecraft.player == null || this.minecraft.level == null) {
            return;
        }
        this.currentInfrastructureQuality = PathUtils.calculateInfrastructureQuality((LevelAccessor)this.minecraft.level, (Entity)this.minecraft.player);
        float threshold = CommonConfig.path_quality_threshold;
        this.hasGoodInfrastructure = this.currentInfrastructureQuality >= threshold;
    }

    private void setState(ScreenState newState) {
        this.currentScreenState = newState;
        this.updateWidgetStates();
    }

    private void syncScreenState() {
        boolean isPlayerCharting = VariableAccess.playerVariables.isChartingPath((Entity)Objects.requireNonNull(this.minecraft).player);
        if (isPlayerCharting && this.currentScreenState == ScreenState.IDLE) {
            this.setState(ScreenState.CHARTING);
        } else if (!isPlayerCharting && this.currentScreenState == ScreenState.CHARTING) {
            this.setState(ScreenState.IDLE);
        } else {
            this.updateWidgetStates();
        }
    }

    private void updateWidgetStates() {
        boolean isIdle = this.currentScreenState == ScreenState.IDLE;
        boolean isCharting = this.currentScreenState == ScreenState.CHARTING;
        boolean isApproving = this.currentScreenState == ScreenState.DELETE_APPROVAL;
        boolean isTutorial = this.currentScreenState == ScreenState.TUTORIAL;
        this.severPathButton.visible = !isTutorial;
        this.deleteBranchButton.visible = !isTutorial;
        this.chartStartButton.visible = isIdle || isApproving;
        this.chartFinishButton.visible = isCharting;
        this.sealApproveButton.visible = false;
        this.sealCancelButton.visible = false;
        this.cancelChartingButton.visible = isCharting;
        this.exitTutorialButton.visible = isTutorial;
        this.tutorialButton.visible = isIdle;
        this.tutorialBackButton.visible = isTutorial && this.tutorialPage > 0;
        this.tutorialNextButton.visible = isTutorial && this.tutorialPage < 7;
        this.severPathButton.setFrozen(isApproving);
        this.deleteBranchButton.setFrozen(isApproving);
        this.chartStartButton.setFrozen(isApproving);
        this.severPathButton.setDisabled(!isIdle || !this.isNearNode);
        this.deleteBranchButton.setDisabled(!isIdle || !this.isNearNode);
        this.chartStartButton.setDisabled(!isIdle || !this.hasGoodInfrastructure);
        this.updateTooltips();
    }

    private void updateTooltips() {
        if (this.currentScreenState == ScreenState.CHARTING) {
            this.severPathButton.setTooltips((Component)Component.translatable((String)"gui.viaromana.sever_path_tooltip"), (Component)Component.translatable((String)"gui.viaromana.sever_path_disabled_charting"));
            this.deleteBranchButton.setTooltips((Component)Component.translatable((String)"gui.viaromana.delete_branch_tooltip"), (Component)Component.translatable((String)"gui.viaromana.delete_branch_disabled_charting"));
        } else if (!this.isNearNode) {
            double utilityDistance = CommonConfig.node_utility_distance;
            MutableComponent tooltip = Component.translatable((String)"gui.viaromana.node_distance_tooltip", (Object[])new Object[]{utilityDistance});
            this.severPathButton.setTooltips((Component)Component.translatable((String)"gui.viaromana.sever_path_tooltip"), (Component)tooltip);
            this.deleteBranchButton.setTooltips((Component)Component.translatable((String)"gui.viaromana.delete_branch_tooltip"), (Component)tooltip);
        } else {
            this.severPathButton.setTooltip((Component)Component.translatable((String)"gui.viaromana.sever_path_tooltip"));
            this.deleteBranchButton.setTooltip((Component)Component.translatable((String)"gui.viaromana.delete_branch_tooltip"));
        }
        if (!this.hasGoodInfrastructure) {
            float threshold = CommonConfig.path_quality_threshold;
            int requiredBlocks = (int)Math.ceil((double)threshold * 9.0);
            int currentBlocks = Math.round(this.currentInfrastructureQuality * 9.0f);
            this.chartStartButton.setTooltips(this.getChartStartTooltip(), (Component)Component.translatable((String)"gui.viaromana.infrastructure_insufficient", (Object[])new Object[]{currentBlocks, requiredBlocks}));
        } else {
            this.chartStartButton.setTooltip(this.getChartStartTooltip());
        }
        if (this.currentScreenState == ScreenState.DELETE_APPROVAL) {
            this.sealApproveButton.setTooltip((Component)Component.translatable((String)"gui.viaromana.approve_deleting"));
            this.sealCancelButton.setTooltip((Component)Component.translatable((String)"gui.viaromana.cancel_deleting"));
        }
    }

    private Component getChartStartTooltip() {
        return Component.translatable((String)(!this.isNearNode ? "gui.viaromana.chart_start_tooltip" : "gui.viaromana.chart_continue_tooltip"));
    }

    private void calculateLayout() {
        this.panelX = (this.width - 256) / 2;
        this.panelY = (this.height - 256) / 2;
        this.usableX = this.panelX + 13;
        this.usableY = this.panelY + 38 + 7;
    }

    private void createWidgets() {
        this.severPathButton = this.createSeverPathButton();
        this.addRenderableWidget((GuiEventListener)this.severPathButton);
        this.deleteBranchButton = this.createDeleteBranchButton();
        this.addRenderableWidget((GuiEventListener)this.deleteBranchButton);
        this.chartStartButton = this.createChartStartButton();
        this.addRenderableWidget((GuiEventListener)this.chartStartButton);
        this.chartFinishButton = this.createChartFinishButton();
        this.addRenderableWidget((GuiEventListener)this.chartFinishButton);
        this.sealApproveButton = this.createSealApproveButton();
        this.addRenderableWidget((GuiEventListener)this.sealApproveButton);
        this.sealCancelButton = this.createSealCancelButton();
        this.addRenderableWidget((GuiEventListener)this.sealCancelButton);
        this.cancelChartingButton = this.createCancelChartingButton();
        this.addRenderableWidget((GuiEventListener)this.cancelChartingButton);
        this.exitTutorialButton = this.createExitTutorialButton();
        this.addRenderableWidget((GuiEventListener)this.exitTutorialButton);
        this.tutorialButton = this.createTutorialButton();
        this.addRenderableWidget((GuiEventListener)this.tutorialButton);
        this.tutorialBackButton = this.createTutorialBackButton();
        this.addRenderableWidget((GuiEventListener)this.tutorialBackButton);
        this.tutorialNextButton = this.createTutorialNextButton();
        this.addRenderableWidget((GuiEventListener)this.tutorialNextButton);
    }

    private MapSquareButton createSeverPathButton() {
        return new MapSquareButton.Builder(this.usableX + 10, this.usableY + 10, 64, 64, (Component)Component.translatable((String)"gui.viaromana.sever_path_button"), button -> this.sendRoutedAction(RoutedActionC2S.Operation.SEVER_NEAREST_NODE)).tooltip((Component)Component.translatable((String)"gui.viaromana.sever_path_tooltip")).image(Textures.SEVER_PATH_FRAME, 64, 64).animation(Textures.SEVER_PATH_TILE, 7).soundEffect(Sounds.SEVER_PATH).initialHover(0, 6, false).hoverLoop(6, 6, false).mouseOff(6, 0, true).fixedTooltipPosition(true).build();
    }

    private MapSquareButton createDeleteBranchButton() {
        return new MapSquareButton.Builder(this.usableX + 230 - 64 - 10, this.usableY + 10, 64, 64, (Component)Component.translatable((String)"gui.viaromana.remove_branch_button"), button -> this.setState(ScreenState.DELETE_APPROVAL)).tooltip((Component)Component.translatable((String)"gui.viaromana.delete_branch_detailed_tooltip")).image(Textures.DELETE_BRANCH_FRAME, 64, 64).animation(Textures.DELETE_BRANCH_TILE, 12).soundEffect(Sounds.DELETE_BRANCH_PROMPT).initialHover(0, 11, false).hoverLoop(11, 11, false).mouseOff(9, 0, true).fixedTooltipPosition(true).build();
    }

    private MapSquareButton createChartStartButton() {
        return new MapSquareButton.Builder(this.usableX + 75, this.usableY + 180 - 80 - 10, 80, 80, (Component)Component.translatable((String)"gui.viaromana.message.via_romana.start_charting_button"), button -> {
            PathRecord.start(this.minecraft.level, this.minecraft.player, this.minecraft.player.blockPosition());
            this.minecraft.setScreen(null);
        }).tooltip(this.getChartStartTooltip()).image(Textures.CHART_START_FRAME, 80, 80).animation(Textures.CHART_START_TILE, 18).soundEffect(Sounds.START_CHARTING).initialHover(0, 5, false).hoverLoop(6, 17, false).mouseOff(5, 0, true).fixedTooltipPosition(true).build();
    }

    private MapSquareButton createChartFinishButton() {
        return new MapSquareButton.Builder(this.usableX + 75, this.usableY + 180 - 80 - 10, 80, 80, (Component)Component.translatable((String)"gui.viaromana.message.via_romana.finish_charting_button"), button -> {
            PathRecord.end(this.minecraft.level, this.minecraft.player, this.minecraft.player.blockPosition());
            this.minecraft.setScreen(null);
        }).tooltip((Component)Component.translatable((String)(!this.isNearNode ? "gui.viaromana.message.via_romana.finish_charting_tooltip" : "gui.viaromana.message.via_romana.finish_charting_nearby_tooltip"))).image(Textures.CHART_FINISH_FRAME, 80, 80).animation(Textures.CHART_FINISH_TILE, 7).soundEffect(Sounds.START_CHARTING).initialHover(0, 6, false).hoverLoop(6, 6, false).mouseOff(6, 0, true).fixedTooltipPosition(true).build();
    }

    private MapActionButton createCancelChartingButton() {
        int btnWidth = 60;
        int btnHeight = 16;
        return new MapActionButton(this.usableX + 230 - btnWidth - 10 + 10, this.usableY + 180 - btnHeight - 10, btnWidth, btnHeight, (Component)Component.translatable((String)"gui.viaromana.cancel_button"), (Component)Component.translatable((String)"gui.viaromana.message.via_romana.cancel_charting_tooltip"), button -> {
            PathRecord.cancel(this.minecraft.level, this.minecraft.player, true);
            this.minecraft.setScreen(null);
        }, Textures.MAP_CANCEL);
    }

    private MapActionButton createTutorialButton() {
        int btnWidth = 62;
        int btnHeight = 16;
        return new MapActionButton(this.usableX + 230 - btnWidth - 10 + 10, this.usableY + 180 - btnHeight - 10, btnWidth, btnHeight, (Component)Component.translatable((String)"gui.viaromana.tutorial_title"), (Component)Component.translatable((String)"gui.viaromana.tutorial_tooltip"), button -> this.setState(ScreenState.TUTORIAL), Textures.MAP_TUTORIAL);
    }

    private MapActionButton createExitTutorialButton() {
        int btnWidth = 60;
        int btnHeight = 16;
        return new MapActionButton(this.usableX + 230 - btnWidth - 10 + 10, this.usableY + 180 - btnHeight - 10, btnWidth, btnHeight, (Component)Component.translatable((String)"gui.viaromana.exit_tutorial_button"), (Component)Component.translatable((String)"gui.viaromana.exit_tutorial_tooltip"), button -> {
            this.setState(ScreenState.IDLE);
            this.tutorialPage = 0;
        }, Textures.MAP_TUTORIAL_RETURN);
    }

    private MapActionButton createTutorialBackButton() {
        int btnWidth = 20;
        int btnHeight = 16;
        return new MapActionButton(this.usableX + 10 + 76, this.usableY + 180 - btnHeight - 10, btnWidth, btnHeight, button -> {
            if (this.tutorialPage > 0) {
                --this.tutorialPage;
                this.updateWidgetStates();
            }
        }, Textures.MAP_TUTORIAL_BACK);
    }

    private MapActionButton createTutorialNextButton() {
        int btnWidth = 20;
        int btnHeight = 16;
        return new MapActionButton(this.usableX + 10 + 117, this.usableY + 180 - btnHeight - 10, btnWidth, btnHeight, button -> {
            ++this.tutorialPage;
            this.updateWidgetStates();
        }, Textures.MAP_TUTORIAL_NEXT);
    }

    private MapSquareButton createSealApproveButton() {
        int sealY = this.usableY + 180 - 80 - 10 - 48;
        int centerX = this.usableX + 115;
        return new MapSquareButton.Builder(centerX - 80 - 10, sealY, 80, 80, (Component)Component.translatable((String)"gui.viaromana.confirm_button"), button -> this.sendRoutedAction(RoutedActionC2S.Operation.REMOVE_BRANCH)).image(Textures.SEAL_APPROVE, 80, 80).soundEffect(Sounds.DELETE_BRANCH_CONFIRM).fixedTooltipPosition(true).hoverBrightness(1.2f).build();
    }

    private MapSquareButton createSealCancelButton() {
        int sealY = this.usableY + 180 - 80 - 10 - 48;
        int centerX = this.usableX + 115;
        return new MapSquareButton.Builder(centerX + 10, sealY, 80, 80, (Component)Component.translatable((String)"gui.viaromana.cancel_button"), button -> this.setState(ScreenState.IDLE)).image(Textures.SEAL_CANCEL, 80, 80).soundEffect(Sounds.DELETE_BRANCH_CANCEL).fixedTooltipPosition(true).hoverBrightness(1.2f).build();
    }

    private static enum ScreenState {
        IDLE,
        CHARTING,
        DELETE_APPROVAL,
        TUTORIAL;

    }

    private static final class Textures {
        static final ResourceLocation BACKGROUND = ResourceLocation.parse((String)"via_romana:textures/screens/background_map.png");
        static final ResourceLocation CHARTING_OVERLAY = ResourceLocation.parse((String)"via_romana:textures/screens/background_map_charting.png");
        static final ResourceLocation MAP_CANCEL = ResourceLocation.parse((String)"via_romana:textures/screens/element_cancel.png");
        static final ResourceLocation MAP_TUTORIAL = ResourceLocation.parse((String)"via_romana:textures/screens/element_tutorial.png");
        static final ResourceLocation MAP_TUTORIAL_BACK = ResourceLocation.parse((String)"via_romana:textures/screens/element_tutorial_back.png");
        static final ResourceLocation MAP_TUTORIAL_NEXT = ResourceLocation.parse((String)"via_romana:textures/screens/element_tutorial_next.png");
        static final ResourceLocation MAP_TUTORIAL_RETURN = ResourceLocation.parse((String)"via_romana:textures/screens/element_return.png");
        static final ResourceLocation CHART_START_TILE = ResourceLocation.parse((String)"via_romana:textures/screens/chart_start_tile.png");
        static final ResourceLocation CHART_START_FRAME = ResourceLocation.parse((String)"via_romana:textures/screens/chart_start_frame.png");
        static final ResourceLocation CHART_FINISH_TILE = ResourceLocation.parse((String)"via_romana:textures/screens/chart_finish_tile.png");
        static final ResourceLocation CHART_FINISH_FRAME = ResourceLocation.parse((String)"via_romana:textures/screens/chart_finish_frame.png");
        static final ResourceLocation SEVER_PATH_TILE = ResourceLocation.parse((String)"via_romana:textures/screens/chart_sever_tile.png");
        static final ResourceLocation SEVER_PATH_FRAME = ResourceLocation.parse((String)"via_romana:textures/screens/chart_sever_frame.png");
        static final ResourceLocation DELETE_BRANCH_TILE = ResourceLocation.parse((String)"via_romana:textures/screens/chart_delete_branch_tile.png");
        static final ResourceLocation DELETE_BRANCH_FRAME = ResourceLocation.parse((String)"via_romana:textures/screens/chart_delete_branch_frame.png");
        static final ResourceLocation SEAL_APPROVE = ResourceLocation.parse((String)"via_romana:textures/screens/seal_approve.png");
        static final ResourceLocation SEAL_CANCEL = ResourceLocation.parse((String)"via_romana:textures/screens/seal_cancel.png");
        static final ResourceLocation TUTORIAL_1 = ResourceLocation.parse((String)"via_romana:textures/screens/tutorial_1.png");
        static final ResourceLocation TUTORIAL_2 = ResourceLocation.parse((String)"via_romana:textures/screens/tutorial_2.png");
        static final ResourceLocation TUTORIAL_3 = ResourceLocation.parse((String)"via_romana:textures/screens/tutorial_3.png");
        static final ResourceLocation TUTORIAL_4 = ResourceLocation.parse((String)"via_romana:textures/screens/tutorial_4.png");
        static final ResourceLocation TUTORIAL_5 = ResourceLocation.parse((String)"via_romana:textures/screens/tutorial_5.png");
        static final ResourceLocation TUTORIAL_6 = ResourceLocation.parse((String)"via_romana:textures/screens/tutorial_6.png");
        static final ResourceLocation TUTORIAL_7 = ResourceLocation.parse((String)"via_romana:textures/screens/tutorial_7.png");
        static final ResourceLocation TUTORIAL_8 = ResourceLocation.parse((String)"via_romana:textures/screens/tutorial_8.png");

        private Textures() {
        }
    }

    private static final class Sounds {
        static final ResourceLocation SEVER_PATH = ResourceLocation.parse((String)"minecraft:entity.sheep.shear");
        static final ResourceLocation DELETE_BRANCH_PROMPT = ResourceLocation.parse((String)"minecraft:item.flintandsteel.use");
        static final ResourceLocation DELETE_BRANCH_CONFIRM = ResourceLocation.parse((String)"minecraft:block.fire.ambient");
        static final ResourceLocation DELETE_BRANCH_CANCEL = ResourceLocation.parse((String)"minecraft:block.fire.extinguish");
        static final ResourceLocation START_CHARTING = ResourceLocation.parse((String)"minecraft:item.book.page_turn");

        private Sounds() {
        }
    }
}

