/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.client.core;

import java.util.List;
import java.util.Optional;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.rasanovum.viaromana.CommonConfig;
import net.rasanovum.viaromana.ViaRomana;
import net.rasanovum.viaromana.client.HudMessageManager;
import net.rasanovum.viaromana.client.data.ClientPathData;
import net.rasanovum.viaromana.core.LinkHandler;
import net.rasanovum.viaromana.network.ViaRomanaModVariables;
import net.rasanovum.viaromana.network.packets.ChartedPathC2S;
import net.rasanovum.viaromana.network.packets.LinkSignRequestC2S;
import net.rasanovum.viaromana.path.Node;
import net.rasanovum.viaromana.util.PathUtils;
import net.rasanovum.viaromana.variables.VariableAccess;

public final class ChartingHandler {
    public static void chartPath(LevelAccessor level, Entity entity) {
        if (!VariableAccess.playerVariables.isChartingPath(entity)) {
            return;
        }
        float nodeDistance = PathUtils.calculateNodeDistance(entity);
        float infrastructureQuality = PathUtils.calculateInfrastructureQuality(level, entity);
        float clearance = PathUtils.calculateClearance(level, entity);
        if (nodeDistance > (float)CommonConfig.node_distance_maximum) {
            HudMessageManager.queueMessage("message.via_romana.too_far_from_node_message");
            return;
        }
        if (infrastructureQuality < CommonConfig.path_quality_threshold) {
            float threshold = CommonConfig.path_quality_threshold;
            int requiredBlocks = (int)Math.ceil((double)threshold * 9.0);
            int currentBlocks = Math.round(infrastructureQuality * 9.0f);
            HudMessageManager.queueMessage((Component)Component.translatable((String)"gui.viaromana.infrastructure_insufficient", (Object[])new Object[]{currentBlocks, requiredBlocks}));
            return;
        }
        if (nodeDistance < (float)CommonConfig.node_distance_minimum) {
            HudMessageManager.queueMessage("message.via_romana.path_charting");
            return;
        }
        ChartingHandler.addChartingNode(level, entity, entity.blockPosition(), Float.valueOf(infrastructureQuality), Float.valueOf(clearance));
    }

    private static void playCartographySound(LevelAccessor level, Entity entity) {
        if (!(level instanceof Level)) {
            return;
        }
        Level lvl = (Level)level;
        BlockPos pos = BlockPos.containing((double)entity.getX(), (double)entity.getY(), (double)entity.getZ());
        SoundEvent snd = (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"minecraft:ui.cartography_table.take_result"));
        if (lvl.isClientSide()) {
            lvl.playLocalSound(entity.getX(), entity.getY(), entity.getZ(), snd, SoundSource.PLAYERS, 1.0f, 1.0f, false);
        } else {
            lvl.playSound(null, pos, snd, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    public static void addChartingNode(LevelAccessor level, Entity entity, BlockPos pos, Float quality, Float clearance) {
        Optional<Node> nearbyNode;
        if (entity == null) {
            return;
        }
        if (Math.random() > 0.9) {
            ChartingHandler.playCartographySound(level, entity);
        }
        if ((nearbyNode = ClientPathData.getInstance().getNearestNode(pos, CommonConfig.node_utility_distance, 1.0, true)).isPresent()) {
            BlockPos nearbyPos;
            pos = nearbyPos = nearbyNode.get().getBlockPos();
            clearance = Float.valueOf(nearbyNode.get().getClearance());
        }
        VariableAccess.playerVariables.setLastNodePos(entity, pos);
        ClientPathData.getInstance().addTemporaryNode(pos, quality.floatValue(), clearance.floatValue());
    }

    public static void finishPath(LocalPlayer player) {
        ClientPathData clientPathData = ClientPathData.getInstance();
        List<Node.NodeData> chartingNodes = clientPathData.getTemporaryNodes();
        List<LinkHandler.LinkData> chartingLinks = clientPathData.getTemporaryLinks();
        if (player == null || chartingNodes == null || chartingNodes.isEmpty()) {
            return;
        }
        ChartedPathC2S packet = new ChartedPathC2S(chartingNodes);
        if (ViaRomanaModVariables.networkHandler != null) {
            ViaRomanaModVariables.networkHandler.sendToServer(packet);
        } else {
            ViaRomana.LOGGER.error("Failed to send charted path - NetworkHandler not available");
        }
        if (chartingLinks != null && !chartingLinks.isEmpty()) {
            for (LinkHandler.LinkData link : chartingLinks) {
                LinkSignRequestC2S linkPacket = new LinkSignRequestC2S(link, false);
                if (ViaRomanaModVariables.networkHandler != null) {
                    ViaRomanaModVariables.networkHandler.sendToServer(linkPacket);
                    continue;
                }
                ViaRomana.LOGGER.error("Failed to send link packet - NetworkHandler not available");
            }
        }
        HudMessageManager.queueMessage("message.via_romana.finish_charting");
    }

    public static void initializeChartingNodes(LocalPlayer player) {
        if (player != null) {
            ClientPathData.getInstance().clearTemporaryNodes();
        }
    }
}

