/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.client;

import com.mojang.blaze3d.platform.NativeImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.rasanovum.viaromana.ViaRomana;
import net.rasanovum.viaromana.map.MapInfo;
import net.rasanovum.viaromana.network.ViaRomanaModVariables;
import net.rasanovum.viaromana.network.packets.DestinationResponseS2C;
import net.rasanovum.viaromana.network.packets.MapRequestC2S;
import net.rasanovum.viaromana.network.packets.MapResponseS2C;

public class MapClient {
    private static CompletableFuture<MapInfo> pendingRequest = null;

    public static CompletableFuture<MapInfo> requestMap(UUID networkId, BlockPos minBounds, BlockPos maxBounds, List<DestinationResponseS2C.NodeNetworkInfo> networkNodes) {
        CompletableFuture<MapInfo> future = new CompletableFuture<MapInfo>();
        pendingRequest = future;
        if (ViaRomanaModVariables.networkHandler != null) {
            MapRequestC2S packet = MapRequestC2S.create(networkId, minBounds, maxBounds, networkNodes);
            ViaRomanaModVariables.networkHandler.sendToServer(packet);
        } else {
            future.complete(null);
        }
        return future;
    }

    public static void handleMapResponse(MapResponseS2C packet) {
        MapClient.handleMapInfo(packet.getMapInfo());
    }

    public static void handleMapInfo(MapInfo mapInfo) {
        if (pendingRequest != null) {
            pendingRequest.complete(mapInfo);
            pendingRequest = null;
        }
    }

    public static MapTexture createTexture(MapInfo mapInfo) {
        if (mapInfo == null || !mapInfo.hasImageData()) {
            return null;
        }
        try {
            NativeImage image = NativeImage.read((InputStream)new ByteArrayInputStream(mapInfo.pngData()));
            DynamicTexture texture = new DynamicTexture(image);
            ResourceLocation location = Minecraft.getInstance().getTextureManager().register("map_network_" + String.valueOf(mapInfo.networkId()), texture);
            ViaRomana.LOGGER.debug("Created GPU texture for network {} map", (Object)mapInfo.networkId());
            return new MapTexture(mapInfo, location, texture, image);
        }
        catch (IOException e) {
            ViaRomana.LOGGER.error("MapClient: Failed to create texture for network {}: {}", (Object)mapInfo.networkId(), (Object)e.getMessage());
            return null;
        }
    }

    public static class MapTexture
    implements AutoCloseable {
        public final MapInfo mapInfo;
        public final ResourceLocation textureLocation;
        public final DynamicTexture dynamicTexture;
        public final NativeImage nativeImage;

        public MapTexture(MapInfo mapInfo, ResourceLocation textureLocation, DynamicTexture dynamicTexture, NativeImage nativeImage) {
            this.mapInfo = mapInfo;
            this.textureLocation = textureLocation;
            this.dynamicTexture = dynamicTexture;
            this.nativeImage = nativeImage;
        }

        @Override
        public void close() {
            if (this.dynamicTexture != null) {
                this.dynamicTexture.close();
            }
        }
    }
}

