/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.client;

import com.mojang.blaze3d.platform.InputConstants;
import dev.architectury.event.events.client.ClientLifecycleEvent;
import dev.architectury.networking.NetworkManager;
import dev.architectury.platform.Platform;
import dev.architectury.registry.ReloadListenerRegistry;
import dev.architectury.registry.client.keymappings.KeyMappingRegistry;
import dev.architectury.registry.client.rendering.RenderTypeRegistry;
import dev.ftb.mods.ftblibrary.FTBLibrary;
import dev.ftb.mods.ftblibrary.config.ImageResourceConfig;
import dev.ftb.mods.ftblibrary.config.ui.EditConfigScreen;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftbquests.FTBQuests;
import dev.ftb.mods.ftbquests.block.entity.TaskScreenBlockEntity;
import dev.ftb.mods.ftbquests.client.ClientQuestFile;
import dev.ftb.mods.ftbquests.client.FTBQuestsClientEventHandler;
import dev.ftb.mods.ftbquests.client.GuiProviders;
import dev.ftb.mods.ftbquests.client.QuestFileCacheReloader;
import dev.ftb.mods.ftbquests.item.CustomIconItem;
import dev.ftb.mods.ftbquests.net.SetCustomImageMessage;
import dev.ftb.mods.ftbquests.quest.BaseQuestFile;
import dev.ftb.mods.ftbquests.quest.QuestObjectBase;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.theme.ThemeLoader;
import dev.ftb.mods.ftbquests.registry.ModBlocks;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class FTBQuestsClient {
    public static KeyMapping KEY_QUESTS;

    public static void init() {
        FTBQuestsClient.maybeMigrateClientConfig();
        ClientLifecycleEvent.CLIENT_SETUP.register(FTBQuestsClient::onClientSetup);
        ReloadListenerRegistry.register((PackType)PackType.CLIENT_RESOURCES, (PreparableReloadListener)new QuestFileCacheReloader());
        ReloadListenerRegistry.register((PackType)PackType.CLIENT_RESOURCES, (PreparableReloadListener)new ThemeLoader());
        KEY_QUESTS = new KeyMapping("key.ftbquests.quests", InputConstants.Type.KEYSYM, -1, "key.categories.ftbquests");
        KeyMappingRegistry.register((KeyMapping)KEY_QUESTS);
        new FTBQuestsClientEventHandler().init();
    }

    private static void maybeMigrateClientConfig() {
        Path oldConfig = Platform.getGameFolder().resolve("local/ftbquests/client-config.snbt");
        Path newConfig = Platform.getConfigFolder().resolve("ftbquests-client.snbt");
        if (Files.exists(oldConfig, new LinkOption[0]) && !Files.exists(newConfig, new LinkOption[0])) {
            try {
                Files.move(oldConfig, newConfig, new CopyOption[0]);
                FTBQuests.LOGGER.info("migrated {} to {}", (Object)oldConfig, (Object)newConfig);
            }
            catch (IOException e) {
                FTBQuests.LOGGER.error("can't migrate {} to {}: {}", (Object)oldConfig, (Object)newConfig, (Object)e.getMessage());
            }
        }
    }

    private static void onClientSetup(Minecraft minecraft) {
        RenderTypeRegistry.register((RenderType)RenderType.translucent(), (Block[])new Block[]{(Block)ModBlocks.BARRIER.get()});
        RenderTypeRegistry.register((RenderType)RenderType.translucent(), (Block[])new Block[]{(Block)ModBlocks.STAGE_BARRIER.get()});
        RenderTypeRegistry.register((RenderType)RenderType.solid(), (Block[])new Block[]{(Block)ModBlocks.TASK_SCREEN_1.get()});
        RenderTypeRegistry.register((RenderType)RenderType.solid(), (Block[])new Block[]{(Block)ModBlocks.TASK_SCREEN_3.get()});
        RenderTypeRegistry.register((RenderType)RenderType.solid(), (Block[])new Block[]{(Block)ModBlocks.TASK_SCREEN_5.get()});
        RenderTypeRegistry.register((RenderType)RenderType.solid(), (Block[])new Block[]{(Block)ModBlocks.TASK_SCREEN_7.get()});
        RenderTypeRegistry.register((RenderType)RenderType.solid(), (Block[])new Block[]{(Block)ModBlocks.AUX_SCREEN.get()});
        GuiProviders.setTaskGuiProviders();
        GuiProviders.setRewardGuiProviders();
    }

    @Nullable
    public static BaseQuestFile getClientQuestFile() {
        return ClientQuestFile.INSTANCE;
    }

    public static Player getClientPlayer() {
        return Minecraft.getInstance().player;
    }

    public static Level getClientLevel() {
        return Minecraft.getInstance().level;
    }

    public static boolean isClientDataLoaded() {
        return ClientQuestFile.exists();
    }

    public static TeamData getClientPlayerData() {
        return ClientQuestFile.INSTANCE.selfTeamData;
    }

    public static BaseQuestFile createClientQuestFile() {
        return new ClientQuestFile();
    }

    public static HolderLookup.Provider holderLookup() {
        return FTBQuestsClient.getClientLevel().registryAccess();
    }

    public static void openGui() {
        ClientQuestFile.openGui();
    }

    public static void openCustomIconGui(Player player, InteractionHand hand) {
        ImageResourceConfig config = new ImageResourceConfig();
        config.onClicked(null, MouseButton.LEFT, accepted -> {
            if (accepted) {
                if (config.isEmpty()) {
                    CustomIconItem.setIcon(player.getItemInHand(hand), null);
                } else {
                    CustomIconItem.setIcon(player.getItemInHand(hand), (ResourceLocation)config.getValue());
                }
                NetworkManager.sendToServer((CustomPacketPayload)new SetCustomImageMessage(hand, (ResourceLocation)config.getValue()));
            }
            Minecraft.getInstance().setScreen(null);
        });
    }

    public static void openScreenConfigGui(BlockPos pos) {
        BlockEntity blockEntity = Minecraft.getInstance().level.getBlockEntity(pos);
        if (blockEntity instanceof TaskScreenBlockEntity) {
            TaskScreenBlockEntity coreScreen = (TaskScreenBlockEntity)blockEntity;
            new EditConfigScreen(coreScreen.fillConfigGroup(ClientQuestFile.INSTANCE.getOrCreateTeamData(coreScreen.getTeamId()))).setAutoclose(true).openGui();
        }
    }

    public static float[] getTextureUV(BlockState state, Direction face) {
        if (state == null) {
            return null;
        }
        BakedModel model = Minecraft.getInstance().getBlockRenderer().getBlockModel(state);
        List quads = model.getQuads(state, face, RandomSource.create());
        if (!quads.isEmpty()) {
            TextureAtlasSprite sprite = ((BakedQuad)quads.get(0)).getSprite();
            return new float[]{sprite.getU0(), sprite.getV0(), sprite.getU1(), sprite.getV1()};
        }
        return new float[0];
    }

    public static void rebuildCreativeTabs() {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            FTBQuests.LOGGER.debug("deferring creative tab rebuild, client player still null");
            FTBQuestsClientEventHandler.creativeTabRebuildPending = true;
        } else {
            FTBQuests.LOGGER.debug("rebuilding creative tabs now");
            CreativeModeTab.ItemDisplayParameters params = new CreativeModeTab.ItemDisplayParameters(player.connection.enabledFeatures(), player.canUseGameMasterBlocks(), (HolderLookup.Provider)player.level().registryAccess());
            ((CreativeModeTab)FTBLibrary.getCreativeModeTab().get()).buildContents(params);
            CreativeModeTabs.searchTab().buildContents(params);
        }
    }

    public static Optional<CreativeModeTab.ItemDisplayParameters> creativeTabDisplayParams() {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null) {
            return Optional.of(new CreativeModeTab.ItemDisplayParameters(player.connection.enabledFeatures(), ((Boolean)Minecraft.getInstance().options.operatorItemsTab().get()).booleanValue(), (HolderLookup.Provider)player.clientLevel.registryAccess()));
        }
        return Optional.empty();
    }

    public static void copyToClipboard(QuestObjectBase qo) {
        Widget.setClipboardString((String)qo.getCodeString());
    }
}

