/*
 * Decompiled with CFR 0.152.
 */
package com.memorysettings;

import com.memorysettings.EarlyWarning;
import com.memorysettings.config.CommonConfiguration;
import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.loading.FMLEnvironment;

public class Memory {
    public static int systemMemory = 0;
    public static int freeMemory = 0;
    public static int heapSetting = 0;

    public static void recordMemory() {
        systemMemory = (int)(((OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean()).getTotalMemorySize() / 0x100000L);
        freeMemory = (int)(((OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean()).getFreeMemorySize() / 0x100000L);
        heapSetting = (int)(ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getMax() / 0x100000L);
    }

    public static void doEarlyWarnings() {
        URI uri;
        String message;
        if (((CommonConfiguration)CommonConfiguration.config.getCommonConfig()).disableWarnings) {
            return;
        }
        boolean dedi = FMLEnvironment.dist == Dist.DEDICATED_SERVER;
        int configMax = !dedi ? ((CommonConfiguration)CommonConfiguration.config.getCommonConfig()).maximumClient : ((CommonConfiguration)CommonConfiguration.config.getCommonConfig()).maximumServer;
        int configMin = !dedi ? ((CommonConfiguration)CommonConfiguration.config.getCommonConfig()).minimumClient : ((CommonConfiguration)CommonConfiguration.config.getCommonConfig()).minimumServer;
        int recommendMemory = Math.min(Memory.getRecommendedMemoryForSystemMemory(systemMemory), configMax);
        if (heapSetting < configMin - 150) {
            message = String.format(((CommonConfiguration)CommonConfiguration.config.getCommonConfig()).earlyWarningMinimumMemory, heapSetting, configMin, recommendMemory);
            if (!dedi) {
                uri = null;
                try {
                    uri = new URI(((CommonConfiguration)CommonConfiguration.config.getCommonConfig()).howtolink);
                }
                catch (URISyntaxException e) {
                    CommonConfiguration.LOGGER.warn("Failed to parse url: " + ((CommonConfiguration)CommonConfiguration.config.getCommonConfig()).howtolink, (Throwable)e);
                }
                EarlyWarning.showEarlyScreenFor(message, uri);
            } else {
                CommonConfiguration.LOGGER.warn(message);
            }
        }
        if (System.getProperties().getProperty("sun.arch.data.model").equals("32") && systemMemory > 4096) {
            message = "You're using 32bit java on a 64bit system, please install 64bit java.";
            if (!dedi) {
                uri = null;
                try {
                    uri = new URI("https://adoptopenjdk.net/releases.html");
                }
                catch (URISyntaxException e) {
                    CommonConfiguration.LOGGER.warn("Failed to parse url: https://adoptopenjdk.net/releases.html", (Throwable)e);
                }
                EarlyWarning.showEarlyScreenFor(message, uri);
            } else {
                CommonConfiguration.LOGGER.warn(message + " you can find it here: https://adoptopenjdk.net/releases.html");
            }
        }
    }

    public static int getRecommendedMemoryForSystemMemory(int systemMemory) {
        Map.Entry<Integer, Integer> lastEntry = null;
        int recommendedMemory = 0;
        for (Map.Entry<Integer, Integer> dataEntry : ((CommonConfiguration)CommonConfiguration.config.getCommonConfig()).recommendedMemory.entrySet()) {
            if (systemMemory > dataEntry.getKey()) {
                lastEntry = dataEntry;
                continue;
            }
            if (lastEntry == null) {
                lastEntry = dataEntry;
                break;
            }
            double percent = (double)(systemMemory - lastEntry.getKey()) / Math.max(1.0, (double)(dataEntry.getKey() - lastEntry.getKey()));
            return (int)((double)lastEntry.getValue().intValue() + percent * (double)(dataEntry.getValue() - lastEntry.getValue()));
        }
        if (lastEntry != null) {
            return (Integer)lastEntry.getValue();
        }
        return recommendedMemory;
    }
}

