/*
 * Decompiled with CFR 0.152.
 */
package net.zoniex.network;

import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.zoniex.ZoniexMod;
import net.zoniex.procedures.ZoniexJumpOnKeyPressedProcedure;
import net.zoniex.procedures.ZoniexJumpOnKeyReleasedProcedure;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public record ZoniexJumpMessage(int eventType, int pressedms) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ZoniexJumpMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"zoniex", (String)"key_zoniex_jump"));
    public static final StreamCodec<RegistryFriendlyByteBuf, ZoniexJumpMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
        buffer.writeInt(message.eventType);
        buffer.writeInt(message.pressedms);
    }, buffer -> new ZoniexJumpMessage(buffer.readInt(), buffer.readInt()));

    public CustomPacketPayload.Type<ZoniexJumpMessage> type() {
        return TYPE;
    }

    public static void handleData(ZoniexJumpMessage message, IPayloadContext context) {
        if (context.flow() == PacketFlow.SERVERBOUND) {
            context.enqueueWork(() -> ZoniexJumpMessage.pressAction(context.player(), message.eventType, message.pressedms)).exceptionally(e -> {
                context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                return null;
            });
        }
    }

    public static void pressAction(Player entity, int type, int pressedms) {
        Level world = entity.level();
        double x = entity.getX();
        double y = entity.getY();
        double z = entity.getZ();
        if (!world.hasChunkAt(entity.blockPosition())) {
            return;
        }
        if (type == 0) {
            ZoniexJumpOnKeyPressedProcedure.execute((Entity)entity);
        }
        if (type == 1) {
            ZoniexJumpOnKeyReleasedProcedure.execute((Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        ZoniexMod.addNetworkMessage(TYPE, STREAM_CODEC, ZoniexJumpMessage::handleData);
    }
}

