/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism_integrations;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import de.teamlapen.lib.lib.util.IInitListener;
import de.teamlapen.vampirism_integrations.Config;
import de.teamlapen.vampirism_integrations.EventHandler;
import de.teamlapen.vampirism_integrations.VampirismCompat;
import de.teamlapen.vampirism_integrations.bop.BOPCompat;
import de.teamlapen.vampirism_integrations.coldsweat.ColdSweatCompat;
import de.teamlapen.vampirism_integrations.crafttweaker.CrafttweakerCompat;
import de.teamlapen.vampirism_integrations.ctov.ChoiceTheoremOverhauledVillage;
import de.teamlapen.vampirism_integrations.evilcraft.EvilCraftCompat;
import de.teamlapen.vampirism_integrations.guardvillagers.GuardVillagerCompat;
import de.teamlapen.vampirism_integrations.survive.SurviveCompat;
import de.teamlapen.vampirism_integrations.tan.TANCompat;
import de.teamlapen.vampirism_integrations.util.IModCompat;
import de.teamlapen.vampirism_integrations.util.ModCompatLoader;
import de.teamlapen.vampirism_integrations.util.REFERENCE;
import de.teamlapen.vampirism_integrations.waila.WailaModCompat;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.neoforged.fml.event.lifecycle.InterModEnqueueEvent;
import net.neoforged.fml.event.lifecycle.InterModProcessEvent;
import net.neoforged.fml.event.lifecycle.ParallelDispatchEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.registries.RegisterEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="vampirism_integrations")
public class VampirismIntegrationsMod {
    public static final Logger LOGGER = LogManager.getLogger();
    public static VampirismIntegrationsMod instance;
    public static boolean inDev;
    @Nonnull
    public final ModCompatLoader compatLoader;

    public VampirismIntegrationsMod(IEventBus modbus) {
        instance = this;
        this.checkDevEnv();
        Optional opt = ModList.get().getModContainerById("vampirism_integrations");
        if (opt.isPresent()) {
            REFERENCE.VERSION = ((ModContainer)opt.get()).getModInfo().getVersion();
        } else {
            LOGGER.warn("Cannot get version from mod info");
        }
        this.compatLoader = new ModCompatLoader();
        this.compatLoader.addModCompat(new VampirismCompat());
        this.compatLoader.addModCompat(new BOPCompat());
        this.compatLoader.addModCompat(new WailaModCompat());
        this.compatLoader.addModCompat(new EvilCraftCompat());
        this.compatLoader.addModCompat(new SurviveCompat());
        this.compatLoader.addModCompat(new CrafttweakerCompat());
        this.compatLoader.addModCompat(new TANCompat());
        this.compatLoader.addModCompat(new ChoiceTheoremOverhauledVillage());
        this.compatLoader.addModCompat(new ColdSweatCompat());
        this.compatLoader.addModCompat(new GuardVillagerCompat());
        modbus.register((Object)this);
        NeoForge.EVENT_BUS.addListener(this::onCommandRegister);
        NeoForge.EVENT_BUS.register((Object)new EventHandler());
    }

    @SubscribeEvent
    public void clientSetup(FMLClientSetupEvent event) {
        this.compatLoader.onInitStep(IInitListener.Step.CLIENT_SETUP, (ParallelDispatchEvent)event);
    }

    @SubscribeEvent
    public void loadComplete(FMLLoadCompleteEvent event) {
        this.compatLoader.onInitStep(IInitListener.Step.LOAD_COMPLETE, (ParallelDispatchEvent)event);
    }

    public void onCommandRegister(RegisterCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"vampirism-integrations").then(Commands.literal((String)"loaded").executes(context -> {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"Loaded and active mods"), false);
            for (IModCompat compat : this.compatLoader.getLoadedModCompats()) {
                ModList.get().getModContainerById(compat.getModID()).ifPresent(container -> ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("Active: " + compat.getModID() + " Version: " + container.getModInfo().getVersion().getQualifier())), false));
            }
            return 0;
        })));
    }

    @SubscribeEvent
    public void enqueueIMC(InterModEnqueueEvent event) {
        this.compatLoader.onInitStep(IInitListener.Step.ENQUEUE_IMC, (ParallelDispatchEvent)event);
    }

    @SubscribeEvent
    public void processIMC(InterModProcessEvent event) {
        this.compatLoader.onInitStep(IInitListener.Step.PROCESS_IMC, (ParallelDispatchEvent)event);
    }

    @SubscribeEvent
    public void registerItems(RegisterEvent event) {
        if (event.getRegistryKey().equals(Registries.ITEM)) {
            Config.buildConfiguration();
        }
    }

    @SubscribeEvent
    public void setup(FMLCommonSetupEvent event) {
        this.compatLoader.onInitStep(IInitListener.Step.COMMON_SETUP, (ParallelDispatchEvent)event);
    }

    private void checkDevEnv() {
        String launchTarget = System.getenv().get("target");
        if (launchTarget != null && launchTarget.contains("dev")) {
            inDev = true;
        }
    }

    static {
        inDev = false;
    }
}

