/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.tileentity;

import com.blakebr0.cucumber.inventory.BaseItemStackHandler;
import com.blakebr0.cucumber.inventory.CachedRecipe;
import com.blakebr0.cucumber.inventory.OnContentsChangedFunction;
import com.blakebr0.cucumber.tileentity.BaseInventoryTileEntity;
import com.blakebr0.cucumber.util.MultiblockPositions;
import com.blakebr0.mysticalagriculture.api.crafting.IInfusionRecipe;
import com.blakebr0.mysticalagriculture.init.ModRecipeTypes;
import com.blakebr0.mysticalagriculture.init.ModTileEntities;
import com.blakebr0.mysticalagriculture.tileentity.InfusionPedestalTileEntity;
import com.blakebr0.mysticalagriculture.util.IActivatable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class InfusionAltarTileEntity
extends BaseInventoryTileEntity
implements IActivatable {
    private final BaseItemStackHandler inventory;
    private final BaseItemStackHandler recipeInventory;
    private final MultiblockPositions pedestalLocations = new MultiblockPositions.Builder().pos(3, 0, 0).pos(0, 0, 3).pos(-3, 0, 0).pos(0, 0, -3).pos(2, 0, 2).pos(2, 0, -2).pos(-2, 0, 2).pos(-2, 0, -2).build();
    private final CachedRecipe<CraftingInput, IInfusionRecipe> recipe;
    private int progress;
    private boolean active;

    public InfusionAltarTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModTileEntities.INFUSION_ALTAR.get(), pos, state);
        this.inventory = InfusionAltarTileEntity.createInventoryHandler(slot -> this.setChanged());
        this.recipeInventory = BaseItemStackHandler.create((int)9);
        this.recipe = new CachedRecipe((RecipeType)ModRecipeTypes.INFUSION.get());
    }

    public BaseItemStackHandler getInventory() {
        return this.inventory;
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider lookup) {
        super.loadAdditional(tag, lookup);
        this.progress = tag.getInt("Progress");
        this.active = tag.getBoolean("Active");
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider lookup) {
        super.saveAdditional(tag, lookup);
        tag.putInt("Progress", this.progress);
        tag.putBoolean("Active", this.active);
    }

    @Override
    public boolean isActive() {
        if (!this.active) {
            this.active = this.level != null && this.level.hasNeighborSignal(this.getBlockPos());
        }
        return this.active;
    }

    @Override
    public void activate() {
        this.active = true;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, InfusionAltarTileEntity tile) {
        ItemStack input = tile.inventory.getStackInSlot(0);
        if (input.isEmpty()) {
            tile.reset();
            tile.dispatchIfChanged();
            return;
        }
        if (tile.isActive()) {
            IInfusionRecipe recipe = tile.getActiveRecipe();
            if (recipe != null) {
                ++tile.progress;
                List<InfusionPedestalTileEntity> pedestals = tile.getPedestals();
                if (tile.progress >= 100) {
                    CraftingInput inventory = tile.toCraftingInput();
                    NonNullList remaining = recipe.getRemainingItems((RecipeInput)inventory);
                    for (int i = 0; i < pedestals.size(); ++i) {
                        InfusionPedestalTileEntity pedestal = pedestals.get(i);
                        pedestal.getInventory().setStackInSlot(0, (ItemStack)remaining.get(i + 1));
                        tile.spawnParticles(ParticleTypes.SMOKE, pedestal.getBlockPos(), 1.2, 20);
                    }
                    ItemStack result = recipe.assemble((RecipeInput)inventory, (HolderLookup.Provider)level.registryAccess());
                    tile.setOutput(result, (ItemStack)remaining.getFirst());
                    tile.reset();
                    tile.setChangedFast();
                    tile.spawnParticles(ParticleTypes.HAPPY_VILLAGER, pos, 1.0, 10);
                } else {
                    for (InfusionPedestalTileEntity pedestal : pedestals) {
                        BlockPos pedestalPos = pedestal.getBlockPos();
                        ItemStack stack = pedestal.getInventory().getStackInSlot(0);
                        tile.spawnItemParticles(pedestalPos, stack);
                    }
                }
            } else {
                tile.reset();
            }
        } else {
            tile.progress = 0;
        }
        tile.dispatchIfChanged();
    }

    public static BaseItemStackHandler createInventoryHandler(OnContentsChangedFunction onContentsChanged) {
        return BaseItemStackHandler.create((int)2, (OnContentsChangedFunction)onContentsChanged, builder -> {
            builder.setDefaultSlotLimit(1);
            builder.setCanInsert((slot, stack) -> builder.getStackInSlot(1).isEmpty());
            builder.setOutputSlots(new int[]{1});
        });
    }

    public List<BlockPos> getPedestalPositions() {
        return this.pedestalLocations.get(this.getBlockPos());
    }

    public IInfusionRecipe getActiveRecipe() {
        if (this.level == null) {
            return null;
        }
        this.updateRecipeInventory(this.getPedestals());
        return (IInfusionRecipe)this.recipe.checkAndGet((RecipeInput)this.toCraftingInput(), this.level);
    }

    private CraftingInput toCraftingInput() {
        return this.recipeInventory.toCraftingInput(3, 3);
    }

    private void reset() {
        this.progress = 0;
        this.active = false;
    }

    private void updateRecipeInventory(List<InfusionPedestalTileEntity> pedestals) {
        this.recipeInventory.setSize(9);
        this.recipeInventory.setStackInSlot(0, this.inventory.getStackInSlot(0));
        for (int i = 0; i < pedestals.size(); ++i) {
            ItemStack stack = pedestals.get(i).getInventory().getStackInSlot(0);
            this.recipeInventory.setStackInSlot(i + 1, stack);
        }
    }

    private List<InfusionPedestalTileEntity> getPedestals() {
        if (this.level == null) {
            return Collections.emptyList();
        }
        ArrayList<InfusionPedestalTileEntity> pedestals = new ArrayList<InfusionPedestalTileEntity>();
        for (BlockPos pos : this.getPedestalPositions()) {
            BlockEntity tile = this.level.getBlockEntity(pos);
            if (!(tile instanceof InfusionPedestalTileEntity)) continue;
            InfusionPedestalTileEntity pedestal = (InfusionPedestalTileEntity)tile;
            pedestals.add(pedestal);
        }
        return pedestals;
    }

    private <T extends ParticleOptions> void spawnParticles(T particle, BlockPos pos, double yOffset, int count) {
        if (this.level == null || this.level.isClientSide()) {
            return;
        }
        ServerLevel level = (ServerLevel)this.level;
        double x = (double)pos.getX() + 0.5;
        double y = (double)pos.getY() + yOffset;
        double z = (double)pos.getZ() + 0.5;
        level.sendParticles(particle, x, y, z, count, 0.0, 0.0, 0.0, 0.1);
    }

    private void spawnItemParticles(BlockPos pedestalPos, ItemStack stack) {
        if (this.level == null || this.level.isClientSide() || stack.isEmpty()) {
            return;
        }
        ServerLevel level = (ServerLevel)this.level;
        BlockPos pos = this.getBlockPos();
        double x = (double)pedestalPos.getX() + level.getRandom().nextDouble() * 0.2 + 0.4;
        double y = (double)pedestalPos.getY() + level.getRandom().nextDouble() * 0.2 + 1.2;
        double z = (double)pedestalPos.getZ() + level.getRandom().nextDouble() * 0.2 + 0.4;
        double velX = pos.getX() - pedestalPos.getX();
        double velY = 0.25;
        double velZ = pos.getZ() - pedestalPos.getZ();
        level.sendParticles((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, stack), x, y, z, 0, velX, velY, velZ, 0.18);
    }

    private void setOutput(ItemStack stack, ItemStack remaining) {
        NonNullList stacks = this.inventory.getStacks();
        stacks.set(0, (Object)remaining);
        stacks.set(1, (Object)stack);
    }
}

