/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.crafting.ingredient;

import com.blakebr0.mysticalagriculture.api.crop.Crop;
import com.blakebr0.mysticalagriculture.init.ModIngredientTypes;
import com.blakebr0.mysticalagriculture.registry.CropRegistry;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.crafting.ICustomIngredient;
import net.neoforged.neoforge.common.crafting.IngredientType;
import org.jetbrains.annotations.Nullable;

public class CropComponentIngredient
implements ICustomIngredient {
    public static final MapCodec<CropComponentIngredient> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)ResourceLocation.CODEC.fieldOf("crop").forGetter(ingredient -> ingredient.crop), (App)ComponentType.CODEC.fieldOf("component").forGetter(ingredient -> ingredient.type)).apply((Applicative)builder, CropComponentIngredient::new));
    private final ResourceLocation crop;
    private final ComponentType type;
    private ItemStack[] stacks;

    public CropComponentIngredient(ResourceLocation crop, ComponentType type) {
        this.crop = crop;
        this.type = type;
    }

    public boolean test(@Nullable ItemStack input) {
        if (input == null) {
            return false;
        }
        return this.getItems().anyMatch(s -> ItemStack.isSameItemSameComponents((ItemStack)s, (ItemStack)input));
    }

    public Stream<ItemStack> getItems() {
        if (this.stacks == null) {
            this.initMatchingStacks();
        }
        return Stream.of(this.stacks);
    }

    public boolean isSimple() {
        return false;
    }

    public IngredientType<?> getType() {
        return (IngredientType)ModIngredientTypes.CROP_COMPONENT.get();
    }

    private void initMatchingStacks() {
        Crop crop = CropRegistry.getInstance().getCropById(this.crop);
        ItemStack stack = switch (this.type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> new ItemStack((ItemLike)crop.getTier().getEssence());
            case 1 -> new ItemStack((ItemLike)crop.getType().getCraftingSeed());
            case 2 -> {
                Ingredient material = crop.getCraftingMaterial();
                if (material.hasNoItems()) {
                    yield ItemStack.EMPTY;
                }
                yield material.getItems()[0];
            }
        };
        this.stacks = new ItemStack[]{stack};
    }

    public static Ingredient of(ResourceLocation crop, ComponentType type) {
        return new CropComponentIngredient(crop, type).toVanilla();
    }

    public static enum ComponentType implements StringRepresentable
    {
        ESSENCE("essence"),
        SEED("seed"),
        MATERIAL("material");

        public static final Codec<ComponentType> CODEC;
        public final String name;

        private ComponentType(String name) {
            this.name = name;
        }

        public String getSerializedName() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.fromEnum(ComponentType::values);
        }
    }
}

