/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.client.screen;

import com.blakebr0.cucumber.client.screen.BaseContainerScreen;
import com.blakebr0.cucumber.client.screen.widget.EnergyBarWidget;
import com.blakebr0.cucumber.energy.DynamicEnergyStorage;
import com.blakebr0.cucumber.util.Formatting;
import com.blakebr0.mysticalagriculture.MysticalAgriculture;
import com.blakebr0.mysticalagriculture.container.HarvesterContainer;
import com.blakebr0.mysticalagriculture.tileentity.HarvesterTileEntity;
import com.blakebr0.mysticalagriculture.util.MachineUpgradeTier;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class HarvesterScreen
extends BaseContainerScreen<HarvesterContainer> {
    private static final ResourceLocation BACKGROUND = MysticalAgriculture.resource("textures/gui/harvester.png");
    private HarvesterTileEntity tile;

    public HarvesterScreen(HarvesterContainer container, Inventory inv, Component title) {
        super((AbstractContainerMenu)container, inv, title, BACKGROUND, 176, 194);
    }

    protected void init() {
        super.init();
        int x = this.getGuiLeft();
        int y = this.getGuiTop();
        this.tile = this.getTileEntity();
        if (this.tile != null) {
            this.addRenderableWidget((GuiEventListener)new EnergyBarWidget(x + 7, y + 17, (IEnergyStorage)this.tile.getEnergy()));
        }
    }

    protected void renderLabels(GuiGraphics gfx, int mouseX, int mouseY) {
        String title = this.getTitle().getString();
        gfx.drawString(this.font, title, this.imageWidth / 2 - this.font.width(title) / 2, 6, 0x404040, false);
        gfx.drawString(this.font, this.playerInventoryTitle, 8, this.imageHeight - 96 + 2, 0x404040, false);
        if (this.tile != null) {
            MachineUpgradeTier tier = this.tile.getMachineTier();
            DynamicEnergyStorage energy = this.tile.getEnergy();
            energy.resetMaxEnergyStorage();
            if (tier != null) {
                energy.setMaxEnergyStorage((double)this.tile.getEnergy().getMaxEnergyStored() * tier.getFuelCapacityMultiplier());
            }
        }
    }

    protected void renderBg(GuiGraphics gfx, float partialTicks, int mouseX, int mouseY) {
        super.renderBg(gfx, partialTicks, mouseX, mouseY);
        int x = this.getGuiLeft();
        int y = this.getGuiTop();
        if (this.getFuelItemValue() > 0) {
            int i = this.getBurnLeftScaled(13);
            gfx.blit(BACKGROUND, x + 31, y + 52 - i, 176, 12 - i, 14, i + 1);
        }
    }

    protected void renderTooltip(GuiGraphics gfx, int mouseX, int mouseY) {
        int x = this.getGuiLeft();
        int y = this.getGuiTop();
        super.renderTooltip(gfx, mouseX, mouseY);
        if (mouseX > x + 30 && mouseX < x + 45 && mouseY > y + 39 && mouseY < y + 53) {
            gfx.renderTooltip(this.font, (Component)Formatting.energy((Object)this.getFuelLeft()), mouseX, mouseY);
        }
    }

    private HarvesterTileEntity getTileEntity() {
        BlockEntity tile;
        ClientLevel level = this.getMinecraft().level;
        if (level != null && (tile = level.getBlockEntity(((HarvesterContainer)this.getMenu()).getBlockPos())) instanceof HarvesterTileEntity) {
            HarvesterTileEntity extractor = (HarvesterTileEntity)tile;
            return extractor;
        }
        return null;
    }

    public int getFuelLeft() {
        if (this.tile == null) {
            return 0;
        }
        return this.tile.getFuelLeft();
    }

    public int getFuelItemValue() {
        if (this.tile == null) {
            return 0;
        }
        return this.tile.getFuelItemValue();
    }

    public int getBurnLeftScaled(int pixels) {
        int i = this.getFuelLeft();
        int j = this.getFuelItemValue();
        return (int)(j != 0 && i != 0 ? (long)i * (long)pixels / (long)j : 0L);
    }
}

