/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.augment;

import com.blakebr0.cucumber.helper.ColorHelper;
import com.blakebr0.mysticalagriculture.api.tinkering.Augment;
import com.blakebr0.mysticalagriculture.api.tinkering.AugmentType;
import java.util.EnumSet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class AbsorptionAugment
extends Augment {
    private static final String PERSISTENT_DATA_KEY = "MA_AbsorptionAugment";
    private final int amplifier;

    public AbsorptionAugment(ResourceLocation id, int tier, int amplifier) {
        super(id, tier, EnumSet.of(AugmentType.ARMOR), AbsorptionAugment.getColor(8295845, tier), AbsorptionAugment.getColor(3844804, tier));
        this.amplifier = amplifier;
    }

    @Override
    public void onArmorTick(ItemStack stack, Level level, Player player) {
        if (level.isClientSide() || player.hasEffect(MobEffects.ABSORPTION)) {
            return;
        }
        if (AbsorptionAugment.getLastApplicationTime(player) + 9600L < level.getGameTime()) {
            player.addEffect(new MobEffectInstance(MobEffects.ABSORPTION, 9600, this.amplifier, true, false));
            AbsorptionAugment.setLastApplicationTime(player, level.getGameTime());
        }
    }

    private static int getColor(int color, int tier) {
        return ColorHelper.saturate((int)color, (float)Math.min((float)tier / 5.0f, 1.0f));
    }

    private static long getLastApplicationTime(Player player) {
        return player.getPersistentData().getLong(PERSISTENT_DATA_KEY);
    }

    private static void setLastApplicationTime(Player player, long time) {
        player.getPersistentData().putLong(PERSISTENT_DATA_KEY, time);
    }
}

