/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.lib.turtle;

import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.TurtleSide;
import de.srendi.advancedperipherals.common.setup.DataComponents;
import de.srendi.advancedperipherals.common.util.DataStorageUtil;
import de.srendi.advancedperipherals.lib.peripherals.IBasePeripheral;
import de.srendi.advancedperipherals.lib.turtle.PeripheralTurtleUpgrade;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public abstract class ClockwiseAnimatedTurtleUpgrade<T extends IBasePeripheral<?>>
extends PeripheralTurtleUpgrade<T> {
    protected ClockwiseAnimatedTurtleUpgrade(ResourceLocation id, ItemStack item) {
        super(id, item);
    }

    public void chargeConsumingCallback() {
    }

    public ItemStack getUpgradeItem(DataComponentPatch upgradeData) {
        if (upgradeData.isEmpty()) {
            return this.getCraftingItem();
        }
        ItemStack baseItem = this.getCraftingItem().copy();
        baseItem.applyComponents(upgradeData);
        return baseItem;
    }

    public DataComponentPatch getUpgradeData(ItemStack stack) {
        DataComponentPatch storedData = (DataComponentPatch)stack.get(DataComponents.TURTLE_UPGRADE_STORED_DATA);
        if (storedData == null) {
            return DataComponentPatch.EMPTY;
        }
        return storedData;
    }

    @Override
    public boolean isItemSuitable(@NotNull ItemStack stack) {
        if (!stack.has(DataComponents.TURTLE_UPGRADE_STORED_DATA)) {
            return super.isItemSuitable(stack);
        }
        ItemStack tweakedStack = stack.copy();
        tweakedStack.remove(DataComponents.TURTLE_UPGRADE_STORED_DATA);
        return super.isItemSuitable(tweakedStack);
    }

    public void update(@NotNull ITurtleAccess turtle, @NotNull TurtleSide side) {
        super.update(turtle, side);
        if (this.tick % 2 == 0 && DataStorageUtil.RotationCharge.consume(turtle, side)) {
            this.chargeConsumingCallback();
        }
    }
}

