/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.util.inventory;

import dan200.computercraft.shared.ModRegistry;
import de.srendi.advancedperipherals.AdvancedPeripherals;
import de.srendi.advancedperipherals.common.util.StringUtil;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import org.apache.logging.log4j.Level;

public class ItemUtil {
    public static final Item TURTLE_NORMAL = (Item)ModRegistry.Items.TURTLE_NORMAL.get();
    public static final Item TURTLE_ADVANCED = (Item)ModRegistry.Items.TURTLE_ADVANCED.get();
    public static final Item POCKET_NORMAL = (Item)ModRegistry.Items.POCKET_COMPUTER_NORMAL.get();
    public static final Item POCKET_ADVANCED = (Item)ModRegistry.Items.POCKET_COMPUTER_ADVANCED.get();

    private ItemUtil() {
    }

    public static <T> T getRegistryEntry(String name, Registry<T> forgeRegistry) {
        Object value;
        ResourceLocation location;
        try {
            location = ResourceLocation.parse((String)name);
        }
        catch (ResourceLocationException ex) {
            location = null;
        }
        if (location != null && forgeRegistry.containsKey(location) && (value = forgeRegistry.get(location)) != null) {
            return (T)value;
        }
        return null;
    }

    public static String getFingerprint(ItemStack stack) {
        String fingerprint = String.valueOf(stack.getComponents()) + ItemUtil.getRegistryKey(stack).toString() + stack.getDisplayName().getString();
        try {
            byte[] bytesOfHash = fingerprint.getBytes(StandardCharsets.UTF_8);
            MessageDigest md = MessageDigest.getInstance("MD5");
            return StringUtil.toHexString(md.digest(bytesOfHash));
        }
        catch (NoSuchAlgorithmException ex) {
            AdvancedPeripherals.debug("Could not parse fingerprint.", Level.ERROR);
            ex.printStackTrace();
            return "";
        }
    }

    public static List<ItemStack> getItemsFromItemHandler(IItemHandler handler) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>(handler.getSlots());
        for (int slot = 0; slot < handler.getSlots(); ++slot) {
            items.add(handler.getStackInSlot(slot).copy());
        }
        return items;
    }

    public static ResourceLocation getRegistryKey(Item item) {
        return BuiltInRegistries.ITEM.getKey((Object)item);
    }

    public static ResourceLocation getRegistryKey(ItemStack item) {
        return BuiltInRegistries.ITEM.getKey((Object)item.copy().getItem());
    }
}

