/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.util;

import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.shared.util.NBTUtil;
import de.srendi.advancedperipherals.common.util.DataComponentUtil;
import de.srendi.advancedperipherals.common.util.inventory.FluidUtil;
import de.srendi.advancedperipherals.common.util.inventory.ItemUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.nbt.Tag;
import net.minecraft.tags.TagKey;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.common.IShearable;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidType;
import org.jetbrains.annotations.NotNull;

public class LuaConverter {
    public static Map<String, Object> entityToLua(Entity entity) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("id", entity.getId());
        data.put("uuid", entity.getStringUUID());
        data.put("name", entity.getName().getString());
        data.put("tags", entity.getTags());
        data.put("canFreeze", entity.canFreeze());
        data.put("isGlowing", entity.isCurrentlyGlowing());
        data.put("isInWall", entity.isInWall());
        return data;
    }

    public static Map<String, Object> livingEntityToLua(LivingEntity entity) {
        Map<String, Object> data = LuaConverter.entityToLua((Entity)entity);
        data.put("health", Float.valueOf(entity.getHealth()));
        data.put("maxHealth", Float.valueOf(entity.getMaxHealth()));
        data.put("lastDamageSource", entity.getLastDamageSource() == null ? null : entity.getLastDamageSource().toString());
        return data;
    }

    public static Map<String, Object> animalToLua(Animal animal, ItemStack itemInHand) {
        Map<String, Object> data = LuaConverter.livingEntityToLua((LivingEntity)animal);
        data.put("baby", animal.isBaby());
        data.put("inLove", animal.isInLove());
        data.put("aggressive", animal.isAggressive());
        if (animal instanceof IShearable) {
            IShearable shareable = (IShearable)animal;
            if (!itemInHand.isEmpty()) {
                data.put("shareable", shareable.isShearable(null, itemInHand, animal.level(), animal.blockPosition()));
            }
        }
        return data;
    }

    public static Map<String, Object> completeEntityToLua(Entity entity, ItemStack itemInHand) {
        if (entity instanceof Animal) {
            Animal animal = (Animal)entity;
            return LuaConverter.animalToLua(animal, itemInHand);
        }
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            return LuaConverter.livingEntityToLua(livingEntity);
        }
        return LuaConverter.entityToLua(entity);
    }

    public static Map<String, Object> completeEntityWithPositionToLua(Entity entity, ItemStack itemInHand, BlockPos pos) {
        Map<String, Object> data = LuaConverter.completeEntityToLua(entity, itemInHand);
        data.put("x", entity.getX() - (double)pos.getX());
        data.put("y", entity.getY() - (double)pos.getY());
        data.put("z", entity.getZ() - (double)pos.getZ());
        return data;
    }

    public static Object stateToObject(Comparable<?> blockStateValue) {
        if (blockStateValue == null) {
            return null;
        }
        if (blockStateValue instanceof Boolean || blockStateValue instanceof Number || blockStateValue instanceof String) {
            return blockStateValue;
        }
        if (blockStateValue instanceof StringRepresentable) {
            StringRepresentable stringRepresentable = (StringRepresentable)blockStateValue;
            return stringRepresentable.getSerializedName();
        }
        return null;
    }

    public static Object posToObject(BlockPos pos) {
        if (pos == null) {
            return null;
        }
        HashMap<String, Integer> map = new HashMap<String, Integer>(3);
        map.put("x", pos.getX());
        map.put("y", pos.getY());
        map.put("z", pos.getZ());
        return map;
    }

    public static Map<String, Object> itemStackToObject(@NotNull ItemStack stack) {
        if (stack.isEmpty()) {
            return Collections.emptyMap();
        }
        Map<String, Object> map = LuaConverter.itemToObject(stack.getItem());
        DataComponentPatch components = stack.getComponentsPatch();
        map.put("count", stack.getCount());
        map.put("displayName", stack.getDisplayName().getString());
        map.put("maxStackSize", stack.getMaxStackSize());
        map.put("components", NBTUtil.toLua((Tag)DataComponentUtil.toNbt(components)));
        map.put("fingerprint", ItemUtil.getFingerprint(stack));
        return map;
    }

    public static Map<String, Object> fluidStackToObject(@NotNull FluidStack stack) {
        if (stack.isEmpty()) {
            return Collections.emptyMap();
        }
        Map<String, Object> map = LuaConverter.fluidToObject(stack.getFluid());
        DataComponentPatch components = stack.getComponentsPatch();
        map.put("count", stack.getAmount());
        map.put("displayName", stack.getHoverName().getString());
        map.put("fluidType", LuaConverter.fluidTypeToObject(stack.getFluidType()));
        map.put("components", NBTUtil.toLua((Tag)DataComponentUtil.toNbt(components)));
        map.put("fingerprint", FluidUtil.getFingerprint(stack));
        return map;
    }

    public static Map<String, Object> fluidTypeToObject(FluidType type) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("viscosity", type.getViscosity());
        map.put("density", type.getDensity());
        map.put("canHydrate", type.canHydrate((Entity)null));
        map.put("canExtinguish", type.canExtinguish(null));
        map.put("canDrownIn", type.canDrownIn(null));
        map.put("canSwim", type.canSwim(null));
        map.put("canPushEntity", type.canPushEntity(null));
        map.put("supportsBoating", type.supportsBoating(null));
        map.put("canConvertToSource", type.canConvertToSource(null));
        map.put("temperature", type.getTemperature(null));
        return map;
    }

    public static Map<String, Object> itemStackToObject(@NotNull ItemStack itemStack, int amount) {
        ItemStack stack = itemStack.copy();
        stack.setCount(amount);
        return LuaConverter.itemStackToObject(stack);
    }

    public static Map<String, Object> stackToObjectWithSlot(@NotNull ItemStack stack, int slot) {
        if (stack.isEmpty()) {
            return new HashMap<String, Object>();
        }
        Map<String, Object> map = LuaConverter.itemStackToObject(stack);
        map.put("slot", slot);
        return map;
    }

    public static Map<String, Object> itemToObject(@NotNull Item item) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tags", LuaConverter.tagsToList(() -> item.builtInRegistryHolder().tags()));
        map.put("name", ItemUtil.getRegistryKey(item).toString());
        return map;
    }

    public static Map<String, Object> fluidToObject(@NotNull Fluid fluid) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tags", LuaConverter.tagsToList(() -> fluid.builtInRegistryHolder().tags()));
        map.put("name", FluidUtil.getRegistryKey(fluid).toString());
        return map;
    }

    public static <T> List<String> tagsToList(@NotNull Supplier<Stream<TagKey<T>>> tags) {
        if (tags.get().findAny().isEmpty()) {
            return Collections.emptyList();
        }
        return tags.get().map(LuaConverter::tagToString).toList();
    }

    public static <T> String tagToString(@NotNull TagKey<T> tag) {
        return String.valueOf(tag.registry().location()) + "/" + String.valueOf(tag.location());
    }

    public static BlockPos convertToBlockPos(Map<?, ?> table) throws LuaException {
        Number y;
        Number x;
        Object obj;
        block5: {
            block4: {
                if (!(table.containsKey("x") && table.containsKey("y") && table.containsKey("z"))) {
                    throw new LuaException("Table should be block position table");
                }
                obj = table.get("x");
                if (!(obj instanceof Number)) break block4;
                x = (Number)obj;
                obj = table.get("y");
                if (!(obj instanceof Number)) break block4;
                y = (Number)obj;
                obj = table.get("z");
                if (obj instanceof Number) break block5;
            }
            throw new LuaException("Table should be block position table");
        }
        Number z = (Number)obj;
        return new BlockPos(x.intValue(), y.intValue(), z.intValue());
    }

    public static BlockPos convertToBlockPos(BlockPos center, Map<?, ?> table) throws LuaException {
        BlockPos relative = LuaConverter.convertToBlockPos(table);
        return new BlockPos(center.getX() + relative.getX(), center.getY() + relative.getY(), center.getZ() + relative.getZ());
    }
}

