/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.events;

import com.google.common.collect.EvictingQueue;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.CommandContextBuilder;
import com.mojang.brigadier.context.ParsedCommandNode;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.srendi.advancedperipherals.common.configuration.APConfig;
import de.srendi.advancedperipherals.common.util.Pair;
import java.util.function.Consumer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.MessageArgument;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.CommandEvent;
import net.neoforged.neoforge.event.ServerChatEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;

@EventBusSubscriber(modid="advancedperipherals", bus=EventBusSubscriber.Bus.GAME)
public class Events {
    private static final String PLAYED_BEFORE = "ap_played_before";
    private static final int CHAT_QUEUE_MAX_SIZE = 50;
    private static final int PLAYER_QUEUE_MAX_SIZE = 50;
    public static final EvictingQueue<Pair<Long, ChatMessageObject>> messageQueue = EvictingQueue.create((int)50);
    public static final EvictingQueue<Pair<Long, PlayerMessageObject>> playerMessageQueue = EvictingQueue.create((int)50);
    private static long lastChatMessageID = 0L;
    private static long lastPlayerMessageID = 0L;

    @SubscribeEvent
    public static void onWorldJoin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        Events.putPlayerMessage(Pair.of(Events.getLastPlayerMessageID(), new PlayerMessageObject("playerJoin", player.getName().getString(), player.level().dimension().location().toString(), "")));
    }

    @SubscribeEvent
    public static void onWorldLeave(PlayerEvent.PlayerLoggedOutEvent event) {
        Player player = event.getEntity();
        Events.putPlayerMessage(Pair.of(Events.getLastPlayerMessageID(), new PlayerMessageObject("playerLeave", player.getName().getString(), player.level().dimension().location().toString(), "")));
    }

    @SubscribeEvent
    public static void onPlayerChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player = event.getEntity();
        String fromDim = event.getFrom().location().toString();
        String toDim = event.getTo().location().toString();
        Events.putPlayerMessage(Pair.of(Events.getLastPlayerMessageID(), new PlayerMessageObject("playerChangedDimension", player.getName().getString(), fromDim, toDim)));
    }

    @SubscribeEvent
    public static void onCommand(CommandEvent event) throws CommandSyntaxException {
        if (!Events.getCommandName(event.getParseResults().getContext()).equals("say")) {
            return;
        }
        String username = "sayCommand";
        String uuid = null;
        String message = MessageArgument.getMessage((CommandContext)event.getParseResults().getContext().build("apChatEvent"), (String)"message").getString();
        boolean isHidden = false;
        CommandSourceStack source = (CommandSourceStack)event.getParseResults().getContext().getSource();
        if (source.getEntity() != null) {
            username = source.getEntity().getDisplayName().getString();
            uuid = source.getEntity().getUUID().toString();
        }
        if (message.startsWith("$")) {
            event.setCanceled(true);
            message = message.replace("$", "");
            isHidden = true;
        }
        Events.putChatMessage(Pair.of(Events.getLastChatMessageID(), new ChatMessageObject(username, message, uuid, isHidden)));
    }

    private static String getCommandName(CommandContextBuilder<?> context) {
        if (context != null && context.getNodes() != null && !context.getNodes().isEmpty()) {
            return ((ParsedCommandNode)context.getNodes().get(0)).getNode().getName();
        }
        return "";
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onChatBox(ServerChatEvent event) {
        if (((Boolean)APConfig.PERIPHERALS_CONFIG.enableChatBox.get()).booleanValue()) {
            String message = event.getMessage().getString();
            boolean isHidden = false;
            if (message.startsWith("$")) {
                event.setCanceled(true);
                message = message.replace("$", "");
                isHidden = true;
            }
            Events.putChatMessage(Pair.of(Events.getLastChatMessageID(), new ChatMessageObject(event.getUsername(), message, event.getPlayer().getUUID().toString(), isHidden)));
        }
    }

    public static synchronized void putChatMessage(Pair<Long, ChatMessageObject> message) {
        messageQueue.add(message);
        ++lastChatMessageID;
    }

    public static synchronized void putPlayerMessage(Pair<Long, PlayerMessageObject> message) {
        playerMessageQueue.add(message);
        ++lastPlayerMessageID;
    }

    public static synchronized long traverseChatMessages(long lastConsumedMessage, Consumer<ChatMessageObject> consumer) {
        for (Pair message : messageQueue) {
            if ((Long)message.getLeft() <= lastConsumedMessage) continue;
            consumer.accept((ChatMessageObject)message.getRight());
            lastConsumedMessage = (Long)message.getLeft();
        }
        return lastConsumedMessage;
    }

    public static synchronized long traversePlayerMessages(long lastConsumedMessage, Consumer<PlayerMessageObject> consumer) {
        for (Pair message : playerMessageQueue) {
            if ((Long)message.getLeft() <= lastConsumedMessage) continue;
            consumer.accept((PlayerMessageObject)message.getRight());
            lastConsumedMessage = (Long)message.getLeft();
        }
        return lastConsumedMessage;
    }

    public static synchronized long getLastChatMessageID() {
        return lastChatMessageID;
    }

    public static synchronized long getLastPlayerMessageID() {
        return lastPlayerMessageID;
    }

    private static boolean hasPlayedBefore(Player player) {
        CompoundTag tag = player.getPersistentData().getCompound("PlayerPersisted");
        if (tag.getBoolean(PLAYED_BEFORE)) {
            return true;
        }
        tag.putBoolean(PLAYED_BEFORE, true);
        player.getPersistentData().put("PlayerPersisted", (Tag)tag);
        return false;
    }

    public record PlayerMessageObject(String eventName, String playerName, String fromDimension, String toDimension) {
    }

    public record ChatMessageObject(String username, String message, String uuid, boolean isHidden) {
    }
}

