/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.data;

import de.srendi.advancedperipherals.client.KeyBindings;
import de.srendi.advancedperipherals.common.setup.Blocks;
import de.srendi.advancedperipherals.common.setup.CCRegistration;
import de.srendi.advancedperipherals.common.setup.Items;
import de.srendi.advancedperipherals.common.setup.Villagers;
import java.util.function.Supplier;
import net.minecraft.client.KeyMapping;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.data.LanguageProvider;
import org.jetbrains.annotations.NotNull;

public class EnUsLanguageProvider
extends LanguageProvider {
    public EnUsLanguageProvider(PackOutput gen) {
        super(gen, "advancedperipherals", "en_us");
    }

    protected void addTranslations() {
        this.addBlocks();
        this.addItems();
        this.addTurtles();
        this.addPockets();
        this.addAdvancements();
        this.addTooltips();
        this.addKeybinds();
        this.addText();
        this.add(Villagers.COMPUTER_SCIENTIST, "Computer Scientist");
        this.add("advancedperipherals.name", "Advanced Peripherals");
        this.add("itemGroup.advancedperipheralstab", "Advanced Peripherals");
    }

    private void addItems() {
        this.addItem((Supplier)Items.CHUNK_CONTROLLER, "Chunk Controller");
        this.addItem((Supplier)Items.COMPUTER_TOOL, "Computer Tool");
        this.addItem((Supplier)Items.WEAK_AUTOMATA_CORE, "Weak Automata Core");
        this.addItem((Supplier)Items.HUSBANDRY_AUTOMATA_CORE, "Husbandry Automata Core");
        this.addItem((Supplier)Items.END_AUTOMATA_CORE, "End Automata Core");
        this.addItem((Supplier)Items.OVERPOWERED_WEAK_AUTOMATA_CORE, "Overpowered Weak Automata Core");
        this.addItem((Supplier)Items.OVERPOWERED_HUSBANDRY_AUTOMATA_CORE, "Overpowered Husbandry Automata Core");
        this.addItem((Supplier)Items.OVERPOWERED_END_AUTOMATA_CORE, "Overpowered End Automata Core");
        this.addItem((Supplier)Items.MEMORY_CARD, "Memory Card");
    }

    private void addBlocks() {
        this.addBlock((Supplier)Blocks.BLOCK_READER, "Block Reader");
        this.addBlock((Supplier)Blocks.CHAT_BOX, "Chat Box");
        this.addBlock((Supplier)Blocks.COLONY_INTEGRATOR, "Colony Integrator");
        this.addBlock((Supplier)Blocks.ENERGY_DETECTOR, "Energy Detector");
        this.addBlock((Supplier)Blocks.ENVIRONMENT_DETECTOR, "Environment Detector");
        this.addBlock((Supplier)Blocks.GEO_SCANNER, "Geo Scanner");
        this.addBlock((Supplier)Blocks.INVENTORY_MANAGER, "Inventory Manager");
        this.addBlock((Supplier)Blocks.ME_BRIDGE, "ME Bridge");
        this.addBlock((Supplier)Blocks.NBT_STORAGE, "NBT Storage");
        this.addBlock((Supplier)Blocks.PERIPHERAL_CASING, "Peripheral Casing");
        this.addBlock((Supplier)Blocks.PLAYER_DETECTOR, "Player Detector");
        this.addBlock((Supplier)Blocks.REDSTONE_INTEGRATOR, "Redstone Integrator");
    }

    private void addTurtles() {
        this.addTurtle(CCRegistration.ID.CHUNKY_TURTLE, "Chunky");
        this.addTurtle(CCRegistration.ID.CHATTY_TURTLE, "Chatty");
        this.addTurtle(CCRegistration.ID.ENVIRONMENT_TURTLE, "Environment");
        this.addTurtle(CCRegistration.ID.PLAYER_TURTLE, "Player Detector");
        this.addTurtle(CCRegistration.ID.GEOSCANNER_TURTLE, "Geo");
        this.addTurtle(CCRegistration.ID.COMPASS_TURTLE, "Compass");
        this.addTurtle(CCRegistration.ID.WEAK_AUTOMATA, "Weak automata");
        this.addTurtle(CCRegistration.ID.HUSBANDRY_AUTOMATA, "Husbandry automata");
        this.addTurtle(CCRegistration.ID.END_AUTOMATA, "End automata");
        this.addTurtle(CCRegistration.ID.OP_WEAK_AUTOMATA, "Overpowered weak automata");
        this.addTurtle(CCRegistration.ID.OP_HUSBANDRY_AUTOMATA, "Overpowered husbandry automata");
        this.addTurtle(CCRegistration.ID.OP_END_AUTOMATA, "Overpowered end automata");
    }

    private void addPockets() {
        this.addPocket(CCRegistration.ID.COLONY_POCKET, "Colony");
        this.addPocket(CCRegistration.ID.CHATTY_POCKET, "Chatty");
        this.addPocket(CCRegistration.ID.ENVIRONMENT_POCKET, "Environment");
        this.addPocket(CCRegistration.ID.GEOSCANNER_POCKET, "Geo");
        this.addPocket(CCRegistration.ID.PLAYER_POCKET, "Player Detector");
    }

    private void addAdvancements() {
        this.addAdvancement("root", "Advanced Peripherals", "Every journey starts with the first block");
        this.addAdvancement("weak_automata_core", "First automata core", "Does the afterlife exist in minecraft?");
        this.addAdvancement("end_automata_core", "End automata core", "If you can code gps-free position location with this, you're a powerful human being");
        this.addAdvancement("husbandry_automata_core", "Husbandry automata core", "Is this core gluten-free?");
        this.addAdvancement("overpowered_automata_core", "Overpowered automata core", "Can you handle so much power?");
        this.addAdvancement("base_toolkit", "Gentleman's set!", "Collect a redstone integrator, inventory manager and energy detector. How did you even play without this?");
        this.addAdvancement("nbt_toolkit", "No secrets", "Collect a NBT storage and block reader. Now, all the world's secrets are open to you!");
        this.addAdvancement("sense_toolkit", "The truth can't hide forever", "Collect a geo scanner and environmental detector. There are no limits for observability!");
    }

    private void addTooltips() {
        this.addTooltip("show_desc", "&b[&7%s&b] &7For Description");
        this.addTooltip("disabled", "&cThis item is disabled in the config, so you can craft it, but it'll not have any functionality.");
        this.addTooltip((Item)Items.COMPUTER_TOOL.get(), "&7This tool was made to tune our blocks. But for now, it's just a blue useless wrench.");
        this.addTooltip((Block)Blocks.ENERGY_DETECTOR.get(), "&7Can detect energy flow and acts as a resistor.");
        this.addTooltip((Item)Items.CHUNK_CONTROLLER.get(), "&7A crafting ingredient for the Chunky Turtle.");
        this.addTooltip((Block)Blocks.ENVIRONMENT_DETECTOR.get(), "&7This peripheral interacts with the minecraft world.");
        this.addTooltip((Block)Blocks.PLAYER_DETECTOR.get(), "&7This peripheral can be used to interact with players, but don't be a stalker.");
        this.addTooltip((Block)Blocks.ME_BRIDGE.get(), "&7The ME Bridge interacts with Applied Energistics to manage your items.");
        this.addTooltip((Block)Blocks.CHAT_BOX.get(), "&7Interacts with the ingame chat, can read and write messages.");
        this.addTooltip((Block)Blocks.PERIPHERAL_CASING.get(), "&7An empty hull without the love it deserves. Used as a crafting ingredient");
        this.addTooltip((Item)Items.MEMORY_CARD.get(), "&7Can save the rights of a player to use it in an inventory manager.");
        this.addTooltip("memory_card.bound", "&7Bound to &b%s&7.");
        this.addTooltip((Block)Blocks.INVENTORY_MANAGER.get(), "&7This block is able to send or receive specific items from a player inventory.");
        this.addTooltip((Block)Blocks.REDSTONE_INTEGRATOR.get(), "&7This block is able to interact with redstone. Works exactly like the redstone api of an computer.");
        this.addTooltip((Block)Blocks.BLOCK_READER.get(), "&7Reads nbt data of blocks to interact with blocks which do not have computer support.");
        this.addTooltip((Block)Blocks.GEO_SCANNER.get(), "&7Scans the area around it to find some shiny ores.");
        this.addTooltip((Block)Blocks.COLONY_INTEGRATOR.get(), "&7Interacts with Minecolonies to read data about your colony and citizens.");
        this.addTooltip((Block)Blocks.NBT_STORAGE.get(), "&7Acts like a storage disk. Can store nbt based data.");
        this.addTooltip((Item)Items.WEAK_AUTOMATA_CORE.get(), "&7Upgrade for turtles, which makes turtles more useful.");
        this.addTooltip((Item)Items.OVERPOWERED_WEAK_AUTOMATA_CORE.get(), "&7Improved version of the weak automata core, that provides some overpowered uses! Be careful, the upgrade is very fragile.");
        this.addTooltip((Item)Items.HUSBANDRY_AUTOMATA_CORE.get(), "&7Upgrade for turtles, that allows basic and advanced interactions with animals.");
        this.addTooltip((Item)Items.OVERPOWERED_HUSBANDRY_AUTOMATA_CORE.get(), "&7Improved version of the husbandry automata core, that provides some overpowered uses! Be careful, the upgrade is very fragile.");
        this.addTooltip((Item)Items.END_AUTOMATA_CORE.get(), "&7Upgrade for turtles, that allows basic interaction with the world and teleportation in one dimension.");
        this.addTooltip((Item)Items.OVERPOWERED_END_AUTOMATA_CORE.get(), "&7Improved version of the end automata core, that provides some overpowered uses! Be careful, the upgrade is very fragile.");
    }

    private void addText() {
        this.add("text.advancedperipherals.removed_player", "Cleared the memory card");
        this.add("text.advancedperipherals.added_player", "Added you to the memory card");
        this.add("text.advancedperipherals.automata_core_feed_by_player", "You're trying to feed an entity to a soul, but your own body refuses to do this. Maybe something more mechanical can do this?");
    }

    private void addKeybinds() {
        this.add("keybind.advancedperipherals.category", "Advanced Peripherals");
        this.addKeybind(KeyBindings.DESCRIPTION_KEYBINDING, "Show Description");
    }

    private void addAdvancement(@NotNull String advancement, @NotNull String name, @NotNull String description) {
        this.add("advancements.advancedperipherals." + advancement, name);
        this.add("advancements.advancedperipherals." + advancement + ".description", description);
    }

    private void add(@NotNull Supplier<VillagerProfession> key, @NotNull String name) {
        this.add("entity.minecraft.villager.advancedperipherals." + key.get().name().split(":")[1], name);
    }

    private void addTurtle(@NotNull ResourceLocation key, @NotNull String name) {
        this.add("turtle." + key.getNamespace() + "." + key.getPath(), name);
    }

    private void addPocket(@NotNull ResourceLocation key, @NotNull String name) {
        this.add("pocket." + key.getNamespace() + "." + key.getPath(), name);
    }

    private void addTooltip(Item item, String name) {
        this.addTooltip(BuiltInRegistries.ITEM.getKey((Object)item).getPath(), name);
    }

    private void addTooltip(Block block, String name) {
        this.addTooltip(BuiltInRegistries.BLOCK.getKey((Object)block).getPath(), name);
    }

    private void addTooltip(String tooltip, String name) {
        this.add("item.advancedperipherals.tooltip." + tooltip, name);
    }

    private void addKeybind(@NotNull KeyMapping keybind, String name) {
        this.add(keybind.getName(), name);
    }
}

