/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.container;

import de.srendi.advancedperipherals.common.container.base.BaseContainer;
import de.srendi.advancedperipherals.common.container.base.SlotCondition;
import de.srendi.advancedperipherals.common.container.base.SlotInputHandler;
import de.srendi.advancedperipherals.common.setup.ContainerTypes;
import de.srendi.advancedperipherals.common.setup.Items;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class InventoryManagerContainer
extends BaseContainer {
    public InventoryManagerContainer(int id, Inventory inventory, BlockPos pos, Level level) {
        super((MenuType)ContainerTypes.INVENTORY_MANAGER_CONTAINER.get(), id, inventory, pos, level);
        this.layoutPlayerInventorySlots(7, 84);
        if (this.tileEntity != null) {
            this.addSlot((Slot)new SlotInputHandler(this.tileEntity.createItemHandlerCap(null), 0, 79, 29, new SlotCondition().setNeededItem((Item)Items.MEMORY_CARD.get())));
        }
    }

    public boolean stillValid(@NotNull Player playerIn) {
        return true;
    }

    @Override
    @NotNull
    public ItemStack quickMoveStack(@NotNull Player player, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (index >= 36 ? !this.moveItemStackTo(itemstack1, 0, 36, true) : (index <= 35 ? itemstack1.getItem().equals(Items.MEMORY_CARD.get()) && !this.moveItemStackTo(itemstack1, 36, 37, true) : !this.moveItemStackTo(itemstack1, 0, 36, false))) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, itemstack1);
        }
        return itemstack;
    }
}

