/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import dan200.computercraft.core.computer.ComputerSide;
import dan200.computercraft.shared.ModRegistry;
import dan200.computercraft.shared.command.text.ChatHelpers;
import dan200.computercraft.shared.command.text.TableBuilder;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.computer.core.ServerContext;
import de.srendi.advancedperipherals.common.addons.computercraft.peripheral.ChunkyPeripheral;
import de.srendi.advancedperipherals.common.util.inventory.ItemUtil;
import java.util.Comparator;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.RegisterCommandsEvent;

@EventBusSubscriber(modid="advancedperipherals")
public class APCommands {
    public static final String ROOT_LITERAL = "advancedperipherals";
    public static final String FORCELOAD_LITERAL = "forceload";
    static final String FORCELOAD_HELP = "/advancedperipherals forceload help - show this help message\n/advancedperipherals forceload dump - show all chunky turtles\n";
    public static final String EXEC_LITERAL = "safe-exec";
    public static final String ROOT_SAFE_EXEC_LITERAL = "ap-safe-exec";

    @SubscribeEvent
    public static void register(RegisterCommandsEvent event) {
        LiteralCommandNode safeExecNode = ((LiteralArgumentBuilder)Commands.literal((String)EXEC_LITERAL).then(Commands.argument((String)"command", (ArgumentType)StringArgumentType.greedyString()).executes(APCommands::safeExecute))).build();
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)ROOT_LITERAL).then(Commands.literal((String)"getHashItem").executes(context -> APCommands.getHashItem((CommandSourceStack)context.getSource())))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)FORCELOAD_LITERAL).executes(context -> APCommands.forceloadHelp((CommandSourceStack)context.getSource()))).then(Commands.literal((String)"help").executes(context -> APCommands.forceloadHelp((CommandSourceStack)context.getSource())))).then(((LiteralArgumentBuilder)Commands.literal((String)"dump").requires(ModRegistry.Permissions.PERMISSION_DUMP)).executes(context -> APCommands.forceloadDump((CommandSourceStack)context.getSource()))))).then((CommandNode)safeExecNode));
        event.getDispatcher().register((LiteralArgumentBuilder)Commands.literal((String)ROOT_SAFE_EXEC_LITERAL).redirect((CommandNode)safeExecNode));
    }

    private static int getHashItem(CommandSourceStack source) throws CommandSyntaxException {
        ServerPlayer playerEntity = source.getPlayerOrException();
        if (playerEntity.getMainHandItem().isEmpty()) {
            source.sendFailure((Component)Component.literal((String)"You need an item in your main hand."));
            return 0;
        }
        String fingerprint = ItemUtil.getFingerprint(playerEntity.getMainHandItem());
        if (fingerprint.isEmpty()) {
            source.sendFailure((Component)Component.literal((String)"There was an issue while generating the hash. Report to Author"));
            return 0;
        }
        source.sendSuccess(() -> Component.literal((String)"Fingerprint of the item: "), true);
        source.sendSuccess(() -> ComponentUtils.wrapInSquareBrackets((Component)Component.literal((String)fingerprint).withStyle(style -> style.applyFormat(ChatFormatting.GREEN).withClickEvent(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, fingerprint)).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Copy"))))), true);
        return 1;
    }

    private static int forceloadHelp(CommandSourceStack source) throws CommandSyntaxException {
        source.sendSuccess(() -> Component.literal((String)FORCELOAD_HELP), true);
        return 1;
    }

    private static int forceloadDump(CommandSourceStack source) throws CommandSyntaxException {
        ServerComputer[] computers;
        TableBuilder table = new TableBuilder("ChunkyTurtles", new String[]{"Computer", "Position"});
        for (ServerComputer computer2 : computers = (ServerComputer[])ServerContext.get((MinecraftServer)source.getServer()).registry().getComputers().stream().filter(computer -> {
            for (ComputerSide side : ComputerSide.values()) {
                if (!(computer.getPeripheral(side) instanceof ChunkyPeripheral)) continue;
                return true;
            }
            return false;
        }).sorted(Comparator.comparingInt(ServerComputer::getID)).toArray(ServerComputer[]::new)) {
            table.row(new Component[]{APCommands.makeComputerDumpCommand(computer2), APCommands.makeComputerPosCommand(computer2)});
        }
        table.display(source);
        return computers.length;
    }

    private static int safeExecute(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = ((CommandSourceStack)context.getSource()).withPermission(0);
        String command = StringArgumentType.getString(context, (String)"command");
        try {
            source.getServer().getCommands().performPrefixedCommand(source, command);
            return 1;
        }
        catch (RuntimeException e) {
            source.sendFailure((Component)Component.literal((String)e.getMessage()));
            return 0;
        }
    }

    private static Component makeComputerDumpCommand(ServerComputer computer) {
        return ChatHelpers.link((MutableComponent)Component.literal((String)("#" + computer.getID())), (String)("/computercraft dump " + String.valueOf(computer.getInstanceUUID())), (Component)Component.translatable((String)"commands.computercraft.dump.action"));
    }

    private static Component makeComputerPosCommand(ServerComputer computer) {
        return ChatHelpers.link((MutableComponent)ChatHelpers.position((BlockPos)computer.getPosition()), (String)("/computercraft tp " + String.valueOf(computer.getInstanceUUID())), (Component)Component.translatable((String)"commands.computercraft.tp.action"));
    }
}

