/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.blocks.base;

import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import de.srendi.advancedperipherals.AdvancedPeripherals;
import de.srendi.advancedperipherals.common.blocks.base.ICapabilityProvider;
import de.srendi.advancedperipherals.common.blocks.base.IInventoryBlock;
import de.srendi.advancedperipherals.lib.peripherals.BasePeripheral;
import de.srendi.advancedperipherals.lib.peripherals.IPeripheralTileEntity;
import java.util.Collections;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.SidedInvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PeripheralBlockEntity<T extends BasePeripheral<?>>
extends BaseContainerBlockEntity
implements WorldlyContainer,
MenuProvider,
IPeripheralTileEntity,
ICapabilityProvider {
    private static final String PERIPHERAL_SETTINGS_KEY = "peripheralSettings";
    protected CompoundTag peripheralSettings;
    protected NonNullList<ItemStack> items;
    @Nullable
    protected T peripheral = null;
    private IItemHandler itemHandler;
    private IFluidHandler fluidHandler;

    public PeripheralBlockEntity(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
        PeripheralBlockEntity peripheralBlockEntity = this;
        if (peripheralBlockEntity instanceof IInventoryBlock) {
            IInventoryBlock inventoryBlock = (IInventoryBlock)((Object)peripheralBlockEntity);
            this.items = NonNullList.withSize((int)inventoryBlock.getInvSize(), (Object)ItemStack.EMPTY);
        } else {
            this.items = NonNullList.withSize((int)0, (Object)ItemStack.EMPTY);
        }
        this.peripheralSettings = new CompoundTag();
    }

    @Override
    @Nullable
    public IPeripheral createPeripheralCap(@Nullable Direction side) {
        if (this.peripheral == null) {
            this.peripheral = this.createPeripheral();
        }
        if (this.peripheral.isEnabled()) {
            return this.peripheral;
        }
        AdvancedPeripherals.debug(((BasePeripheral)this.peripheral).getType() + " is disabled, you can enable it in the Configuration.");
        return null;
    }

    @Override
    @Nullable
    public IFluidHandler createFluidHandlerCap(@Nullable Direction side) {
        if (this.fluidHandler == null) {
            this.fluidHandler = new FluidTank(0);
        }
        return this.fluidHandler;
    }

    @Override
    @Nullable
    public IItemHandler createItemHandlerCap(@Nullable Direction side) {
        if (this.itemHandler == null) {
            this.itemHandler = new SidedInvWrapper((WorldlyContainer)this, null);
        }
        return this.itemHandler;
    }

    @NotNull
    protected abstract T createPeripheral();

    public Iterable<IComputerAccess> getConnectedComputers() {
        if (this.peripheral == null) {
            return Collections.emptyList();
        }
        return ((BasePeripheral)this.peripheral).getConnectedComputers();
    }

    protected void saveAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        ContainerHelper.saveAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)provider);
        if (!this.peripheralSettings.isEmpty()) {
            tag.put(PERIPHERAL_SETTINGS_KEY, (Tag)this.peripheralSettings);
        }
    }

    protected void loadAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider provider) {
        ContainerHelper.loadAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)provider);
        this.peripheralSettings = tag.getCompound(PERIPHERAL_SETTINGS_KEY);
        super.loadAdditional(tag, provider);
    }

    protected Component getDefaultName() {
        Component component;
        PeripheralBlockEntity peripheralBlockEntity = this;
        if (peripheralBlockEntity instanceof IInventoryBlock) {
            IInventoryBlock inventoryBlock = (IInventoryBlock)((Object)peripheralBlockEntity);
            component = inventoryBlock.getDisplayName();
        } else {
            component = null;
        }
        return component;
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, @NotNull Inventory inventory, @NotNull Player playerEntity) {
        return this.createMenu(id, inventory);
    }

    protected AbstractContainerMenu createMenu(int id, @NotNull Inventory player) {
        AbstractContainerMenu abstractContainerMenu;
        PeripheralBlockEntity peripheralBlockEntity = this;
        if (peripheralBlockEntity instanceof IInventoryBlock) {
            IInventoryBlock inventoryBlock = (IInventoryBlock)((Object)peripheralBlockEntity);
            abstractContainerMenu = (AbstractContainerMenu)inventoryBlock.createContainer(id, player, this.worldPosition, this.level);
        } else {
            abstractContainerMenu = null;
        }
        return abstractContainerMenu;
    }

    public int @NotNull [] getSlotsForFace(@NotNull Direction side) {
        return new int[]{0};
    }

    public boolean canPlaceItemThroughFace(int index, @NotNull ItemStack itemStackIn, @Nullable Direction direction) {
        return this instanceof IInventoryBlock;
    }

    public boolean canTakeItemThroughFace(int index, @NotNull ItemStack stack, @NotNull Direction direction) {
        return this instanceof IInventoryBlock;
    }

    public int getContainerSize() {
        return this.items.size();
    }

    public boolean isEmpty() {
        for (ItemStack itemStack : this.items) {
            if (!itemStack.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public ItemStack getItem(int index) {
        if (index < 0 || index >= this.items.size()) {
            return ItemStack.EMPTY;
        }
        return (ItemStack)this.items.get(index);
    }

    @NotNull
    public ItemStack removeItem(int index, int count) {
        return ContainerHelper.removeItem(this.items, (int)index, (int)count);
    }

    @NotNull
    public ItemStack removeItemNoUpdate(int index) {
        return ContainerHelper.takeItem(this.items, (int)index);
    }

    public void setItem(int index, @NotNull ItemStack stack) {
        this.items.set(index, (Object)stack);
        if (stack.getCount() > this.getMaxStackSize()) {
            stack.setCount(this.getMaxStackSize());
        }
    }

    @NotNull
    public NonNullList<ItemStack> getItems() {
        return this.items;
    }

    public void setItems(@NotNull NonNullList<ItemStack> items) {
        this.items = items;
    }

    public boolean stillValid(@NotNull Player player) {
        return true;
    }

    public void clearContent() {
        this.items.clear();
    }

    @Override
    public CompoundTag getPeripheralSettings() {
        return this.peripheralSettings;
    }

    @Override
    public void markSettingsChanged() {
        this.setChanged();
    }
}

