/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.addons.computercraft.peripheral.plugins;

import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.core.apis.TableHelper;
import de.srendi.advancedperipherals.common.addons.computercraft.operations.SingleOperation;
import de.srendi.advancedperipherals.common.addons.computercraft.owner.TurtlePeripheralOwner;
import de.srendi.advancedperipherals.common.addons.computercraft.peripheral.plugins.AutomataCorePlugin;
import de.srendi.advancedperipherals.common.setup.DataComponents;
import de.srendi.advancedperipherals.common.util.LuaConverter;
import de.srendi.advancedperipherals.common.util.fakeplayer.APFakePlayer;
import de.srendi.advancedperipherals.lib.peripherals.AutomataCorePeripheral;
import de.srendi.advancedperipherals.lib.peripherals.IPeripheralOperation;
import java.util.Collections;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AutomataEntityTransferPlugin
extends AutomataCorePlugin {
    private static final String ENTITY_NBT_KEY = "storedEntity";
    private final Predicate<Entity> suitableEntity;

    public AutomataEntityTransferPlugin(AutomataCorePeripheral automataCore, Predicate<Entity> suitableEntity) {
        super(automataCore);
        this.suitableEntity = suitableEntity;
    }

    @Override
    @Nullable
    public IPeripheralOperation<?>[] getOperations() {
        return new IPeripheralOperation[]{SingleOperation.CAPTURE_ANIMAL};
    }

    protected boolean isEntityInside() {
        return ((TurtlePeripheralOwner)this.automataCore.getPeripheralOwner()).getDataStorage().get((DataComponentType)DataComponents.ENTITY_TRANSFER.get()).isPresent();
    }

    protected void saveEntity(CompoundTag data) {
        PatchedDataComponentMap patch = PatchedDataComponentMap.fromPatch((DataComponentMap)DataComponentMap.EMPTY, (DataComponentPatch)((TurtlePeripheralOwner)this.automataCore.getPeripheralOwner()).getDataStorage());
        patch.set((DataComponentType)DataComponents.ENTITY_TRANSFER.get(), (Object)data);
        ((TurtlePeripheralOwner)this.automataCore.getPeripheralOwner()).putDataStorage(patch.asPatch());
    }

    protected CompoundTag getEntity() {
        return (CompoundTag)((TurtlePeripheralOwner)this.automataCore.getPeripheralOwner()).getDataStorage().get((DataComponentType)DataComponents.ENTITY_TRANSFER.get()).get();
    }

    protected void removeEntity() {
        PatchedDataComponentMap patch = PatchedDataComponentMap.fromPatch((DataComponentMap)DataComponentMap.EMPTY, (DataComponentPatch)((TurtlePeripheralOwner)this.automataCore.getPeripheralOwner()).getDataStorage());
        patch.remove((DataComponentType)DataComponents.ENTITY_TRANSFER.get());
        ((TurtlePeripheralOwner)this.automataCore.getPeripheralOwner()).putDataStorage(patch.asPatch());
    }

    @Nullable
    protected Entity extractEntity() {
        CompoundTag data = this.getEntity();
        EntityType type = EntityType.byString((String)data.getString("entity")).orElse(null);
        if (type != null) {
            Entity entity = type.create(((TurtlePeripheralOwner)this.automataCore.getPeripheralOwner()).getLevel());
            if (entity == null) {
                return null;
            }
            entity.load(data);
            return entity;
        }
        return null;
    }

    @LuaFunction(mainThread=true)
    public final MethodResult captureAnimal(@NotNull IArguments arguments) throws LuaException {
        Map opts = arguments.count() > 0 ? arguments.getTable(0) : Collections.emptyMap();
        float yaw = opts != null ? (float)TableHelper.optNumberField((Map)opts, (String)"yaw", (double)0.0) : 0.0f;
        float pitch = opts != null ? (float)TableHelper.optNumberField((Map)opts, (String)"pitch", (double)0.0) : 0.0f;
        HitResult entityHit = ((TurtlePeripheralOwner)this.automataCore.getPeripheralOwner()).withPlayer(APFakePlayer.wrapActionWithRot(yaw, pitch, p -> p.findHit(false, true, this.suitableEntity)));
        if (entityHit.getType() == HitResult.Type.MISS) {
            return MethodResult.of((Object[])new Object[]{null, "Nothing found"});
        }
        return this.automataCore.withOperation(SingleOperation.CAPTURE_ANIMAL, context -> {
            LivingEntity entity = (LivingEntity)((EntityHitResult)entityHit).getEntity();
            if (entity instanceof Player || !entity.isAlive()) {
                return MethodResult.of((Object[])new Object[]{null, "Unsuitable entity"});
            }
            CompoundTag nbt = new CompoundTag();
            nbt.putString("entity", EntityType.getKey((EntityType)entity.getType()).toString());
            entity.saveWithoutId(nbt);
            entity.remove(Entity.RemovalReason.CHANGED_DIMENSION);
            this.saveEntity(nbt);
            return MethodResult.of((Object)true);
        }, context -> {
            if (this.isEntityInside()) {
                return MethodResult.of((Object[])new Object[]{null, "Another entity already captured"});
            }
            return null;
        });
    }

    @LuaFunction(mainThread=true)
    public final MethodResult releaseAnimal() {
        if (!this.isEntityInside()) {
            return MethodResult.of((Object[])new Object[]{null, "No entity is stored"});
        }
        TurtlePeripheralOwner owner = (TurtlePeripheralOwner)this.automataCore.getPeripheralOwner();
        this.automataCore.addRotationCycle();
        Entity extractedEntity = this.extractEntity();
        if (extractedEntity == null) {
            return MethodResult.of((Object[])new Object[]{null, "Problem with entity unpacking"});
        }
        BlockPos blockPos = owner.getPos().offset(owner.getFacing().getNormal());
        extractedEntity.absMoveTo((double)blockPos.getX() + 0.5, (double)blockPos.getY(), (double)blockPos.getZ() + 0.5, 0.0f, 0.0f);
        this.removeEntity();
        owner.getLevel().addFreshEntity(extractedEntity);
        return MethodResult.of((Object)true);
    }

    @LuaFunction(mainThread=true)
    public final MethodResult getCapturedAnimal() {
        Entity extractedEntity = this.extractEntity();
        return MethodResult.of(LuaConverter.completeEntityToLua(extractedEntity, ((TurtlePeripheralOwner)this.automataCore.getPeripheralOwner()).getToolInMainHand()));
    }
}

