/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.addons.computercraft.peripheral;

import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.pocket.IPocketAccess;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.TurtleSide;
import de.srendi.advancedperipherals.common.addons.computercraft.operations.SphereOperation;
import de.srendi.advancedperipherals.common.addons.computercraft.operations.SphereOperationContext;
import de.srendi.advancedperipherals.common.addons.computercraft.owner.BlockEntityPeripheralOwner;
import de.srendi.advancedperipherals.common.addons.computercraft.owner.IPeripheralOwner;
import de.srendi.advancedperipherals.common.addons.computercraft.owner.PocketPeripheralOwner;
import de.srendi.advancedperipherals.common.addons.computercraft.owner.TurtlePeripheralOwner;
import de.srendi.advancedperipherals.common.blocks.base.PeripheralBlockEntity;
import de.srendi.advancedperipherals.common.configuration.APConfig;
import de.srendi.advancedperipherals.common.util.LuaConverter;
import de.srendi.advancedperipherals.lib.peripherals.BasePeripheral;
import de.srendi.advancedperipherals.lib.peripherals.IPeripheralPlugin;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.phys.AABB;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.CanContinueSleepingEvent;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;

public class EnvironmentDetectorPeripheral
extends BasePeripheral<IPeripheralOwner> {
    public static final String PERIPHERAL_TYPE = "environmentDetector";
    private static final List<Function<IPeripheralOwner, IPeripheralPlugin>> PERIPHERAL_PLUGINS = new LinkedList<Function<IPeripheralOwner, IPeripheralPlugin>>();

    protected EnvironmentDetectorPeripheral(IPeripheralOwner owner) {
        super(PERIPHERAL_TYPE, owner);
        owner.attachOperation(SphereOperation.SCAN_ENTITIES);
        for (Function<IPeripheralOwner, IPeripheralPlugin> plugin : PERIPHERAL_PLUGINS) {
            this.addPlugin(plugin.apply(owner));
        }
    }

    public EnvironmentDetectorPeripheral(PeripheralBlockEntity<?> tileEntity) {
        this(new BlockEntityPeripheralOwner(tileEntity).attachFuel());
    }

    public EnvironmentDetectorPeripheral(ITurtleAccess turtle, TurtleSide side) {
        this(new TurtlePeripheralOwner(turtle, side).attachFuel(1));
    }

    public EnvironmentDetectorPeripheral(IPocketAccess pocket) {
        this(new PocketPeripheralOwner(pocket));
    }

    private static int estimateCost(int radius) {
        if (radius <= SphereOperation.SCAN_ENTITIES.getMaxFreeRadius()) {
            return 0;
        }
        if (radius > SphereOperation.SCAN_ENTITIES.getMaxCostRadius()) {
            return -1;
        }
        return SphereOperation.SCAN_ENTITIES.getCost(SphereOperationContext.of(radius));
    }

    public static void addIntegrationPlugin(Function<IPeripheralOwner, IPeripheralPlugin> plugin) {
        PERIPHERAL_PLUGINS.add(plugin);
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)APConfig.PERIPHERALS_CONFIG.enableEnergyDetector.get();
    }

    @LuaFunction(mainThread=true)
    public final String getBiome() {
        Optional biome = this.getLevel().getBiome(this.getPos()).unwrapKey();
        return biome.map(biomeResourceKey -> biomeResourceKey.location().toString()).orElse("unknown");
    }

    @LuaFunction(mainThread=true)
    public final int getSkyLightLevel() {
        return this.getLevel().getBrightness(LightLayer.SKY, this.getPos().offset(0, 1, 0));
    }

    @LuaFunction(mainThread=true)
    public final int getBlockLightLevel() {
        return this.getLevel().getBrightness(LightLayer.BLOCK, this.getPos().offset(0, 1, 0));
    }

    @LuaFunction(mainThread=true)
    public final int getDayLightLevel() {
        Level level = this.getLevel();
        int i = level.getBrightness(LightLayer.SKY, this.getPos().offset(0, 1, 0)) - level.getSkyDarken();
        float f = level.getSunAngle(1.0f);
        if (i > 0) {
            float f1 = f < (float)Math.PI ? 0.0f : (float)Math.PI * 2;
            f += (f1 - f) * 0.2f;
            i = Math.round((float)i * Mth.cos((float)f));
        }
        i = Mth.clamp((int)i, (int)0, (int)15);
        return i;
    }

    @LuaFunction(mainThread=true)
    public final long getTime() {
        return this.getLevel().getDayTime();
    }

    @LuaFunction(mainThread=true)
    public final boolean isSlimeChunk() {
        ChunkPos chunkPos = new ChunkPos(this.getPos());
        return WorldgenRandom.seedSlimeChunk((int)chunkPos.x, (int)chunkPos.z, (long)((WorldGenLevel)this.getLevel()).getSeed(), (long)987234911L).nextInt(10) == 0;
    }

    @LuaFunction(mainThread=true)
    public final String getDimension() {
        return this.getLevel().dimension().location().toString();
    }

    @LuaFunction(mainThread=true)
    public final boolean isDimension(String dimension) {
        return this.getLevel().dimension().location().toString().equals(dimension);
    }

    @LuaFunction(mainThread=true)
    public final Set<String> listDimensions() {
        HashSet<String> dimensions = new HashSet<String>();
        ServerLifecycleHooks.getCurrentServer().getAllLevels().forEach(serverWorld -> dimensions.add(serverWorld.dimension().location().getPath()));
        return dimensions;
    }

    @LuaFunction(mainThread=true)
    public final int getMoonId() {
        return this.getCurrentMoonPhase().keySet().toArray(new Integer[0])[0];
    }

    @LuaFunction(mainThread=true)
    public final boolean isMoon(int phase) {
        return this.getCurrentMoonPhase().containsKey(phase);
    }

    @LuaFunction(mainThread=true)
    public final String getMoonName() {
        String[] name = this.getCurrentMoonPhase().values().toArray(new String[0]);
        return name[0];
    }

    private Map<Integer, String> getCurrentMoonPhase() {
        HashMap<Integer, String> moon = new HashMap<Integer, String>();
        if (this.getLevel().dimension() == Level.OVERWORLD) {
            switch (this.getLevel().getMoonPhase()) {
                case 0: {
                    moon.put(0, "Full moon");
                    break;
                }
                case 1: {
                    moon.put(1, "Waning gibbous");
                    break;
                }
                case 2: {
                    moon.put(2, "Third quarter");
                    break;
                }
                case 3: {
                    moon.put(3, "Wanning crescent");
                    break;
                }
                case 4: {
                    moon.put(4, "New moon");
                    break;
                }
                case 5: {
                    moon.put(5, "Waxing crescent");
                    break;
                }
                case 6: {
                    moon.put(6, "First quarter");
                    break;
                }
                case 7: {
                    moon.put(7, "Waxing gibbous");
                    break;
                }
                default: {
                    moon.put(0, "What is a moon");
                    break;
                }
            }
        } else {
            moon.put(0, "Moon.exe not found...");
        }
        return moon;
    }

    @LuaFunction(mainThread=true)
    public final boolean isRaining() {
        return this.getLevel().getRainLevel(0.0f) > 0.0f;
    }

    @LuaFunction(mainThread=true)
    public final boolean isThunder() {
        return this.getLevel().getThunderLevel(0.0f) > 0.0f;
    }

    @LuaFunction(mainThread=true)
    public final boolean isSunny() {
        return this.getLevel().getThunderLevel(0.0f) < 1.0f && this.getLevel().getRainLevel(0.0f) < 1.0f;
    }

    @LuaFunction(mainThread=true)
    public final MethodResult scanEntities(@NotNull IComputerAccess access, @NotNull IArguments arguments) throws LuaException {
        int radius = arguments.getInt(0);
        return this.withOperation(SphereOperation.SCAN_ENTITIES, new SphereOperationContext(radius), context -> {
            if (radius > SphereOperation.SCAN_ENTITIES.getMaxCostRadius()) {
                return MethodResult.of((Object[])new Object[]{null, "Radius exceeds max value"});
            }
            return null;
        }, context -> {
            BlockPos pos = this.owner.getPos();
            AABB box = new AABB(pos);
            ArrayList entities = new ArrayList();
            this.getLevel().getEntities((Entity)null, box.inflate((double)radius), LivingEntity.class::isInstance).forEach(entity -> entities.add(LuaConverter.completeEntityWithPositionToLua(entity, ItemStack.EMPTY, pos)));
            return MethodResult.of(entities);
        }, null);
    }

    @LuaFunction
    public final MethodResult scanCost(int radius) {
        int estimatedCost = EnvironmentDetectorPeripheral.estimateCost(radius);
        if (estimatedCost < 0) {
            return MethodResult.of((Object[])new Object[]{null, "Radius exceeds max value"});
        }
        return MethodResult.of((Object)estimatedCost);
    }

    @LuaFunction(mainThread=true)
    public final MethodResult canSleepHere() {
        return MethodResult.of((Object)(!this.getLevel().isDay() ? 1 : 0));
    }

    @LuaFunction(mainThread=true)
    public final MethodResult canSleepPlayer(String playername) {
        ServerPlayer player = ServerLifecycleHooks.getCurrentServer().getPlayerList().getPlayerByName(playername);
        if (player == null) {
            return MethodResult.of((Object[])new Object[]{false, "player_not_online"});
        }
        if (!player.level().dimensionType().bedWorks()) {
            return MethodResult.of((Object[])new Object[]{false, "not_allowed_in_dimension"});
        }
        CanContinueSleepingEvent evt = new CanContinueSleepingEvent((LivingEntity)player, null);
        NeoForge.EVENT_BUS.post((Event)evt);
        if (evt.mayContinueSleeping()) {
            return MethodResult.of((Object)(!player.level().isDay() ? 1 : 0));
        }
        return MethodResult.of((Object)true);
    }
}

