/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.addons.computercraft.peripheral;

import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.shared.util.NBTUtil;
import de.srendi.advancedperipherals.common.addons.computercraft.owner.BlockEntityPeripheralOwner;
import de.srendi.advancedperipherals.common.blocks.blockentities.BlockReaderEntity;
import de.srendi.advancedperipherals.common.configuration.APConfig;
import de.srendi.advancedperipherals.common.util.LuaConverter;
import de.srendi.advancedperipherals.lib.peripherals.BasePeripheral;
import java.util.HashMap;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class BlockReaderPeripheral
extends BasePeripheral<BlockEntityPeripheralOwner<BlockReaderEntity>> {
    public static final String PERIPHERAL_TYPE = "blockReader";

    public BlockReaderPeripheral(BlockReaderEntity tileEntity) {
        super(PERIPHERAL_TYPE, new BlockEntityPeripheralOwner<BlockReaderEntity>(tileEntity));
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)APConfig.PERIPHERALS_CONFIG.enableBlockReader.get();
    }

    @LuaFunction(mainThread=true)
    public final String getBlockName() {
        if (this.getBlockInFront().is(Blocks.AIR)) {
            return "none";
        }
        return BuiltInRegistries.BLOCK.getKey((Object)this.getBlockInFront().getBlock()).toString();
    }

    @LuaFunction(mainThread=true)
    public final Object getBlockData() {
        if (this.getBlockInFront().is(Blocks.AIR)) {
            return null;
        }
        BlockEntity target = this.getLevel().getBlockEntity(this.getPos().relative(((BlockEntityPeripheralOwner)this.owner).getFacing()));
        if (target == null) {
            return null;
        }
        return NBTUtil.toLua((Tag)target.saveWithoutMetadata((HolderLookup.Provider)RegistryAccess.EMPTY));
    }

    @LuaFunction(mainThread=true)
    public final Object getBlockStates() {
        if (this.getBlockInFront().is(Blocks.AIR)) {
            return null;
        }
        HashMap<String, Object> states = new HashMap<String, Object>();
        BlockState block = this.getLevel().getBlockState(this.getPos().relative(((BlockEntityPeripheralOwner)this.owner).getFacing()));
        for (Property property : block.getProperties()) {
            states.put(property.getName(), LuaConverter.stateToObject(block.getValue(property)));
        }
        return states;
    }

    @LuaFunction(mainThread=true)
    public final boolean isTileEntity() {
        if (this.getBlockInFront().is(Blocks.AIR)) {
            return false;
        }
        BlockEntity target = this.getLevel().getBlockEntity(this.getPos().relative(((BlockEntityPeripheralOwner)this.owner).getFacing()));
        return target != null;
    }

    private BlockState getBlockInFront() {
        return this.getLevel().getBlockState(this.getPos().relative(((BlockEntityPeripheralOwner)this.owner).getFacing()));
    }
}

