/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.addons.computercraft.operations;

import de.srendi.advancedperipherals.common.setup.DataComponents;
import de.srendi.advancedperipherals.lib.peripherals.IPeripheralOperation;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.component.DataComponentType;
import net.neoforged.neoforge.common.ModConfigSpec;

public enum SimpleFreeOperation implements IPeripheralOperation<Object>
{
    CHAT_MESSAGE(100);

    private final int defaultCooldown;
    private ModConfigSpec.IntValue cooldown;

    private SimpleFreeOperation(int defaultCooldown) {
        this.defaultCooldown = defaultCooldown;
    }

    @Override
    public void addToConfig(ModConfigSpec.Builder builder) {
        this.cooldown = builder.defineInRange(this.settingsName() + "Cooldown", this.defaultCooldown, 0, Integer.MAX_VALUE);
    }

    @Override
    public int getInitialCooldown() {
        return (Integer)this.cooldown.get();
    }

    @Override
    public int getCooldown(Object context) {
        return (Integer)this.cooldown.get();
    }

    @Override
    public int getCost(Object context) {
        return 0;
    }

    @Override
    public Map<String, Object> computerDescription() {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("name", this.settingsName());
        data.put("type", this.getClass().getSimpleName());
        data.put("cooldown", this.cooldown.get());
        return data;
    }

    @Override
    public DataComponentType<Long> dataComponentType() {
        return (DataComponentType)DataComponents.SIMPLE_FREE_OPERATION.get();
    }
}

