/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.addons.computercraft.integrations;

import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.lua.GenericSource;
import de.srendi.advancedperipherals.AdvancedPeripherals;
import de.srendi.advancedperipherals.common.addons.computercraft.integrations.BeaconIntegration;
import de.srendi.advancedperipherals.common.addons.computercraft.integrations.BlockEntityIntegration;
import de.srendi.advancedperipherals.common.addons.computercraft.integrations.BlockIntegration;
import de.srendi.advancedperipherals.common.addons.computercraft.integrations.NoteBlockIntegration;
import de.srendi.advancedperipherals.common.util.Platform;
import de.srendi.advancedperipherals.lib.integrations.IPeripheralIntegration;
import de.srendi.advancedperipherals.lib.peripherals.BlockEntityIntegrationPeripheral;
import java.util.Comparator;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.world.level.block.NoteBlock;
import net.minecraft.world.level.block.entity.BlockEntity;

public class IntegrationPeripheralProvider {
    private static final String[] SUPPORTED_MODS = new String[]{"mekanism"};
    private static final PriorityQueue<IPeripheralIntegration> integrations = new PriorityQueue<IPeripheralIntegration>(Comparator.comparingInt(IPeripheralIntegration::getPriority));

    private static void registerIntegration(IPeripheralIntegration integration) {
        integrations.add(integration);
    }

    @Deprecated(forRemoval=true, since="1.20.1-0.7.39")
    public static <T extends BlockEntity> void registerBlockEntityIntegration(Function<BlockEntity, BlockEntityIntegrationPeripheral<T>> integration, Class<T> tileClass) {
        IntegrationPeripheralProvider.registerIntegration(new BlockEntityIntegration(integration, tileClass::isInstance));
    }

    @Deprecated(forRemoval=true, since="1.20.1-0.7.39")
    public static <T extends BlockEntity> void registerBlockEntityIntegration(Function<BlockEntity, BlockEntityIntegrationPeripheral<T>> integration, Class<T> tileClass, int priority) {
        IntegrationPeripheralProvider.registerIntegration(new BlockEntityIntegration(integration, tileClass::isInstance, priority));
    }

    @Deprecated(forRemoval=true, since="1.20.1-0.7.39")
    public static <T extends BlockEntity> void registerBlockEntityIntegration(Function<BlockEntity, BlockEntityIntegrationPeripheral<T>> integration, Class<T> tileClass, Predicate<T> predicate, int priority) {
        IntegrationPeripheralProvider.registerIntegration(new BlockEntityIntegration(integration, tile -> tileClass.isInstance(tile) && predicate.test(tile), priority));
    }

    public static void load() {
        ComputerCraftAPI.registerGenericSource((GenericSource)new BeaconIntegration());
        IntegrationPeripheralProvider.registerIntegration(new BlockIntegration(NoteBlockIntegration::new, NoteBlock.class::isInstance));
        for (String mod : SUPPORTED_MODS) {
            Optional<Object> integration = Platform.maybeLoadIntegration(mod, mod + ".Integration");
            integration.ifPresent(obj -> {
                AdvancedPeripherals.LOGGER.warn("Successfully loaded integration for {}", (Object)mod);
                ((Runnable)obj).run();
            });
            if (!integration.isEmpty()) continue;
            AdvancedPeripherals.LOGGER.warn("Failed to load integration for {}", (Object)mod);
        }
    }
}

