/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.client;

import de.srendi.advancedperipherals.AdvancedPeripherals;
import de.srendi.advancedperipherals.network.APNetworking;
import de.srendi.advancedperipherals.network.toserver.RetrieveUsernamePacket;
import java.util.HashMap;
import java.util.UUID;
import org.jetbrains.annotations.Nullable;

public class ClientUUIDCache {
    private static final HashMap<UUID, String> CACHE = new HashMap();

    private ClientUUIDCache() {
    }

    @Nullable
    public static String getUsername(UUID uuid, UUID requester) {
        if (CACHE.containsKey(uuid)) {
            return CACHE.get(uuid);
        }
        APNetworking.sendToServer(new RetrieveUsernamePacket(uuid, requester));
        return null;
    }

    public static void putUsername(UUID uuid, String username) {
        CACHE.put(uuid, username);
        AdvancedPeripherals.debug(String.format("Putting username %s with uuid %s into cache", username, uuid));
    }
}

