/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.appflux.common.me.cell;

import appeng.api.config.Actionable;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.cells.CellState;
import appeng.api.storage.cells.ISaveProvider;
import appeng.api.storage.cells.StorageCell;
import appeng.api.upgrades.IUpgradeInventory;
import appeng.core.definitions.AEItems;
import com.glodblock.github.appflux.api.IFluxCell;
import com.glodblock.github.appflux.common.AFSingletons;
import com.glodblock.github.appflux.common.me.key.FluxKey;
import com.glodblock.github.appflux.common.me.key.type.EnergyType;
import com.glodblock.github.appflux.common.me.key.type.FluxKeyType;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public abstract class FluxCellInventory
implements StorageCell {
    protected final IFluxCell cellType;
    protected final ItemStack stack;
    @Nullable
    protected final ISaveProvider container;
    protected long storedEnergy;
    protected boolean isPersisted = true;
    protected final boolean hasVoidUpgrade;

    public FluxCellInventory(IFluxCell cellType, ItemStack o, @Nullable ISaveProvider container) {
        this.cellType = cellType;
        this.stack = o;
        this.container = container;
        this.storedEnergy = (Long)o.getOrDefault(AFSingletons.FE_ENERGY, (Object)0L);
        this.hasVoidUpgrade = this.getUpgrades().isInstalled((ItemLike)AEItems.VOID_CARD);
    }

    public CellState getStatus() {
        if (this.storedEnergy == 0L) {
            return CellState.EMPTY;
        }
        if (this.storedEnergy == this.getMaxEnergy()) {
            return CellState.FULL;
        }
        return CellState.NOT_EMPTY;
    }

    public double getIdleDrain() {
        return this.cellType.getIdleDrain();
    }

    public long getStoredEnergy() {
        return this.storedEnergy;
    }

    public long getMaxEnergy() {
        return this.cellType.getBytes(this.stack) * (long)FluxKeyType.TYPE.getAmountPerByte();
    }

    public long getTotalBytes() {
        return this.cellType.getBytes(this.stack);
    }

    public long getUsedBytes() {
        long amountPerByte = FluxKeyType.TYPE.getAmountPerByte();
        return (this.storedEnergy + amountPerByte - 1L) / amountPerByte;
    }

    protected void saveChanges() {
        this.isPersisted = false;
        if (this.container != null) {
            this.container.saveChanges();
        } else {
            this.persist();
        }
    }

    public IUpgradeInventory getUpgrades() {
        return this.cellType.getUpgrades(this.stack);
    }

    public long insert(AEKey what, long amount, Actionable mode, IActionSource source) {
        if (!(what instanceof FluxKey)) {
            return 0L;
        }
        long inserted = Math.min(this.getMaxEnergy() - this.storedEnergy, amount);
        if (mode == Actionable.MODULATE) {
            this.storedEnergy += inserted;
            this.saveChanges();
        }
        return this.hasVoidUpgrade ? amount : inserted;
    }

    public long extract(AEKey what, long amount, Actionable mode, IActionSource source) {
        if (!(what instanceof FluxKey)) {
            return 0L;
        }
        long extracted = Math.min(this.storedEnergy, amount);
        if (mode == Actionable.MODULATE) {
            this.storedEnergy -= extracted;
            this.saveChanges();
        }
        return extracted;
    }

    public void persist() {
        if (this.isPersisted) {
            return;
        }
        if (this.storedEnergy <= 0L) {
            this.stack.remove(AFSingletons.FE_ENERGY);
        } else {
            this.stack.set(AFSingletons.FE_ENERGY, (Object)this.storedEnergy);
        }
        this.isPersisted = true;
    }

    public void getAvailableStacks(KeyCounter out) {
        if (this.storedEnergy > 0L) {
            out.add((AEKey)FluxKey.of(this.getEnergyType()), this.storedEnergy);
        }
    }

    protected abstract EnergyType getEnergyType();

    public Component getDescription() {
        return this.stack.getHoverName();
    }
}

