/*
 * Decompiled with CFR 0.152.
 */
package dev.su5ed.mffs.util.loot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.component.DataComponentPredicate;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;

public class MenuInventoryTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    public Codec<TriggerInstance> codec() {
        return TriggerInstance.CODEC;
    }

    public void trigger(ServerPlayer player, boolean active, IItemHandler itemHandler) {
        this.trigger(player, instance -> {
            if (instance.active != active) {
                return false;
            }
            ObjectArrayList list = new ObjectArrayList(instance.items);
            for (int i = 0; i < itemHandler.getSlots(); ++i) {
                ItemStack stackInSlot = itemHandler.getStackInSlot(i);
                list.removeIf(predicate -> predicate.test(stackInSlot));
            }
            return list.isEmpty();
        });
    }

    public record TriggerInstance(Optional<ContextAwarePredicate> player, MenuType<?> menuType, boolean active, List<ItemPredicate> items) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(TriggerInstance::player), (App)BuiltInRegistries.MENU.byNameCodec().fieldOf("menuType").forGetter(TriggerInstance::menuType), (App)Codec.BOOL.fieldOf("active").forGetter(TriggerInstance::active), (App)ItemPredicate.CODEC.listOf().fieldOf("items").forGetter(TriggerInstance::items)).apply((Applicative)instance, TriggerInstance::new));

        @SafeVarargs
        public static TriggerInstance create(MenuType<?> menuType, boolean active, Holder<Item> ... items) {
            List<ItemPredicate> predicates = Stream.of(items).map(holder -> new ItemPredicate(Optional.of(HolderSet.direct((Holder[])new Holder[]{holder})), MinMaxBounds.Ints.ANY, DataComponentPredicate.EMPTY, Map.of())).toList();
            return new TriggerInstance(Optional.empty(), menuType, active, predicates);
        }
    }
}

