/*
 * Decompiled with CFR 0.152.
 */
package dev.su5ed.mffs.util;

import java.util.function.BooleanSupplier;
import net.neoforged.neoforge.energy.EnergyStorage;

public class CustomEnergyStorage
extends EnergyStorage {
    private final BooleanSupplier canReceive;
    private final Runnable onChanged;

    public CustomEnergyStorage(int capacity, int maxTransfer, BooleanSupplier canReceive, Runnable onChanged) {
        super(capacity, maxTransfer, maxTransfer);
        this.canReceive = canReceive;
        this.onChanged = onChanged;
    }

    protected void onEnergyChanged() {
        this.onChanged.run();
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        int rc = super.receiveEnergy(maxReceive, simulate);
        if (rc > 0 && !simulate) {
            this.onEnergyChanged();
        }
        return rc;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        int rc = super.extractEnergy(maxExtract, simulate);
        if (rc > 0 && !simulate) {
            this.onEnergyChanged();
        }
        return rc;
    }

    public boolean canReceive() {
        return super.canReceive() && this.canReceive.getAsBoolean();
    }

    public void setEnergy(int energy) {
        this.energy = energy;
        this.onEnergyChanged();
    }

    public void setMaxTransfer(int maxTransfer) {
        this.maxReceive = maxTransfer;
        this.maxExtract = maxTransfer;
    }

    public int getRequestedEnergy() {
        return this.getMaxEnergyStored() - this.getEnergyStored();
    }

    public boolean canExtract(int extract) {
        return this.extractEnergy(extract, true) >= extract;
    }
}

